/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.async;

import java.util.ArrayList;
import java.util.Comparator;
import org.neo4j.annotations.service.Service;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.async.AsyncCompletionHandler;
import org.neo4j.io.async.AsyncFailureHandler;
import org.neo4j.io.async.IllegalStateExceptionFailureHandler;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.service.PrioritizedService;
import org.neo4j.service.Services;
import org.neo4j.util.FeatureToggles;

@Service
public interface AsyncIOProvider
extends PrioritizedService {
    public static final boolean PRINT_SERVICE_LOADER_STACK_TRACES = FeatureToggles.flag(AsyncIOProvider.class, (String)"printServiceLoaderStackTraces", (boolean)false);

    public AsyncBlockAccessor createAsyncBlockAccessor(int var1, AsyncCompletionHandler var2, AsyncFailureHandler var3, MemoryTracker var4);

    public String describe();

    public static AsyncIOProvider getInstance() {
        return AsyncIOProviderHolder.ASYNC_IO_PROVIDER;
    }

    public static final class AsyncIOProviderHolder {
        private static final AsyncIOProvider ASYNC_IO_PROVIDER = AsyncIOProviderHolder.loadProvider();

        private static AsyncIOProvider loadProvider() {
            ArrayList<AsyncIOProvider> availableIOProviders = new ArrayList<AsyncIOProvider>(Services.loadAll(AsyncIOProvider.class));
            availableIOProviders.sort(Comparator.comparingInt(PrioritizedService::getPriority));
            for (AsyncIOProvider provider : availableIOProviders) {
                try {
                    AsyncIOProviderHolder.createTestAccessor(provider);
                    return provider;
                }
                catch (Throwable t) {
                    if (!PRINT_SERVICE_LOADER_STACK_TRACES) continue;
                    t.printStackTrace();
                }
            }
            throw new IllegalStateException(new IllegalStateException("Failed to load instance of " + String.valueOf(AsyncIOProvider.class)));
        }

        private static void createTestAccessor(AsyncIOProvider provider) {
            AsyncBlockAccessor testAccessor = provider.createAsyncBlockAccessor(128, AsyncCompletionHandler.EMPTY_COMPLETION_HANDLER, IllegalStateExceptionFailureHandler.ILLEGAL_STATE_HANDLER, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            if (testAccessor != null) {
                testAccessor.close();
            }
        }
    }
}

