/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.async.AsyncCompletionHandler;
import org.neo4j.io.async.AsyncVectorIOData;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.async.AsyncFlushCompletion;

public class AsyncCheckpointCompletionHandler
implements AsyncCompletionHandler {
    private final DatabaseFlushEvent flushEvent;

    public AsyncCheckpointCompletionHandler(DatabaseFlushEvent flushEvent) {
        this.flushEvent = flushEvent;
    }

    @Override
    public void handleCompletion(AsyncBlockAccessor accessor, long data, int result) {
        try (AsyncFlushCompletion completionEvent = this.flushEvent.asyncFlushCompletion();){
            AsyncVectorIOData asyncVectorIO = accessor.asyncVectorIOData(data);
            long[] ioPages = asyncVectorIO.pages();
            long[] ioFlushStamps = asyncVectorIO.flushStamps();
            for (int i = 0; i < ioPages.length; ++i) {
                PageList.unlockFlush(ioPages[i], ioFlushStamps[i], true);
            }
            completionEvent.addBytesWritten(ioPages.length * 8192);
            completionEvent.addPagesCompleted(ioPages.length);
            completionEvent.reportIO(asyncVectorIO.numberOfBuffers());
        }
    }
}

