/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.cursor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.io.pagecache.impl.muninn.swapper.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFileSwapperTracer;
import org.neo4j.io.pagecache.tracing.PageReferenceTranslator;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.PinPageFaultEvent;
import org.neo4j.io.pagecache.tracing.PrefetchEvent;
import org.neo4j.io.pagecache.tracing.VectoredPageFaultEvent;
import org.neo4j.io.pagecache.tracing.async.AsyncEvictionEvent;
import org.neo4j.io.pagecache.tracing.async.SubmitEvent;
import org.neo4j.io.pagecache.tracing.cursor.CursorStatisticSnapshot;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.util.FeatureToggles;

public class DefaultPageCursorTracer
implements PageCursorTracer {
    private static final boolean DEBUG_PINS = false;
    private static final ConcurrentMap<Pair<Path, Long>, Exception> PIN_DEBUG_MAP = null;
    private static final boolean CHECK_REPORTED_COUNTERS = FeatureToggles.flag(DefaultPageCursorTracer.class, (String)"CHECK_REPORTED_COUNTERS", (boolean)false);
    private long pins;
    private long unpins;
    private long hits;
    private long faults;
    private long noFaults;
    private long failedFaults;
    private long vectoredFaults;
    private long failedVectoredFaults;
    private long noPinFaults;
    private long bytesRead;
    private long bytesWritten;
    private long evictions;
    private long evictionFlushes;
    private long evictionExceptions;
    private long flushes;
    private long merges;
    private long snapshotsLoaded;
    private long copiesCreated;
    private long pagesPrefetched;
    private long pagesPrefetchedWithFaults;
    private long openedCursors;
    private long closedCursors;
    private final DefaultPinEvent pinTracingEvent = new DefaultPinEvent();
    private final PageFaultEvictionEvent evictionEvent = new PageFaultEvictionEvent();
    private final DefaultPinPageFaultEvent pageFaultEvent = new DefaultPinPageFaultEvent();
    private final DefaultVectoredPageFaultEvent vectoredPageFaultEvent = new DefaultVectoredPageFaultEvent();
    private final AsyncPageEvictionEvent asyncEvictionEvent = new AsyncPageEvictionEvent();
    private final AsyncSubmitEvent submitEvent = new AsyncSubmitEvent();
    private final DefaultFlushEvent flushEvent = new DefaultFlushEvent();
    private final DefaultPrefetchEvent prefetchEvent = new DefaultPrefetchEvent();
    private final PageCacheTracer pageCacheTracer;
    private final String tag;
    private boolean ignoreCounterCheck;

    public DefaultPageCursorTracer(PageCacheTracer pageCacheTracer, String tag) {
        this.pageCacheTracer = pageCacheTracer;
        this.tag = tag;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void openCursor() {
        ++this.openedCursors;
    }

    @Override
    public long openedCursors() {
        return this.openedCursors;
    }

    @Override
    public void closeCursor() {
        ++this.closedCursors;
    }

    @Override
    public long closedCursors() {
        return this.closedCursors;
    }

    @Override
    public void merge(CursorStatisticSnapshot statisticSnapshot) {
        this.pins += statisticSnapshot.pins();
        this.unpins += statisticSnapshot.unpins();
        this.hits += statisticSnapshot.hits();
        this.faults += statisticSnapshot.faults();
        this.noFaults += statisticSnapshot.noFaults();
        this.failedFaults += statisticSnapshot.failedFaults();
        this.vectoredFaults += statisticSnapshot.vectoredFaults();
        this.failedVectoredFaults += statisticSnapshot.failedVectoredFaults();
        this.noPinFaults += statisticSnapshot.noPinFaults();
        this.bytesRead += statisticSnapshot.bytesRead();
        this.bytesWritten += statisticSnapshot.bytesWritten();
        this.evictions += statisticSnapshot.evictions();
        this.evictionFlushes += statisticSnapshot.evictionFlushes();
        this.evictionExceptions += statisticSnapshot.evictionExceptions();
        this.flushes += statisticSnapshot.flushes();
        this.merges += statisticSnapshot.merges();
        this.snapshotsLoaded += statisticSnapshot.snapshotsLoaded();
        this.copiesCreated += statisticSnapshot.copiedPages();
        this.openedCursors += statisticSnapshot.openedCursors();
        this.closedCursors += statisticSnapshot.closedCursors();
    }

    @Override
    public void pageCopied(long pageRef, long version) {
        ++this.copiesCreated;
    }

    @Override
    public void reportEvents() {
        if (CHECK_REPORTED_COUNTERS && !this.ignoreCounterCheck) {
            this.checkCounters();
        }
        if (this.pins > 0L) {
            this.pageCacheTracer.pins(this.pins);
        }
        if (this.unpins > 0L) {
            this.pageCacheTracer.unpins(this.unpins);
        }
        if (this.hits > 0L) {
            this.pageCacheTracer.hits(this.hits);
        }
        if (this.faults > 0L) {
            this.pageCacheTracer.faults(this.faults);
        }
        if (this.noFaults > 0L) {
            this.pageCacheTracer.noFaults(this.noFaults);
        }
        if (this.failedFaults > 0L) {
            this.pageCacheTracer.failedFaults(this.failedFaults);
        }
        if (this.vectoredFaults > 0L) {
            this.pageCacheTracer.vectoredFaults(this.vectoredFaults);
        }
        if (this.failedVectoredFaults > 0L) {
            this.pageCacheTracer.failedVectoredFaults(this.vectoredFaults);
        }
        if (this.noPinFaults > 0L) {
            this.pageCacheTracer.noPinFaults(this.noPinFaults);
        }
        if (this.bytesRead > 0L) {
            this.pageCacheTracer.bytesRead(this.bytesRead);
        }
        if (this.evictions > 0L) {
            this.pageCacheTracer.evictions(this.evictions);
            this.pageCacheTracer.cooperativeEvictions(this.evictions);
        }
        if (this.evictionFlushes > 0L) {
            this.pageCacheTracer.cooperativeEvictionFlushes(this.evictionFlushes);
        }
        if (this.evictionExceptions > 0L) {
            this.pageCacheTracer.evictionExceptions(this.evictionExceptions);
        }
        if (this.bytesWritten > 0L) {
            this.pageCacheTracer.bytesWritten(this.bytesWritten);
        }
        if (this.flushes > 0L) {
            this.pageCacheTracer.flushes(this.flushes);
        }
        if (this.merges > 0L) {
            this.pageCacheTracer.merges(this.merges);
        }
        if (this.snapshotsLoaded > 0L) {
            this.pageCacheTracer.snapshotsLoaded(this.snapshotsLoaded);
        }
        if (this.copiesCreated > 0L) {
            this.pageCacheTracer.pagesCopied(this.copiesCreated);
        }
        if (this.pagesPrefetched > 0L) {
            this.pageCacheTracer.pagesPrefetched(this.pagesPrefetched);
        }
        if (this.pagesPrefetchedWithFaults > 0L) {
            this.pageCacheTracer.pagesPrefetchedWithFaults(this.pagesPrefetchedWithFaults);
        }
        if (this.openedCursors > 0L) {
            this.pageCacheTracer.openedCursors(this.openedCursors);
        }
        if (this.closedCursors > 0L) {
            this.pageCacheTracer.closedCursors(this.closedCursors);
        }
        this.reset();
    }

    private void checkCounters() {
        boolean unpinsInvariant;
        boolean pinsInvariant = this.pins == this.hits + this.faults + this.noFaults - this.noPinFaults;
        boolean bl = unpinsInvariant = this.unpins == this.hits + this.faults - this.failedFaults - this.noPinFaults;
        if (!pinsInvariant || !unpinsInvariant) {
            throw new RuntimeException("Mismatch cursor counters. " + String.valueOf(this));
        }
    }

    public String toString() {
        return "PageCursorTracer{pins=" + this.pins + ", unpins=" + this.unpins + ", hits=" + this.hits + ", faults=" + this.faults + ", noFaults=" + this.noFaults + ", failedFaults=" + this.failedFaults + ", vectoredFaults=" + this.vectoredFaults + ", failedVectoredFaults=" + this.failedVectoredFaults + ", noPinFaults=" + this.noPinFaults + ", bytesRead=" + this.bytesRead + ", bytesWritten=" + this.bytesWritten + ", evictions=" + this.evictions + ", evictionExceptions=" + this.evictionExceptions + ", flushes=" + this.flushes + ", merges=" + this.merges + ", tag='" + this.tag + "'}";
    }

    private String currentPins() {
        assert (false);
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        try (PrintStream out = new PrintStream(byteArrayOut);){
            PIN_DEBUG_MAP.forEach((pin, stackTrace) -> {
                out.println();
                stackTrace.printStackTrace(out);
            });
        }
        return byteArrayOut.toString();
    }

    protected void reset() {
        this.pins = 0L;
        this.unpins = 0L;
        this.hits = 0L;
        this.faults = 0L;
        this.noFaults = 0L;
        this.failedFaults = 0L;
        this.vectoredFaults = 0L;
        this.failedVectoredFaults = 0L;
        this.noPinFaults = 0L;
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.evictions = 0L;
        this.evictionFlushes = 0L;
        this.evictionExceptions = 0L;
        this.flushes = 0L;
        this.merges = 0L;
        this.snapshotsLoaded = 0L;
        this.copiesCreated = 0L;
        this.openedCursors = 0L;
        this.closedCursors = 0L;
    }

    @Override
    public long faults() {
        return this.faults;
    }

    @Override
    public long failedFaults() {
        return this.failedFaults;
    }

    @Override
    public long noFaults() {
        return this.noFaults;
    }

    @Override
    public long vectoredFaults() {
        return this.vectoredFaults;
    }

    @Override
    public long failedVectoredFaults() {
        return this.failedVectoredFaults;
    }

    @Override
    public long noPinFaults() {
        return this.noPinFaults;
    }

    @Override
    public long pins() {
        return this.pins;
    }

    @Override
    public long unpins() {
        return this.unpins;
    }

    @Override
    public long hits() {
        return this.hits;
    }

    @Override
    public long bytesRead() {
        return this.bytesRead;
    }

    @Override
    public long evictions() {
        return this.evictions;
    }

    @Override
    public long evictionFlushes() {
        return this.evictionFlushes;
    }

    @Override
    public long evictionExceptions() {
        return this.evictionExceptions;
    }

    @Override
    public long bytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long flushes() {
        return this.flushes;
    }

    @Override
    public long merges() {
        return this.merges;
    }

    @Override
    public long snapshotsLoaded() {
        return this.snapshotsLoaded;
    }

    @Override
    public double hitRatio() {
        return MathUtil.portion((double[])new double[]{this.hits(), this.faults()});
    }

    @Override
    public long copiedPages() {
        return this.copiesCreated;
    }

    @Override
    public PinEvent beginPin(boolean writeLock, long filePageId, PageSwapper swapper) {
        this.pinTracingEvent.swapperTracer = swapper.fileSwapperTracer();
        return this.pinTracingEvent;
    }

    @Override
    public void unpin(long filePageId, PageSwapper swapper) {
        ++this.unpins;
        swapper.fileSwapperTracer().unpins(1L);
    }

    @Override
    public VectoredPageFaultEvent beginVectoredPageFault(PageSwapper pageSwapper) {
        this.vectoredPageFaultEvent.swapperTracer = pageSwapper.fileSwapperTracer();
        return this.vectoredPageFaultEvent;
    }

    @Override
    public PrefetchEvent beginPrefetch(PageFileSwapperTracer fileTracer) {
        this.prefetchEvent.swapperTracer = fileTracer;
        return this.prefetchEvent;
    }

    public void setIgnoreCounterCheck(boolean ignoreCounterCheck) {
        this.ignoreCounterCheck = ignoreCounterCheck;
    }

    private class DefaultPinEvent
    implements PinEvent {
        private PageFileSwapperTracer swapperTracer;

        private DefaultPinEvent() {
        }

        @Override
        public void setCachePageId(long cachePageId) {
        }

        @Override
        public PinPageFaultEvent beginPageFault(long filePageId, PageSwapper pageSwapper) {
            DefaultPageCursorTracer.this.pageFaultEvent.swapperTracer = pageSwapper.fileSwapperTracer();
            return DefaultPageCursorTracer.this.pageFaultEvent;
        }

        @Override
        public void hit() {
            ++DefaultPageCursorTracer.this.hits;
            this.swapperTracer.hits(1L);
        }

        @Override
        public void noFault() {
            ++DefaultPageCursorTracer.this.noFaults;
            this.swapperTracer.noFaults(1L);
        }

        @Override
        public void close() {
            ++DefaultPageCursorTracer.this.pins;
            this.swapperTracer.pins(1L);
        }

        @Override
        public void snapshotsLoaded(int oldSnapshotsLoaded) {
            DefaultPageCursorTracer.this.snapshotsLoaded += (long)oldSnapshotsLoaded;
        }
    }

    private class PageFaultEvictionEvent
    implements EvictionEvent {
        private PageFileSwapperTracer swapperTracer;

        private PageFaultEvictionEvent() {
        }

        @Override
        public void setFilePageId(long filePageId) {
        }

        @Override
        public void setSwapper(PageSwapper swapper) {
            this.swapperTracer = swapper.fileSwapperTracer();
        }

        @Override
        public FlushEvent beginFlush(long pageRef, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator) {
            DefaultPageCursorTracer.this.flushEvent.swapperTracer = swapper.fileSwapperTracer();
            return DefaultPageCursorTracer.this.flushEvent;
        }

        @Override
        public void setException(IOException exception) {
            ++DefaultPageCursorTracer.this.evictionExceptions;
            this.swapperTracer.evictionExceptions(1L);
        }

        @Override
        public void close() {
            ++DefaultPageCursorTracer.this.evictions;
            if (this.swapperTracer != null) {
                this.swapperTracer.evictions(1L);
            }
        }
    }

    private class DefaultPinPageFaultEvent
    implements PinPageFaultEvent {
        private PageFileSwapperTracer swapperTracer;

        private DefaultPinPageFaultEvent() {
        }

        @Override
        public void addBytesRead(long bytes) {
            DefaultPageCursorTracer.this.bytesRead += bytes;
            this.swapperTracer.bytesRead(DefaultPageCursorTracer.this.bytesRead);
        }

        @Override
        public void close() {
            ++DefaultPageCursorTracer.this.faults;
            this.swapperTracer.faults(1L);
            DefaultPageCursorTracer.this.prefetchEvent.faults(1);
        }

        @Override
        public void setException(Throwable throwable) {
            ++DefaultPageCursorTracer.this.failedFaults;
            this.swapperTracer.failedFaults(1L);
        }

        @Override
        public void freeListSize(int listSize) {
        }

        @Override
        public EvictionEvent beginEviction(long cachePageId) {
            return DefaultPageCursorTracer.this.evictionEvent;
        }

        @Override
        public AsyncEvictionEvent beginAsyncEviction(long cachePageId) {
            return DefaultPageCursorTracer.this.asyncEvictionEvent;
        }

        @Override
        public void setCachePageId(long cachePageId) {
        }
    }

    private class DefaultVectoredPageFaultEvent
    implements VectoredPageFaultEvent {
        private PageFileSwapperTracer swapperTracer;

        private DefaultVectoredPageFaultEvent() {
        }

        @Override
        public void addBytesRead(long bytes) {
            DefaultPageCursorTracer.this.bytesRead += bytes;
            this.swapperTracer.bytesRead(DefaultPageCursorTracer.this.bytesRead);
        }

        @Override
        public void close() {
            ++DefaultPageCursorTracer.this.vectoredFaults;
            this.swapperTracer.vectoredFaults(1L);
        }

        @Override
        public void setException(Throwable throwable) {
            ++DefaultPageCursorTracer.this.failedVectoredFaults;
            this.swapperTracer.failedVectoredFaults(1L);
        }

        @Override
        public void freeListSize(int listSize) {
        }

        @Override
        public EvictionEvent beginEviction(long cachePageId) {
            return DefaultPageCursorTracer.this.evictionEvent;
        }

        @Override
        public AsyncEvictionEvent beginAsyncEviction(long cachePageId) {
            return DefaultPageCursorTracer.this.asyncEvictionEvent;
        }

        @Override
        public void addPagesFaulted(int numberOfPages, long[] pageRefs, PageReferenceTranslator referenceTranslator) {
            DefaultPageCursorTracer.this.noPinFaults += (long)numberOfPages;
            DefaultPageCursorTracer.this.faults += (long)numberOfPages;
            this.swapperTracer.faults(numberOfPages);
            DefaultPageCursorTracer.this.prefetchEvent.faults(numberOfPages);
        }
    }

    private class AsyncPageEvictionEvent
    implements AsyncEvictionEvent {
        private PageFileSwapperTracer swapperTracer;

        private AsyncPageEvictionEvent() {
        }

        @Override
        public void setFilePageId(long filePageId) {
        }

        @Override
        public void setSwapper(PageSwapper swapper) {
            this.swapperTracer = swapper.fileSwapperTracer();
        }

        @Override
        public void setException(Exception exception) {
            ++DefaultPageCursorTracer.this.evictionExceptions;
            this.swapperTracer.evictionExceptions(1L);
        }

        @Override
        public SubmitEvent beginAsyncSubmit(long pageRef, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator) {
            return DefaultPageCursorTracer.this.submitEvent;
        }

        @Override
        public void evicted() {
            ++DefaultPageCursorTracer.this.evictions;
        }

        @Override
        public void close() {
        }
    }

    private static class AsyncSubmitEvent
    implements SubmitEvent {
        private AsyncSubmitEvent() {
        }

        @Override
        public void addSubmittedPages(int pageCount) {
        }

        @Override
        public void setException(Exception e) {
        }

        @Override
        public void addPagesMerged(int pageCount) {
        }

        @Override
        public void close() {
        }
    }

    private class DefaultFlushEvent
    implements FlushEvent {
        private PageFileSwapperTracer swapperTracer;

        private DefaultFlushEvent() {
        }

        @Override
        public void addBytesWritten(long bytes) {
            DefaultPageCursorTracer.this.bytesWritten += bytes;
            this.swapperTracer.bytesWritten(DefaultPageCursorTracer.this.bytesWritten);
        }

        @Override
        public void close() {
        }

        @Override
        public void setException(IOException exception) {
        }

        @Override
        public void addPagesFlushed(int flushedPages) {
            DefaultPageCursorTracer.this.flushes += (long)flushedPages;
            this.swapperTracer.flushes(flushedPages);
        }

        @Override
        public void addEvictionFlushedPages(int pageCount) {
            DefaultPageCursorTracer.this.evictionFlushes += (long)pageCount;
            this.addPagesFlushed(pageCount);
        }

        @Override
        public void addPagesMerged(int pagesMerged) {
            DefaultPageCursorTracer.this.merges += (long)pagesMerged;
            this.swapperTracer.merges(pagesMerged);
        }
    }

    private class DefaultPrefetchEvent
    implements PrefetchEvent {
        private PageFileSwapperTracer swapperTracer;

        private DefaultPrefetchEvent() {
        }

        @Override
        public void pagesPrefetched(int count) {
            DefaultPageCursorTracer.this.pagesPrefetched += (long)count;
            this.swapperTracer.pagesPrefetched(count);
        }

        @Override
        public void close() {
            this.swapperTracer = null;
        }

        private void faults(int numberOfPages) {
            if (this.swapperTracer != null) {
                DefaultPageCursorTracer.this.pagesPrefetchedWithFaults += (long)numberOfPages;
                this.swapperTracer.pagesPrefetchedWithFaults(numberOfPages);
            }
        }
    }
}

