/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import java.io.Serializable;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.cypher.internal.planner.spi.ReadTokenContext;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.ValuePopulation;
import org.neo4j.cypher.internal.runtime.interpreted.commands.AstNode;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.ValuePopulatingReferenceByName$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LazyPropertyKey;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.FullNodeReference;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u0010 \u0001BB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t#\u0002\u0011\t\u0012)A\u0005\u0013\"A!\u000b\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005a\u0001\tE\t\u0015!\u0003U\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015)\b\u0001\"\u0011w\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!a\u000e\u0001\t\u0013\tI\u0004C\u0004\u00028\u0001!I!a\u0014\t\u0013\u0005}\u0003!!A\u0005\u0002\u0005\u0005\u0004\"CA4\u0001E\u0005I\u0011AA5\u0011%\ty\bAI\u0001\n\u0003\t\t\tC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0011\u0002\b\"I\u0011q\u0013\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003C\u0003\u0011\u0011!C\u0001\u0003GC\u0011\"!+\u0001\u0003\u0003%\t%a+\t\u0013\u0005M\u0006!!A\u0005\u0002\u0005U\u0006\"CA`\u0001\u0005\u0005I\u0011IAa\u0011%\t)\rAA\u0001\n\u0003\n9\rC\u0005\u0002J\u0002\t\t\u0011\"\u0011\u0002L\u001eI\u0011qZ\u0010\u0002\u0002#\u0005\u0011\u0011\u001b\u0004\t=}\t\t\u0011#\u0001\u0002T\"1\u0011\r\u0007C\u0001\u0003SD\u0011\"a;\u0019\u0003\u0003%)%!<\t\u0013\u0005E\u0001$!A\u0005\u0002\u0006=\b\"CA{1\u0005\u0005I\u0011QA|\u0011%\u0011)\u0001GA\u0001\n\u0013\u00119A\u0001\u0010WC2,X\rU8qk2\fG/\u001b8h%\u00164WM]3oG\u0016\u0014\u0015PT1nK*\u0011\u0001%I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002#G\u0005A1m\\7nC:$7O\u0003\u0002%K\u0005Y\u0011N\u001c;feB\u0014X\r^3e\u0015\t1s%A\u0004sk:$\u0018.\\3\u000b\u0005!J\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005)Z\u0013AB2za\",'O\u0003\u0002-[\u0005)a.Z85U*\ta&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001cUZ\u0004C\u0001\u001a4\u001b\u0005y\u0012B\u0001\u001b \u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\b!J|G-^2u!\taDI\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iL\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!aQ\u001c\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0007^\n1aY8m+\u0005I\u0005C\u0001&O\u001d\tYE\n\u0005\u0002?o%\u0011QjN\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002No\u0005!1m\u001c7!\u0003A\u0019\u0017m\u00195fIB\u0013x\u000e]3si&,7/F\u0001U!\r1TkV\u0005\u0003-^\u0012Q!\u0011:sCf\u0004BA\u000e-[c%\u0011\u0011l\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005msV\"\u0001/\u000b\u0005u\u001b\u0013!\u00029ja\u0016\u001c\u0018BA0]\u0005=a\u0015M_=Qe>\u0004XM\u001d;z\u0017\u0016L\u0018!E2bG\",G\r\u0015:pa\u0016\u0014H/[3tA\u00051A(\u001b8jiz\"2a\u00193f!\t\u0011\u0004\u0001C\u0003H\u000b\u0001\u0007\u0011\nC\u0003S\u000b\u0001\u0007A+A\u0004sK^\u0014\u0018\u000e^3\u0015\u0005EB\u0007\"B5\u0007\u0001\u0004Q\u0017!\u00014\u0011\tYZ\u0017'M\u0005\u0003Y^\u0012\u0011BR;oGRLwN\\\u0019\u0002\u0013\u0005\u0014x-^7f]R\u001cX#A8\u0011\u0007A\u001c\u0018'D\u0001r\u0015\t\u0011x'\u0001\u0006d_2dWm\u0019;j_:L!\u0001^9\u0003\u0007M+\u0017/\u0001\u0005dQ&dGM]3o+\u00059\bc\u00019tqB\u0012\u0011p \t\u0004unlX\"A\u0011\n\u0005q\f#aB!ti:{G-\u001a\t\u0003}~d\u0001\u0001B\u0006\u0002\u0002!\t\t\u0011!A\u0003\u0002\u0005\r!aA0%eE!\u0011QAA\u0006!\r1\u0014qA\u0005\u0004\u0003\u00139$a\u0002(pi\"Lgn\u001a\t\u0004m\u00055\u0011bAA\bo\t\u0019\u0011I\\=\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005U\u0011\u0011EA\u0017!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000eW\u00051a/\u00197vKNLA!a\b\u0002\u001a\tA\u0011I\\=WC2,X\rC\u0004\u0002$%\u0001\r!!\n\u0002\u0007I|w\u000f\u0005\u0003\u0002(\u0005%R\"A\u0013\n\u0007\u0005-REA\u0006SK\u0006$\u0017M\u00197f%><\bbBA\u0018\u0013\u0001\u0007\u0011\u0011G\u0001\u0006gR\fG/\u001a\t\u00047\u0006M\u0012bAA\u001b9\nQ\u0011+^3ssN#\u0018\r^3\u0002\u0011A|\u0007/\u001e7bi\u0016$\u0002\"a\u000f\u0002H\u0005-\u0013Q\n\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)!\u0011\u0011IA\r\u0003\u001d1\u0018N\u001d;vC2LA!!\u0012\u0002@\t\u0001b+\u001b:uk\u0006dgj\u001c3f-\u0006dW/\u001a\u0005\b\u0003\u0013R\u0001\u0019AA\u001e\u0003\u0011qw\u000eZ3\t\u000f\u0005\r\"\u00021\u0001\u0002&!9\u0011q\u0006\u0006A\u0002\u0005EB\u0003CA)\u0003/\nY&!\u0018\u0011\t\u0005u\u00121K\u0005\u0005\u0003+\nyD\u0001\rWSJ$X/\u00197SK2\fG/[8og\"L\u0007OV1mk\u0016Dq!!\u0017\f\u0001\u0004\t\t&A\u0002sK2Dq!a\t\f\u0001\u0004\t)\u0003C\u0004\u00020-\u0001\r!!\r\u0002\t\r|\u0007/\u001f\u000b\u0006G\u0006\r\u0014Q\r\u0005\b\u000f2\u0001\n\u00111\u0001J\u0011\u001d\u0011F\u0002%AA\u0002Q\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002l)\u001a\u0011*!\u001c,\u0005\u0005=\u0004\u0003BA9\u0003wj!!a\u001d\u000b\t\u0005U\u0014qO\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001f8\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003{\n\u0019HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0004*\u001aA+!\u001c\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\t\u0005\u0003\u0002\f\u0006UUBAAG\u0015\u0011\ty)!%\u0002\t1\fgn\u001a\u0006\u0003\u0003'\u000bAA[1wC&\u0019q*!$\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0005c\u0001\u001c\u0002\u001e&\u0019\u0011qT\u001c\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005-\u0011Q\u0015\u0005\n\u0003O\u000b\u0012\u0011!a\u0001\u00037\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAW!\u0015\u0001\u0018qVA\u0006\u0013\r\t\t,\u001d\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00028\u0006u\u0006c\u0001\u001c\u0002:&\u0019\u00111X\u001c\u0003\u000f\t{w\u000e\\3b]\"I\u0011qU\n\u0002\u0002\u0003\u0007\u00111B\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\n\u0006\r\u0007\"CAT)\u0005\u0005\t\u0019AAN\u0003!A\u0017m\u001d5D_\u0012,GCAAN\u0003\u0019)\u0017/^1mgR!\u0011qWAg\u0011%\t9KFA\u0001\u0002\u0004\tY!\u0001\u0010WC2,X\rU8qk2\fG/\u001b8h%\u00164WM]3oG\u0016\u0014\u0015PT1nKB\u0011!\u0007G\n\u00061\u0005U\u0017q\u001c\t\b\u0003/\fY.\u0013+d\u001b\t\tIN\u0003\u0002'o%!\u0011Q\\Am\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003C\f9/\u0004\u0002\u0002d*!\u0011Q]AI\u0003\tIw.C\u0002F\u0003G$\"!!5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!#\u0015\u000b\r\f\t0a=\t\u000b\u001d[\u0002\u0019A%\t\u000bI[\u0002\u0019\u0001+\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011 B\u0001!\u00151\u00141`A\u0000\u0013\r\tip\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\tYB\u0016\n\u0016\u0005\t\u0005\u0007a\u0012\u0011!a\u0001G\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t%\u0001\u0003BAF\u0005\u0017IAA!\u0004\u0002\u000e\n1qJ\u00196fGR\u0004")
public class ValuePopulatingReferenceByName
extends Expression
implements Product,
Serializable {
    private final String col;
    private final Tuple2<LazyPropertyKey, Expression>[] cachedProperties;

    public static Option<Tuple2<String, Tuple2<LazyPropertyKey, Expression>[]>> unapply(ValuePopulatingReferenceByName x$0) {
        return ValuePopulatingReferenceByName$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<String, Tuple2<LazyPropertyKey, Expression>[]>, ValuePopulatingReferenceByName> tupled() {
        return ValuePopulatingReferenceByName$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Tuple2<LazyPropertyKey, Expression>[], ValuePopulatingReferenceByName>> curried() {
        return ValuePopulatingReferenceByName$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String col() {
        return this.col;
    }

    public Tuple2<LazyPropertyKey, Expression>[] cachedProperties() {
        return this.cachedProperties;
    }

    @Override
    public Expression rewrite(Function1<Expression, Expression> f) {
        return (Expression)f.apply((Object)this);
    }

    @Override
    public Seq<Expression> arguments() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public Seq<AstNode<?>> children() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public AnyValue apply(ReadableRow row, QueryState state) {
        AnyValue result = row.getByName(this.col());
        if (state.prePopulateResults()) {
            AnyValue anyValue = result;
            if (anyValue instanceof VirtualNodeValue) {
                VirtualNodeValue virtualNodeValue = (VirtualNodeValue)anyValue;
                return this.populate(virtualNodeValue, row, state);
            }
            if (anyValue instanceof VirtualRelationshipValue) {
                VirtualRelationshipValue virtualRelationshipValue = (VirtualRelationshipValue)anyValue;
                return this.populate(virtualRelationshipValue, row, state);
            }
            return anyValue;
        }
        return result;
    }

    private VirtualNodeValue populate(VirtualNodeValue node, ReadableRow row, QueryState state) {
        VirtualNodeValue virtualNodeValue = node;
        if (virtualNodeValue instanceof NodeValue) {
            NodeValue nodeValue = (NodeValue)virtualNodeValue;
            return nodeValue;
        }
        long id = node.id();
        QueryContext dbAccess = state.query();
        NodeCursor nodeCursor = state.cursors().nodeCursor();
        dbAccess.singleNode(id, nodeCursor);
        String elementId = dbAccess.elementIdMapper().nodeElementId(id);
        if (!nodeCursor.next()) {
            return VirtualValues.nodeValue((long)id, (String)elementId, (TextArray)Values.EMPTY_TEXT_ARRAY, (MapValue)VirtualValues.EMPTY_MAP, (boolean)true);
        }
        MutableIntSet cachedTokens = IntSets.mutable.empty();
        MapValueBuilder builder = new MapValueBuilder();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.cachedProperties()), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LazyPropertyKey p = (LazyPropertyKey)tuple2._1();
                Expression e = (Expression)tuple2._2();
                cachedTokens.add(p.id((ReadTokenContext)dbAccess));
                AnyValue value = e.apply(row, state);
                return builder.add(p.name(), value);
            }
            throw new MatchError((Object)tuple2);
        });
        PropertyCursor propertyCursor = state.cursors().propertyCursor();
        nodeCursor.properties(propertyCursor, PropertySelection.ALL_PROPERTIES.excluding(value -> cachedTokens.contains(value)));
        return VirtualValues.nodeValue((long)id, (String)elementId, (TextArray)ValuePopulation.labels((DbAccess)dbAccess, (TokenSet)nodeCursor.labels()), (MapValue)ValuePopulation.properties((PropertyCursor)propertyCursor, (DbAccess)dbAccess, (MapValueBuilder)builder));
    }

    private VirtualRelationshipValue populate(VirtualRelationshipValue rel, ReadableRow row, QueryState state) {
        VirtualRelationshipValue virtualRelationshipValue = rel;
        if (virtualRelationshipValue instanceof RelationshipValue) {
            RelationshipValue relationshipValue = (RelationshipValue)virtualRelationshipValue;
            return relationshipValue;
        }
        long id = rel.id();
        QueryContext dbAccess = state.query();
        RelationshipScanCursor relCursor = state.cursors().relationshipScanCursor();
        dbAccess.singleRelationship(id, relCursor);
        ElementIdMapper idMapper = dbAccess.elementIdMapper();
        String elementId = idMapper.relationshipElementId(id);
        if (!relCursor.next()) {
            return VirtualValues.relationshipValue((long)id, (String)elementId, (VirtualNodeReference)ValuePopulation.MISSING_NODE, (VirtualNodeReference)ValuePopulation.MISSING_NODE, (TextValue)Values.EMPTY_STRING, (MapValue)VirtualValues.EMPTY_MAP, (boolean)true);
        }
        MutableIntSet cachedTokens = IntSets.mutable.empty();
        MapValueBuilder builder = new MapValueBuilder();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.cachedProperties()), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LazyPropertyKey p = (LazyPropertyKey)tuple2._1();
                Expression e = (Expression)tuple2._2();
                cachedTokens.add(p.id((ReadTokenContext)state.query()));
                AnyValue value = e.apply(row, state);
                return builder.add(p.name(), value);
            }
            throw new MatchError((Object)tuple2);
        });
        FullNodeReference start = VirtualValues.node((long)relCursor.sourceNodeReference(), (ElementIdMapper)idMapper);
        FullNodeReference end = VirtualValues.node((long)relCursor.targetNodeReference(), (ElementIdMapper)idMapper);
        PropertyCursor propertyCursor = state.cursors().propertyCursor();
        relCursor.properties(propertyCursor, PropertySelection.ALL_PROPERTIES.excluding(value -> cachedTokens.contains(value)));
        return VirtualValues.relationshipValue((long)id, (String)elementId, (VirtualNodeReference)start, (VirtualNodeReference)end, (TextValue)Values.stringValue((String)dbAccess.relationshipTypeName(relCursor.type())), (MapValue)ValuePopulation.properties((PropertyCursor)propertyCursor, (DbAccess)dbAccess, (MapValueBuilder)builder));
    }

    public ValuePopulatingReferenceByName copy(String col, Tuple2<LazyPropertyKey, Expression>[] cachedProperties) {
        return new ValuePopulatingReferenceByName(col, cachedProperties);
    }

    public String copy$default$1() {
        return this.col();
    }

    public Tuple2<LazyPropertyKey, Expression>[] copy$default$2() {
        return this.cachedProperties();
    }

    public String productPrefix() {
        return "ValuePopulatingReferenceByName";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.col();
            }
            case 1: {
                return this.cachedProperties();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ValuePopulatingReferenceByName;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "col";
            }
            case 1: {
                return "cachedProperties";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ValuePopulatingReferenceByName)) return false;
        boolean bl = true;
        if (!bl) return false;
        ValuePopulatingReferenceByName valuePopulatingReferenceByName = (ValuePopulatingReferenceByName)x$1;
        String string = this.col();
        String string2 = valuePopulatingReferenceByName.col();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.cachedProperties() != valuePopulatingReferenceByName.cachedProperties()) return false;
        if (!valuePopulatingReferenceByName.canEqual(this)) return false;
        return true;
    }

    public ValuePopulatingReferenceByName(String col, Tuple2<LazyPropertyKey, Expression>[] cachedProperties) {
        this.col = col;
        this.cachedProperties = cachedProperties;
        Product.$init$((Product)this);
    }
}

