/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.util.Objects;
import org.neo4j.configuration.helpers.DatabaseNameValidator;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class TransactionId$
implements Serializable {
    public static final TransactionId$ MODULE$ = new TransactionId$();
    private static final String org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR = "-transaction-";
    private static final String EXPECTED_FORMAT_MSG = "(expected format: <databasename>" + MODULE$.org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR() + "<id>)";
    private static final String RUNNING_STATE = "Running";
    private static final String CLOSING_STATE = "Closing";
    private static final String COMMITTING_STATE = "Committing";
    private static final String ROLLING_BACK_STATE = "Rolling back";
    private static final String BLOCKED_STATE = "Blocked by: ";
    private static final String TERMINATED_STATE = "Terminated with reason: %s";

    public String org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR() {
        return org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR;
    }

    private String EXPECTED_FORMAT_MSG() {
        return EXPECTED_FORMAT_MSG;
    }

    public String RUNNING_STATE() {
        return RUNNING_STATE;
    }

    public String CLOSING_STATE() {
        return CLOSING_STATE;
    }

    public String COMMITTING_STATE() {
        return COMMITTING_STATE;
    }

    public String ROLLING_BACK_STATE() {
        return ROLLING_BACK_STATE;
    }

    public String BLOCKED_STATE() {
        return BLOCKED_STATE;
    }

    public String TERMINATED_STATE() {
        return TERMINATED_STATE;
    }

    public TransactionId apply(String dbName, long internalId) {
        if (internalId < 0L) {
            throw InvalidArgumentsException.requiresPositiveIntegerInIds((long)internalId, (String)this.EXPECTED_FORMAT_MSG());
        }
        return new TransactionId(new NormalizedDatabaseName(Objects.requireNonNull(dbName)), internalId);
    }

    public TransactionId parse(String transactionIdText) throws InvalidArgumentsException {
        String tid = null;
        NormalizedDatabaseName database = null;
        try {
            int i = transactionIdText.lastIndexOf(this.org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR());
            if (i != -1) {
                database = new NormalizedDatabaseName(transactionIdText.substring(0, i));
                DatabaseNameValidator.validateInternalDatabaseName((NormalizedDatabaseName)database);
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(database.name()))) {
                    tid = transactionIdText.substring(i + this.org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$TransactionId$$SEPARATOR().length());
                    long internalId = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(tid));
                    return this.apply(database.name(), internalId);
                }
            }
        }
        catch (NumberFormatException e) {
            throw InvalidArgumentsException.cannotParseIdInvalidNumber((String)transactionIdText, tid, (String)this.EXPECTED_FORMAT_MSG(), (NumberFormatException)e);
        }
        catch (IllegalArgumentException e) {
            throw InvalidArgumentsException.cannotParseIdInvalidDatabase((String)transactionIdText, (String)database.name(), (String)this.EXPECTED_FORMAT_MSG(), (IllegalArgumentException)e);
        }
        throw InvalidArgumentsException.cannotParseId((String)transactionIdText, (String)this.EXPECTED_FORMAT_MSG());
    }

    public TransactionId apply(NormalizedDatabaseName database, long internalId) {
        return new TransactionId(database, internalId);
    }

    public Option<Tuple2<NormalizedDatabaseName, Object>> unapply(TransactionId x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.database(), (Object)BoxesRunTime.boxToLong((long)x$0.internalId())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TransactionId$.class);
    }

    private TransactionId$() {
    }
}

