/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import org.neo4j.cypher.internal.logical.plans.StatefulShortestPath;
import org.neo4j.cypher.internal.logical.plans.TraversalPathMode;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.CommandNFA;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.StatefulShortestPathPipe;
import org.neo4j.cypher.internal.util.attribution.Id$;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalPathModeFactory;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.Value;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple11;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class StatefulShortestPathPipe$
implements Serializable {
    public static final StatefulShortestPathPipe$ MODULE$ = new StatefulShortestPathPipe$();

    public int $lessinit$greater$default$12(Pipe source, String sourceNodeName, Option<String> intoTargetNodeName, CommandNFA commandNFA, StatefulShortestPath.LengthBounds bounds, Option<Predicate> preFilters, StatefulShortestPath.Selector selector, Expression kExpression, Set<String> grouped, boolean reverseGroupVariableProjections, TraversalPathMode pathMode) {
        return Id$.MODULE$.INVALID_ID();
    }

    public TraversalPathModeFactory traversalPathModeFactory(TraversalPathMode pathMode, MemoryTracker memoryTracker, PPBFSHooks hooks) {
        TraversalPathMode traversalPathMode = pathMode;
        if (TraversalPathMode.Trail$.MODULE$.equals(traversalPathMode)) {
            return TraversalPathModeFactory.trailMode((MemoryTracker)memoryTracker, (PPBFSHooks)hooks);
        }
        if (TraversalPathMode.Walk$.MODULE$.equals(traversalPathMode)) {
            return TraversalPathModeFactory.walkMode();
        }
        throw new MatchError((Object)traversalPathMode);
    }

    public int getPathCount(Expression kExpression, CypherRow inputRow, QueryState state) {
        boolean bl = false;
        IntegralValue integralValue = null;
        AnyValue anyValue = kExpression.apply((ReadableRow)inputRow, state);
        if (anyValue instanceof IntegralValue) {
            bl = true;
            integralValue = (IntegralValue)anyValue;
            if ((int)integralValue.longValue() > 0) {
                return (int)integralValue.longValue();
            }
        }
        if (bl) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, String.valueOf(integralValue.longValue())).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N02).withParam(GqlParams.StringParam.option, "count").withParam(GqlParams.NumberParam.value, (Number)Predef$.MODULE$.int2Integer((int)integralValue.longValue())).build()).build();
            throw new InvalidArgumentsException(gql, String.format("Count requires positive integer argument, got `%d`", BoxesRunTime.boxToInteger((int)((int)integralValue.longValue()))));
        }
        if (anyValue instanceof Value) {
            Value value = (Value)anyValue;
            throw CypherTypeException.expectedInteger((String)("Expected Integer but got " + value.getTypeName()), (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
        }
        throw CypherTypeException.expectedInteger((String)("Expected Integer but got " + anyValue.getTypeName()), (String)String.valueOf(anyValue), (String)CypherTypeValueMapper.valueType((AnyValue)anyValue));
    }

    public StatefulShortestPathPipe apply(Pipe source, String sourceNodeName, Option<String> intoTargetNodeName, CommandNFA commandNFA, StatefulShortestPath.LengthBounds bounds, Option<Predicate> preFilters, StatefulShortestPath.Selector selector, Expression kExpression, Set<String> grouped, boolean reverseGroupVariableProjections, TraversalPathMode pathMode, int id) {
        return new StatefulShortestPathPipe(source, sourceNodeName, intoTargetNodeName, commandNFA, bounds, preFilters, selector, kExpression, grouped, reverseGroupVariableProjections, pathMode, id);
    }

    public int apply$default$12(Pipe source, String sourceNodeName, Option<String> intoTargetNodeName, CommandNFA commandNFA, StatefulShortestPath.LengthBounds bounds, Option<Predicate> preFilters, StatefulShortestPath.Selector selector, Expression kExpression, Set<String> grouped, boolean reverseGroupVariableProjections, TraversalPathMode pathMode) {
        return Id$.MODULE$.INVALID_ID();
    }

    public Option<Tuple11<Pipe, String, Option<String>, CommandNFA, StatefulShortestPath.LengthBounds, Option<Predicate>, StatefulShortestPath.Selector, Expression, Set<String>, Object, TraversalPathMode>> unapply(StatefulShortestPathPipe x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple11((Object)x$0.source(), (Object)x$0.sourceNodeName(), x$0.intoTargetNodeName(), (Object)x$0.commandNFA(), (Object)x$0.bounds(), x$0.preFilters(), (Object)x$0.selector(), (Object)x$0.kExpression(), x$0.grouped(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.reverseGroupVariableProjections()), (Object)x$0.pathMode()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StatefulShortestPathPipe$.class);
    }

    private StatefulShortestPathPipe$() {
    }
}

