/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ApocGlobalComponents;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.service.Services;

public class RegisterComponentFactory
extends ExtensionFactory<Dependencies> {
    private InternalLog log;
    private GlobalProcedures globalProceduresRegistry;

    public RegisterComponentFactory() {
        super(ExtensionType.GLOBAL, "ApocRegisterComponent");
    }

    public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
        this.globalProceduresRegistry = dependencies.globalProceduresRegistry();
        this.log = dependencies.log().getUserLog(RegisterComponentFactory.class);
        return new RegisterComponentLifecycle();
    }

    public static interface Dependencies {
        public LogService log();

        public GlobalProcedures globalProceduresRegistry();
    }

    public class RegisterComponentLifecycle
    extends LifecycleAdapter {
        private final Map<Class, Map<String, Object>> resolvers = new ConcurrentHashMap<Class, Map<String, Object>>();

        public void addResolver(String databaseName, Class clazz, Object instance) {
            Map classInstanceMap = this.resolvers.computeIfAbsent(clazz, s -> new ConcurrentHashMap());
            classInstanceMap.put(databaseName, instance);
        }

        public void cleanUpResolver(String databaseName, Class clazz) {
            Map<String, Object> innerMap = this.resolvers.get(clazz);
            if (innerMap != null) {
                innerMap.remove(databaseName);
                if (innerMap.isEmpty()) {
                    this.resolvers.remove(clazz);
                }
            }
        }

        public Map<Class, Map<String, Object>> getResolvers() {
            return this.resolvers;
        }

        public void init() {
            for (ApocGlobalComponents c : Services.loadAll(ApocGlobalComponents.class)) {
                for (Class clazz2 : c.getContextClasses()) {
                    this.resolvers.put(clazz2, new ConcurrentHashMap());
                }
            }
            this.resolvers.forEach((clazz, dbFunctionMap) -> RegisterComponentFactory.this.globalProceduresRegistry.registerComponent(clazz, context -> {
                String databaseName = context.graphDatabaseAPI().databaseName();
                Object instance = dbFunctionMap.get(databaseName);
                if (instance == null) {
                    RegisterComponentFactory.this.log.warn("couldn't find a instance for clazz %s and database %s", new Object[]{clazz.getName(), databaseName});
                }
                return instance;
            }, true));
        }
    }
}

