/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

public class Product {
    @UserAggregationFunction(value="apoc.agg.product")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Returns the product of all non-null `INTEGER` and `FLOAT` values in the collection.")
    public ProductFunction productCypher5() {
        return new ProductFunction();
    }

    @Deprecated
    @UserAggregationFunction(name="apoc.agg.product", deprecatedBy="Cypher's `reduce()`: `RETURN reduce(x = 1, i IN values | x * i)`.")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Returns the product of all non-null `INTEGER` and `FLOAT` values in the collection.")
    public ProductFunction product() {
        return new ProductFunction();
    }

    public static class ProductFunction {
        private double doubleProduct = 1.0;
        private long longProduct = 1L;
        private int count = 0;

        @UserAggregationUpdate
        public void aggregate(@Name(value="value", description="A value to be multiplied in the aggregate.") Number number) {
            if (number != null) {
                if (number instanceof Long) {
                    this.longProduct = Math.multiplyExact(this.longProduct, number.longValue());
                } else if (number instanceof Double) {
                    this.doubleProduct *= number.doubleValue();
                }
                ++this.count;
            }
        }

        @UserAggregationResult
        public Number result() {
            if (this.count == 0) {
                return 0.0;
            }
            if (this.longProduct == 1L) {
                return this.doubleProduct;
            }
            if (this.doubleProduct == 1.0) {
                return this.longProduct;
            }
            return this.doubleProduct * (double)this.longProduct;
        }
    }
}

