/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.algo.PathFindingUtils;
import apoc.result.PathResult;
import apoc.result.WeightedPathResult;
import apoc.util.Util;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphalgo.BasicEvaluationContext;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.EvaluationContext;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;

public class PathFinding {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;

    @Procedure(value="apoc.algo.aStar")
    @Description(value="Runs the A* search algorithm to find the optimal path between two `NODE` values, using the given `RELATIONSHIP` property name for the cost function.")
    public Stream<WeightedPathResult> aStar(@Name(value="startNode", description="The node to start the search from.") Node startNode, @Name(value="endNode", description="The node to end the search on.") Node endNode, @Name(value="relTypesAndDirections", description="The relationship types to restrict the algorithm to. Relationship types are represented using APOC's rel-direction-pattern syntax; `[<]RELATIONSHIP_TYPE1[>]|[<]RELATIONSHIP_TYPE2[>]|...`.") String relTypesAndDirs, @Name(value="weightPropertyName", description="The name of the property to use as the weight.") String weightPropertyName, @Name(value="latPropertyName", description="The name of the property to use as the latitude.") String latPropertyName, @Name(value="lonPropertyName", description="The name of the property to use as the longitude.") String lonPropertyName) {
        PathFinder algo = GraphAlgoFactory.aStar((EvaluationContext)new BasicEvaluationContext(this.tx, this.db), PathFindingUtils.buildPathExpander(relTypesAndDirs), (CostEvaluator)CommonEvaluators.doubleCostEvaluator((String)weightPropertyName), (EstimateEvaluator)CommonEvaluators.geoEstimateEvaluator((String)latPropertyName, (String)lonPropertyName));
        return WeightedPathResult.streamWeightedPathResult(startNode, endNode, (PathFinder<WeightedPath>)algo);
    }

    @Procedure(value="apoc.algo.aStarConfig")
    @Description(value="Runs the A* search algorithm to find the optimal path between two `NODE` values, using the given `RELATIONSHIP` property name for the cost function.\nThis procedure looks for weight, latitude and longitude properties in the config.")
    public Stream<WeightedPathResult> aStarConfig(@Name(value="startNode", description="The node to start the search from.") Node startNode, @Name(value="endNode", description="The node to end the search on.") Node endNode, @Name(value="relTypesAndDirections", description="The relationship types to restrict the algorithm to. Relationship types are represented using APOC's rel-direction-pattern syntax; `[<]RELATIONSHIP_TYPE1[>]|[<]RELATIONSHIP_TYPE2[>]|...`.") String relTypesAndDirs, @Name(value="config", description="{ weight = 'distance' :: STRING, default = Double.MAX_VALUE :: FLOAT, y = 'latitude' :: STRING, x = 'longitude' :: STRING, pointPropName :: STRING }") Map<String, Object> config) {
        PathFindingUtils.GeoEstimateEvaluatorPointCustom estimateEvaluator;
        config = config == null ? Collections.emptyMap() : config;
        String relationshipCostPropertyKey = config.getOrDefault("weight", "distance").toString();
        double defaultCost = ((Number)config.getOrDefault("default", Double.MAX_VALUE)).doubleValue();
        String pointPropertyName = (String)config.get("pointPropName");
        if (pointPropertyName != null) {
            estimateEvaluator = new PathFindingUtils.GeoEstimateEvaluatorPointCustom(pointPropertyName);
        } else {
            String latPropertyName = config.getOrDefault("y", "latitude").toString();
            String lonPropertyName = config.getOrDefault("x", "longitude").toString();
            estimateEvaluator = CommonEvaluators.geoEstimateEvaluator((String)latPropertyName, (String)lonPropertyName);
        }
        PathFinder algo = GraphAlgoFactory.aStar((EvaluationContext)new BasicEvaluationContext(this.tx, this.db), PathFindingUtils.buildPathExpander(relTypesAndDirs), (CostEvaluator)CommonEvaluators.doubleCostEvaluator((String)relationshipCostPropertyKey, (double)defaultCost), (EstimateEvaluator)estimateEvaluator);
        return WeightedPathResult.streamWeightedPathResult(startNode, endNode, (PathFinder<WeightedPath>)algo);
    }

    @Procedure(value="apoc.algo.dijkstra")
    @Description(value="Runs Dijkstra's algorithm using the given `RELATIONSHIP` property as the cost function.")
    public Stream<WeightedPathResult> dijkstra(@Name(value="startNode", description="The node to start the search from.") Node startNode, @Name(value="endNode", description="The node to end the search on.") Node endNode, @Name(value="relTypesAndDirections", description="The relationship types to restrict the algorithm to. Relationship types are represented using APOC's rel-direction-pattern syntax; `[<]RELATIONSHIP_TYPE1[>]|[<]RELATIONSHIP_TYPE2[>]|...`.") String relTypesAndDirs, @Name(value="weightPropertyName", description="The name of the property to use as the weight.") String weightPropertyName, @Name(value="defaultWeight", defaultValue="NaN", description="The `defaultWeight` is used when no specific weight is provided for the given relationship or node. The default value for defaultWeight is NaN.") double defaultWeight, @Name(value="numberOfWantedPaths", defaultValue="1", description="The number of wanted paths to return.") long numberOfWantedPaths) {
        PathFinder algo = GraphAlgoFactory.dijkstra(PathFindingUtils.buildPathExpander(relTypesAndDirs), (relationship, direction) -> Util.toDouble(relationship.getProperty(weightPropertyName, (Object)defaultWeight)), (int)((int)numberOfWantedPaths));
        return WeightedPathResult.streamWeightedPathResult(startNode, endNode, (PathFinder<WeightedPath>)algo);
    }

    @NotThreadSafe
    @Procedure(value="apoc.algo.allSimplePaths")
    @Description(value="Runs a search algorithm to find all of the simple paths between the given `RELATIONSHIP` values, up to a max depth described by `maxNodes`.\nThe returned paths will not contain loops.")
    public Stream<PathResult> allSimplePaths(@Name(value="startNode", description="The node to start the search from.") Node startNode, @Name(value="endNode", description="The node to end the search on.") Node endNode, @Name(value="relTypesAndDirections", description="The relationship types to restrict the algorithm to. Relationship types are represented using APOC's rel-direction-pattern syntax; `[<]RELATIONSHIP_TYPE1[>]|[<]RELATIONSHIP_TYPE2[>]|...`.") String relTypesAndDirs, @Name(value="maxNodes", description="The max depth (in terms of nodes) the algorithm will explore.") long maxNodes) {
        PathFinder algo = GraphAlgoFactory.allSimplePaths((EvaluationContext)new BasicEvaluationContext(this.tx, this.db), PathFindingUtils.buildPathExpander(relTypesAndDirs), (int)((int)maxNodes));
        Iterable allPaths = algo.findAllPaths(startNode, endNode);
        return StreamSupport.stream(allPaths.spliterator(), false).map(PathResult::new);
    }
}

