/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.cypher.Cypher;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.neo4j.graphdb.Result;

class RunManyResultSpliterator
implements Spliterator<Cypher.RowResult>,
AutoCloseable {
    private final Result result;
    private final long start;
    private boolean statistics;
    private int rowCount;

    RunManyResultSpliterator(Result result, boolean statistics) {
        this.result = result;
        this.start = System.currentTimeMillis();
        this.statistics = statistics;
    }

    @Override
    public boolean tryAdvance(Consumer<? super Cypher.RowResult> action) {
        if (this.result.hasNext()) {
            action.accept(new Cypher.RowResult(this.rowCount++, this.result.next()));
            return true;
        }
        if (this.statistics) {
            Map<String, Object> stats = Cypher.toMap(this.result.getQueryStatistics(), System.currentTimeMillis() - this.start, this.rowCount);
            this.statistics = false;
            action.accept(new Cypher.RowResult(-1L, stats));
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public Spliterator<Cypher.RowResult> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.result.hasNext() ? Long.MAX_VALUE : 1L;
    }

    @Override
    public int characteristics() {
        return 16;
    }

    @Override
    public void close() {
        this.result.close();
    }
}

