/*
 * Decompiled with CFR 0.152.
 */
package apoc.data.url;

import apoc.util.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class ExtractURL {
    @UserFunction(value="apoc.data.url")
    @Description(value="Turns a URL into a `MAP`.")
    public Map<String, Object> parse(@Name(value="url", description="The URL to extract metadata from.") String value) {
        if (value == null) {
            return null;
        }
        try {
            Long port;
            URI u = new URI(value);
            Long l = port = u.getPort() == -1 ? null : Long.valueOf(u.getPort());
            if (u.getScheme() == null) {
                return null;
            }
            StringBuilder file = new StringBuilder(u.getPath());
            if (u.getQuery() != null) {
                file.append("?").append(u.getQuery());
            }
            return Util.map("protocol", u.getScheme(), "user", u.getUserInfo(), "host", u.getHost(), "port", port, "path", u.getPath(), "file", file.toString(), "query", u.getQuery(), "anchor", u.getFragment());
        }
        catch (URISyntaxException exc) {
            return null;
        }
    }
}

