/*
 * Decompiled with CFR 0.152.
 */
package apoc.example;

import apoc.util.Util;
import java.util.stream.Stream;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;

public class Examples {
    @Context
    public Transaction tx;
    @Context
    public ProcedureCallContext procedureCallContext;

    @NotThreadSafe
    @Procedure(name="apoc.example.movies", mode=Mode.WRITE)
    @Description(value="Seeds the database with the Neo4j movie dataset.")
    public Stream<ExamplesProgressInfo> movies() {
        long start = System.currentTimeMillis();
        String file = "movies.cypher";
        Result result = this.tx.execute(Util.prefixQuery(this.procedureCallContext, Util.readResourceFile(file)));
        QueryStatistics stats = result.getQueryStatistics();
        ExamplesProgressInfo progress = new ExamplesProgressInfo(stats.getNodesCreated(), stats.getRelationshipsCreated(), stats.getPropertiesSet(), System.currentTimeMillis() - start);
        result.close();
        return Stream.of(progress);
    }

    public static class ExamplesProgressInfo {
        @Description(value="The name of the file containing the movies example.")
        public final String file;
        @Description(value="Where the examples were sourced from.")
        public String source = "example movie database from themoviedb.org";
        @Description(value="The format the movies file was in.")
        public final String format;
        @Description(value="The number of nodes imported.")
        public long nodes;
        @Description(value="The number of relationships imported.")
        public long relationships;
        @Description(value="The number of properties imported.")
        public long properties;
        @Description(value="The duration of the import.")
        public long time;
        @Description(value="The number of rows returned.")
        public long rows;
        @Description(value="The size of the batches the import was run in.")
        public long batchSize = -1L;
        @Description(value="The number of batches the import was run in.")
        public long batches;
        @Description(value="Whether the import ran successfully.")
        public boolean done;
        @Description(value="The data returned by the import.")
        public Object data;

        public ExamplesProgressInfo(long nodes, long relationships, long properties, long time) {
            this.file = "movies.cypher";
            this.format = "cypher";
            this.nodes = nodes;
            this.relationships = relationships;
            this.properties = properties;
            this.time = time;
            this.done = true;
        }
    }
}

