/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.arrow;

import apoc.convert.Json;
import apoc.export.arrow.ArrowConfig;
import apoc.export.arrow.ExportArrowStrategy;
import apoc.export.util.ProgressReporter;
import apoc.result.ExportProgressInfo;
import apoc.util.FileUtils;
import apoc.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.ArrowWriter;
import org.apache.arrow.vector.types.pojo.Schema;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.procedure.TerminationGuard;

public interface ExportArrowFileStrategy<IN>
extends ExportArrowStrategy<IN, Stream<ExportProgressInfo>> {
    public Iterator<Map<String, Object>> toIterator(ProgressReporter var1, IN var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public Stream<ExportProgressInfo> export(IN data, ArrowConfig config) {
        OutputStream out = FileUtils.getOutputStream(this.getFileName());
        ExportProgressInfo progressInfo = new ExportProgressInfo(this.getFileName(), this.getSource(data), "arrow");
        progressInfo.setBatchSize(config.getBatchSize());
        ProgressReporter reporter = new ProgressReporter(null, null, progressInfo);
        int batchCount = 0;
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(config.getBatchSize());
        VectorSchemaRoot root = null;
        ArrowWriter writer = null;
        try {
            Iterator<Map<String, Object>> it = this.toIterator(reporter, data);
            while (!Util.transactionIsTerminated(this.getTerminationGuard()) && it.hasNext()) {
                rows.add(it.next());
                if (batchCount > 0 && batchCount % config.getBatchSize() == 0) {
                    if (root == null) {
                        root = VectorSchemaRoot.create((Schema)this.schemaFor(rows), (BufferAllocator)this.getBufferAllocator());
                        writer = this.newArrowWriter(root, out);
                    }
                    this.writeBatch(root, writer, rows);
                    rows.clear();
                }
                ++batchCount;
            }
            if (!rows.isEmpty()) {
                if (root == null) {
                    root = VectorSchemaRoot.create((Schema)this.schemaFor(rows), (BufferAllocator)this.getBufferAllocator());
                    writer = this.newArrowWriter(root, out);
                }
                this.writeBatch(root, writer, rows);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Exception while extracting Arrow data:", (Throwable)e);
        }
        finally {
            reporter.done();
            Util.close(root);
            Util.close(writer);
        }
        return Stream.of(progressInfo);
    }

    public String getSource(IN var1);

    default public void writeBatch(VectorSchemaRoot root, ArrowWriter writer, List<Map<String, Object>> rows) {
        AtomicInteger counter = new AtomicInteger();
        root.allocateNew();
        rows.forEach(row -> {
            int index = counter.getAndIncrement();
            root.getFieldVectors().forEach(fe -> {
                Object value = this.convertValue(row.get(fe.getName()));
                this.write(index, value, (FieldVector)fe);
            });
        });
        root.setRowCount(counter.get());
        try {
            writer.writeBatch();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        root.clear();
    }

    public String getFileName();

    @Override
    public TerminationGuard getTerminationGuard();

    @Override
    public BufferAllocator getBufferAllocator();

    @Override
    public GraphDatabaseService getGraphDatabaseApi();

    @Override
    public ExecutorService getExecutorService();

    @Override
    public Log getLogger();

    @Override
    default public Object convertValue(Object data) {
        return data == null ? null : Json.writeJsonResult(data);
    }

    @Override
    default public ArrowWriter newArrowWriter(VectorSchemaRoot root, OutputStream out) {
        return new ArrowFileWriter(root, (DictionaryProvider)new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]), Channels.newChannel(out));
    }

    @Override
    public Schema schemaFor(List<Map<String, Object>> var1);
}

