/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.export.csv.CustomCSVWriter;
import apoc.export.cypher.ExportFileManager;
import apoc.export.util.BulkImportUtil;
import apoc.export.util.ExportConfig;
import apoc.export.util.FormatUtils;
import apoc.export.util.MetaInformation;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.export.util.Reporter;
import apoc.util.Util;
import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.ExportData;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

public class CsvFormat {
    private final GraphDatabaseService db;
    private final ExportConfig config;
    private final boolean applyQuotesToAll;
    private static final String[] NODE_HEADER_FIXED_COLUMNS = new String[]{"_id:id", "_labels:label"};
    private static final String[] REL_HEADER_FIXED_COLUMNS = new String[]{"_start:id", "_end:id", "_type:label"};

    public CsvFormat(GraphDatabaseService db, ExportConfig exportConfig) {
        this.db = db;
        this.config = exportConfig;
        this.applyQuotesToAll = !"none".equals(exportConfig.isQuotes()) && !"ifNeeded".equals(exportConfig.isQuotes());
    }

    public void dump(InternalTransaction threadBoundTx, ExportData data, ExportFileManager writer, Reporter reporter, boolean needsRebind) {
        if (data instanceof ExportData.Database) {
            this.dump(threadBoundTx, new DatabaseSubGraph((Transaction)threadBoundTx), writer, reporter);
        } else if (data instanceof ExportData.NodesAndRels) {
            ExportData.NodesAndRels e = (ExportData.NodesAndRels)data;
            this.dump(threadBoundTx, new NodesAndRelsSubGraph((Transaction)threadBoundTx, e.nodes(), e.rels(), needsRebind), writer, reporter);
        } else if (data instanceof ExportData.Query) {
            ExportData.Query e = (ExportData.Query)data;
            this.dump(threadBoundTx, e, writer, reporter);
        }
    }

    private void dump(InternalTransaction threadBoundTx, SubGraph graph, ExportFileManager writer, Reporter reporter) {
        if (this.config.isBulkImport()) {
            this.writeAllBulkImport(threadBoundTx, graph, reporter, writer);
        } else {
            try (PrintWriter printWriter = writer.getPrintWriter("csv");){
                CSVWriter out = this.getCsvWriter(printWriter);
                this.writeAll(threadBoundTx, graph, reporter, out);
            }
        }
        reporter.done();
    }

    private CSVWriter getCsvWriter(Writer writer) {
        return switch (this.config.isQuotes()) {
            case "none" -> new CustomCSVWriter(writer, this.config.getDelimChar(), '\u0000', '\u0000', "\n", this.config.shouldDifferentiateNulls());
            default -> new CustomCSVWriter(writer, this.config.getDelimChar(), '\"', '\"', "\n", this.config.shouldDifferentiateNulls());
        };
    }

    private void dump(InternalTransaction threadBoundTx, ExportData.Query query, ExportFileManager writer, Reporter reporter) {
        try (Result result = threadBoundTx.execute(query.cypher(), query.params());
             PrintWriter printWriter = writer.getPrintWriter("csv");){
            CSVWriter out = this.getCsvWriter(printWriter);
            String[] header = this.writeResultHeader(result, out);
            String[] data = new String[header.length];
            result.accept(row -> {
                for (int col = 0; col < header.length; ++col) {
                    String key = header[col];
                    Object value = row.get(key);
                    data[col] = FormatUtils.toString(value, this.config.shouldDifferentiateNulls());
                    reporter.update(value instanceof Node ? 1L : 0L, value instanceof Relationship ? 1L : 0L, value instanceof Entity ? 0L : 1L);
                }
                out.writeNext(data, this.applyQuotesToAll);
                reporter.nextRow();
                return true;
            });
            reporter.done();
        }
        catch (AuthorizationViolationException e) {
            throw new RuntimeException(Util.INVALID_QUERY_MODE_ERROR);
        }
    }

    public String[] writeResultHeader(Result result, CSVWriter out) {
        List columns = result.columns();
        int cols = columns.size();
        String[] header = columns.toArray(new String[cols]);
        out.writeNext(header, this.applyQuotesToAll);
        return header;
    }

    public void writeAll(InternalTransaction threadBoundTx, SubGraph graph, Reporter reporter, CSVWriter out) {
        Map<String, Class> nodePropTypes = MetaInformation.collectPropTypesForNodes(graph, this.db, this.config);
        Map<String, Class> relPropTypes = MetaInformation.collectPropTypesForRelationships(graph, this.db, this.config);
        List<String> nodeHeader = this.generateHeader(nodePropTypes, this.config.useTypes(), NODE_HEADER_FIXED_COLUMNS);
        List<String> relHeader = this.generateHeader(relPropTypes, this.config.useTypes(), REL_HEADER_FIXED_COLUMNS);
        List<String> nodePropNames = nodePropTypes.keySet().stream().sorted().toList();
        List<String> relPropNames = relPropTypes.keySet().stream().sorted().toList();
        ArrayList<String> header = new ArrayList<String>(nodeHeader);
        header.addAll(relHeader);
        out.writeNext((String[])header.toArray(String[]::new), this.applyQuotesToAll);
        int cols = header.size();
        this.writeNodes(threadBoundTx, graph, out, reporter, nodePropNames, cols, this.config.getBatchSize(), this.config.shouldDifferentiateNulls());
        this.writeRels(threadBoundTx, graph, out, reporter, relPropNames, cols, nodeHeader.size(), this.config.getBatchSize(), this.config.shouldDifferentiateNulls());
    }

    private void writeAllBulkImport(InternalTransaction threadBoundTx, SubGraph graph, Reporter reporter, ExportFileManager writer) {
        Map<Iterable<Label>, List<Node>> objectNodes = StreamSupport.stream(graph.getNodes().spliterator(), false).collect(Collectors.groupingBy(Node::getLabels));
        Map<RelationshipType, List<Relationship>> objectRels = StreamSupport.stream(graph.getRelationships().spliterator(), false).collect(Collectors.groupingBy(Relationship::getType));
        this.writeNodesBulkImport(threadBoundTx, reporter, writer, objectNodes);
        this.writeRelsBulkImport(threadBoundTx, reporter, writer, objectRels);
    }

    private void writeNodesBulkImport(InternalTransaction threadBoundTransaction, Reporter reporter, ExportFileManager writer, Map<Iterable<Label>, List<Node>> objectNode) {
        objectNode.forEach((labels, nodes) -> {
            Set<String> headerNode = CsvFormat.generateHeaderNodeBulkImport(nodes);
            List<List<String>> rows = nodes.stream().map(n -> {
                reporter.update(1L, 0L, n.getAllProperties().size());
                return headerNode.stream().map(s -> {
                    if (s.equals(":LABEL")) {
                        return Util.joinLabels(labels, this.config.getArrayDelim());
                    }
                    String prop = s.split(":")[0];
                    return prop.isEmpty() ? String.valueOf(Util.getNodeId(threadBoundTransaction, n.getElementId())) : FormatUtils.toString(n.getProperty(prop, null), this.config.shouldDifferentiateNulls());
                }).collect(Collectors.toList());
            }).collect(Collectors.toList());
            String type = Util.joinLabels(labels, ".");
            this.writeRow(this.config, writer, headerNode, rows, "nodes." + type);
        });
    }

    private void writeRelsBulkImport(InternalTransaction threadBoundTx, Reporter reporter, ExportFileManager writer, Map<RelationshipType, List<Relationship>> objectRel) {
        objectRel.entrySet().forEach(entrySet -> {
            Set<String> headerRel = this.generateHeaderRelationshipBulkImport((Map.Entry<RelationshipType, List<Relationship>>)entrySet);
            List<List<String>> rows = ((List)entrySet.getValue()).stream().map(r -> {
                reporter.update(0L, 1L, r.getAllProperties().size());
                return headerRel.stream().map(s -> switch (s) {
                    case ":START_ID" -> String.valueOf(Util.getNodeId(threadBoundTx, r.getStartNode().getElementId()));
                    case ":END_ID" -> String.valueOf(Util.getNodeId(threadBoundTx, r.getEndNode().getElementId()));
                    case ":TYPE" -> ((RelationshipType)entrySet.getKey()).name();
                    default -> {
                        String prop = s.split(":")[0];
                        if (prop.isEmpty()) {
                            yield String.valueOf(Util.getRelationshipId(threadBoundTx, r.getElementId()));
                        }
                        yield FormatUtils.toString(r.getProperty(prop, (Object)""));
                    }
                }).collect(Collectors.toList());
            }).collect(Collectors.toList());
            this.writeRow(this.config, writer, headerRel, rows, "relationships." + ((RelationshipType)entrySet.getKey()).name());
        });
    }

    private static Set<String> generateHeaderNodeBulkImport(List<Node> nodes) {
        LinkedHashSet<String> headerNode = new LinkedHashSet<String>();
        headerNode.add(":ID");
        LinkedHashMap keyTypes = new LinkedHashMap();
        nodes.forEach(node -> MetaInformation.updateKeyTypes(keyTypes, (Entity)node));
        LinkedHashSet otherFields = keyTypes.entrySet().stream().map(stringClassEntry -> BulkImportUtil.formatHeader(stringClassEntry)).collect(Collectors.toCollection(LinkedHashSet::new));
        headerNode.addAll(otherFields);
        headerNode.add(":LABEL");
        return headerNode;
    }

    private Set<String> generateHeaderRelationshipBulkImport(Map.Entry<RelationshipType, List<Relationship>> entrySet) {
        LinkedHashSet<String> headerNode = new LinkedHashSet<String>();
        LinkedHashMap keyTypes = new LinkedHashMap();
        entrySet.getValue().forEach(relationship -> MetaInformation.updateKeyTypes(keyTypes, (Entity)relationship));
        headerNode.add(":START_ID");
        headerNode.add(":END_ID");
        headerNode.add(":TYPE");
        headerNode.addAll(keyTypes.entrySet().stream().map(stringClassEntry -> BulkImportUtil.formatHeader(stringClassEntry)).collect(Collectors.toCollection(LinkedHashSet::new)));
        return headerNode;
    }

    private void writeRow(ExportConfig config, ExportFileManager writer, Set<String> headerNode, List<List<String>> rows, String name) {
        try (PrintWriter pw = writer.getPrintWriter(name);
             CSVWriter csvWriter = this.getCsvWriter(pw);){
            if (config.isSeparateHeader()) {
                try (PrintWriter pwHeader = writer.getPrintWriter("header." + name);){
                    CSVWriter csvWriterHeader = this.getCsvWriter(pwHeader);
                    csvWriterHeader.writeNext((String[])headerNode.toArray(String[]::new), this.applyQuotesToAll);
                }
            } else {
                csvWriter.writeNext((String[])headerNode.toArray(String[]::new), this.applyQuotesToAll);
            }
            rows.forEach(row -> csvWriter.writeNext((String[])row.toArray(String[]::new), this.applyQuotesToAll));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> generateHeader(Map<String, Class> propTypes, boolean useTypes, String ... starters) {
        ArrayList<String> result = new ArrayList<String>();
        if (useTypes) {
            Collections.addAll(result, starters);
        } else {
            result.addAll(Stream.of(starters).map(s -> s.split(":")[0]).collect(Collectors.toList()));
        }
        result.addAll(propTypes.entrySet().stream().map(entry -> {
            String type = MetaInformation.typeFor((Class)entry.getValue(), null);
            return type == null || type.equals("string") || !useTypes ? (String)entry.getKey() : (String)entry.getKey() + ":" + type;
        }).sorted().toList());
        return result;
    }

    private void writeNodes(InternalTransaction threadBoundTx, SubGraph graph, CSVWriter out, Reporter reporter, List<String> nodePropTypes, int cols, int batchSize, boolean keepNulls) {
        String[] row = new String[cols];
        int nodes = 0;
        for (Node node : graph.getNodes()) {
            row[0] = String.valueOf(Util.getNodeId(threadBoundTx, node.getElementId()));
            row[1] = MetaInformation.getLabelsString(node);
            this.collectProps(nodePropTypes, (Entity)node, reporter, row, 2, keepNulls);
            out.writeNext(row, this.applyQuotesToAll);
            if (batchSize != -1 && ++nodes % batchSize != 0) continue;
            reporter.update(nodes, 0L, 0L);
            nodes = 0;
        }
        if (nodes > 0) {
            reporter.update(nodes, 0L, 0L);
        }
    }

    private void collectProps(Collection<String> fields, Entity pc, Reporter reporter, String[] row, int offset, boolean keepNulls) {
        for (String field : fields) {
            if (pc.hasProperty(field)) {
                row[offset] = FormatUtils.toString(pc.getProperty(field));
                reporter.update(0L, 0L, 1L);
            } else {
                row[offset] = keepNulls ? null : "";
            }
            ++offset;
        }
    }

    private void writeRels(InternalTransaction threadBoundTx, SubGraph graph, CSVWriter out, Reporter reporter, List<String> relPropNames, int cols, int offset, int batchSize, boolean keepNull) {
        String[] row = new String[cols];
        int rels = 0;
        for (Relationship rel : graph.getRelationships()) {
            row[offset] = String.valueOf(Util.getNodeId(threadBoundTx, rel.getStartNode().getElementId()));
            row[offset + 1] = String.valueOf(Util.getNodeId(threadBoundTx, rel.getEndNode().getElementId()));
            row[offset + 2] = rel.getType().name();
            this.collectProps(relPropNames, (Entity)rel, reporter, row, 3 + offset, keepNull);
            out.writeNext(row, this.applyQuotesToAll);
            if (batchSize != -1 && ++rels % batchSize != 0) continue;
            reporter.update(0L, rels, 0L);
            rels = 0;
        }
        if (rels > 0) {
            reporter.update(0L, rels, 0L);
        }
    }
}

