/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.ApocConfig;
import apoc.Pools;
import apoc.export.csv.CsvFormat;
import apoc.export.cypher.ExportFileManager;
import apoc.export.cypher.FileManagerFactory;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportFormat;
import apoc.export.util.ExportUtils;
import apoc.export.util.ProgressReporter;
import apoc.export.util.Reporter;
import apoc.result.ExportProgressInfo;
import apoc.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.cypher.export.ExportData;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class ExportCSV {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public ApocConfig apocConfig;
    @Context
    public Pools pools;
    @Context
    public ProcedureCallContext procedureCallContext;

    @NotThreadSafe
    @Procedure(value="apoc.export.csv.all")
    @Description(value="Exports the full database to the provided CSV file.")
    public Stream<ExportProgressInfo> all(@Name(value="file", description="The name of the file to which the data will be exported.") String fileName, @Name(value="config", description="{\n        stream = false :: BOOLEAN,\n        batchSize = 20000 :: INTEGER,\n        bulkImport = false :: BOOLEAN,\n        timeoutSeconds = 100 :: INTEGER,\n        compression = 'None' :: STRING,\n        charset = 'UTF_8' :: STRING,\n        quotes = 'always' :: ['always', 'none', 'ifNeeded'],\n        differentiateNulls = false :: BOOLEAN,\n        sampling = false :: BOOLEAN,\n        samplingConfig :: MAP\n}\n") Map<String, Object> config) {
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount(this.tx), Util.relCount(this.tx));
        return this.exportCsv(fileName, source, new ExportData.Database(), new ExportConfig(config, ExportFormat.CSV));
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.csv.data")
    @Description(value="Exports the given `NODE` and `RELATIONSHIP` values to the provided CSV file.")
    public Stream<ExportProgressInfo> data(@Name(value="nodes", description="A list of nodes to export.") List<Node> nodes, @Name(value="rels", description="A list of relationships to export.") List<Relationship> rels, @Name(value="file", description="The name of the file to which the data will be exported.") String fileName, @Name(value="config", description="{\n        stream = false :: BOOLEAN,\n        batchSize = 20000 :: INTEGER,\n        timeoutSeconds = 100 :: INTEGER,\n        compression = 'None' :: STRING,\n        charset = 'UTF_8' :: STRING,\n        quotes = 'always' :: ['always', 'none', 'ifNeeded'],\n        differentiateNulls = false :: BOOLEAN,\n        sampling = false :: BOOLEAN,\n        samplingConfig :: MAP\n}\n") Map<String, Object> config) {
        ExportConfig exportConfig = new ExportConfig(config, ExportFormat.CSV);
        this.preventBulkImport(exportConfig);
        String source = String.format("data: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportCsv(fileName, source, new ExportData.NodesAndRels(nodes, rels), exportConfig);
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.csv.graph")
    @Description(value="Exports the given graph to the provided CSV file.")
    public Stream<ExportProgressInfo> graph(@Name(value="graph", description="The graph to export.") Map<String, Object> graph, @Name(value="file", description="The name of the file to which the data will be exported.") String fileName, @Name(value="config", description="{\n        stream = false :: BOOLEAN,\n        batchSize = 20000 :: INTEGER,\n        bulkImport = false :: BOOLEAN,\n        timeoutSeconds = 100 :: INTEGER,\n        compression = 'None' :: STRING,\n        charset = 'UTF_8' :: STRING,\n        quotes = 'always' :: ['always', 'none', 'ifNeeded'],\n        differentiateNulls = false :: BOOLEAN,\n        sampling = false :: BOOLEAN,\n        samplingConfig :: MAP\n}\n") Map<String, Object> config) {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        String source = String.format("graph: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportCsv(fileName, source, new ExportData.NodesAndRels(nodes, rels), new ExportConfig(config, ExportFormat.CSV));
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.csv.query")
    @Description(value="Exports the results from running the given Cypher query to the provided CSV file.")
    public Stream<ExportProgressInfo> query(@Name(value="query", description="The query used to collect the data for export.") String query, @Name(value="file", description="The name of the file to which the data will be exported.") String fileName, @Name(value="config", description="{\n        stream = false :: BOOLEAN,\n        batchSize = 20000 :: INTEGER,\n        timeoutSeconds = 100 :: INTEGER,\n        compression = 'None':: STRING,\n        charset = 'UTF_8' :: STRING,\n        quotes = 'always' :: ['always', 'none', 'ifNeeded'],\n        differentiateNulls = false :: BOOLEAN,\n        sampling = false :: BOOLEAN,\n        samplingConfig :: MAP\n}\n") Map<String, Object> config) {
        String source;
        ExportConfig exportConfig = new ExportConfig(config, ExportFormat.CSV);
        this.preventBulkImport(exportConfig);
        Map<String, Object> params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        query = Util.prefixQueryWithCheck(this.procedureCallContext, query);
        try (Result result = this.tx.execute(query, params);){
            source = String.format("statement: cols(%d)", result.columns().size());
        }
        return this.exportCsv(fileName, source, new ExportData.Query(query, params), exportConfig);
    }

    private void preventBulkImport(ExportConfig config) {
        if (config.isBulkImport()) {
            throw new RuntimeException("You can use the `bulkImport` only with apoc.export.csv.all and apoc.export.csv.graph");
        }
    }

    private Stream<ExportProgressInfo> exportCsv(@Name(value="file") String fileName, String source, ExportData data, ExportConfig exportConfig) {
        this.apocConfig.checkWriteAllowed(exportConfig, fileName);
        String format = "csv";
        ExportProgressInfo progressInfo = new ExportProgressInfo(fileName, source, "csv");
        progressInfo.batchSize = exportConfig.getBatchSize();
        ProgressReporter reporter = new ProgressReporter(null, null, progressInfo);
        CsvFormat exporter = new CsvFormat(this.db, exportConfig);
        ExportFileManager cypherFileManager = FileManagerFactory.createFileManager(fileName, exportConfig.isBulkImport(), exportConfig);
        if (exportConfig.streamStatements()) {
            return ExportUtils.getProgressInfoStream(this.db, this.pools.getDefaultExecutorService(), this.terminationGuard, "csv", exportConfig, reporter, cypherFileManager, (threadBoundTx, reporterWithConsumer) -> exporter.dump((InternalTransaction)threadBoundTx, data, cypherFileManager, (Reporter)reporterWithConsumer, true));
        }
        exporter.dump((InternalTransaction)this.tx, data, cypherFileManager, reporter, false);
        return Stream.of((ExportProgressInfo)reporter.getTotal());
    }
}

