/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.json;

import apoc.ApocConfig;
import apoc.Pools;
import apoc.export.cypher.ExportFileManager;
import apoc.export.cypher.FileManagerFactory;
import apoc.export.json.JsonFormat;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportUtils;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.export.util.ProgressReporter;
import apoc.export.util.Reporter;
import apoc.result.ExportProgressInfo;
import apoc.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class ExportJson {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public ApocConfig apocConfig;
    @Context
    public Pools pools;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public ProcedureCallContext procedureCallContext;

    @NotThreadSafe
    @Procedure(value="apoc.export.json.all")
    @Description(value="Exports the full database to the provided JSON file.")
    public Stream<ExportProgressInfo> all(@Name(value="file", description="The name of the file to which the data will be exported.") String fileName, @Name(value="config", defaultValue="{}", description="{\n        stream = false :: BOOLEAN,\n        writeNodeProperties = true :: BOOLEAN,\n        writeRelationshipProperties = writeNodeProperties :: BOOLEAN,\n        jsonFormat = 'JSON_LINES' :: STRING,\n        compression = 'None' :: STRING,\n        charset = 'UTF_8' :: STRING\n}\n") Map<String, Object> config) {
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount(this.tx), Util.relCount(this.tx));
        return this.exportJson(fileName, source, new DatabaseSubGraph(this.tx), config);
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.json.data")
    @Description(value="Exports the given `NODE` and `RELATIONSHIP` values to the provided JSON file.")
    public Stream<ExportProgressInfo> data(@Name(value="nodes", description="A list of nodes to export.") List<Node> nodes, @Name(value="rels", description="A list of relationships to export.") List<Relationship> rels, @Name(value="file", description="The name of the file to which the data will be exported.") String fileName, @Name(value="config", defaultValue="{}", description="{\n        stream = false :: BOOLEAN,\n        writeNodeProperties = true :: BOOLEAN,\n        writeRelationshipProperties = writeNodeProperties :: BOOLEAN,\n        jsonFormat = 'JSON_LINES' :: STRING,\n        compression = 'None' :: STRING,\n        charset = 'UTF_8' :: STRING\n}\n") Map<String, Object> config) {
        nodes = nodes == null ? Collections.emptyList() : nodes;
        rels = rels == null ? Collections.emptyList() : rels;
        String source = String.format("data: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportJson(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), config);
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.json.graph")
    @Description(value="Exports the given graph to the provided JSON file.")
    public Stream<ExportProgressInfo> graph(@Name(value="graph", description="The graph to export.") Map<String, Object> graph, @Name(value="file", description="The name of the file to which the data will be exported.") String fileName, @Name(value="config", defaultValue="{}", description="{\n        stream = false :: BOOLEAN,\n        writeNodeProperties = true :: BOOLEAN,\n        writeRelationshipProperties = writeNodeProperties :: BOOLEAN,\n        jsonFormat = 'JSON_LINES' :: STRING,\n        compression = 'None' :: STRING,\n        charset = 'UTF_8' :: STRING\n}\n") Map<String, Object> config) {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        String source = String.format("graph: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportJson(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), config);
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.json.query")
    @Description(value="Exports the results from the Cypher statement to the provided JSON file.")
    public Stream<ExportProgressInfo> query(@Name(value="statement", description="The query used to collect the data for export.") String query, @Name(value="file", description="The name of the file to which the data will be exported.") String fileName, @Name(value="config", defaultValue="{}", description="{\n        stream = false :: BOOLEAN,\n        writeNodeProperties = true :: BOOLEAN,\n        writeRelationshipProperties = writeNodeProperties :: BOOLEAN,\n        jsonFormat = 'JSON_LINES' :: STRING,\n        compression = 'None' :: STRING,\n        charset = 'UTF_8' :: STRING\n}\n") Map<String, Object> config) {
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.tx.execute(Util.prefixQueryWithCheck(this.procedureCallContext, query), params);
        String source = String.format("statement: cols(%d)", result.columns().size());
        return this.exportJson(fileName, source, result, config);
    }

    private Stream<ExportProgressInfo> exportJson(String fileName, String source, Object data, Map<String, Object> config) {
        ExportConfig exportConfig = new ExportConfig(config);
        this.apocConfig.checkWriteAllowed(exportConfig, fileName);
        String format = "json";
        ProgressReporter reporter = new ProgressReporter(null, null, new ExportProgressInfo(fileName, source, "json"));
        JsonFormat exporter = new JsonFormat(this.db, this.getJsonFormat(config));
        ExportFileManager cypherFileManager = FileManagerFactory.createFileManager(fileName, false, exportConfig);
        if (exportConfig.streamStatements()) {
            return ExportUtils.getProgressInfoStream(this.db, this.pools.getDefaultExecutorService(), this.terminationGuard, "json", exportConfig, reporter, cypherFileManager, (threadBoundTx, reporterWithConsumer) -> this.dump(data, exportConfig, (ProgressReporter)reporterWithConsumer, exporter, cypherFileManager));
        }
        this.dump(data, exportConfig, reporter, exporter, cypherFileManager);
        return Stream.of((ExportProgressInfo)reporter.getTotal());
    }

    private JsonFormat.Format getJsonFormat(Map<String, Object> config) {
        if (config == null) {
            return JsonFormat.Format.JSON_LINES;
        }
        String jsonFormat = config.getOrDefault("jsonFormat", JsonFormat.Format.JSON_LINES.toString()).toString().toUpperCase();
        return JsonFormat.Format.valueOf(jsonFormat);
    }

    private void dump(Object data, ExportConfig c, ProgressReporter reporter, JsonFormat exporter, ExportFileManager cypherFileManager) {
        try {
            if (data instanceof SubGraph) {
                exporter.dump((SubGraph)data, cypherFileManager, (Reporter)reporter, c);
            }
            if (data instanceof Result) {
                exporter.dump((Result)data, cypherFileManager, (Reporter)reporter, c);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

