/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.json;

import apoc.Pools;
import apoc.export.json.ImportJsonConfig;
import apoc.export.json.JsonImporter;
import apoc.export.util.CountingReader;
import apoc.export.util.ProgressReporter;
import apoc.result.ImportProgressInfo;
import apoc.util.FileUtils;
import apoc.util.JsonUtil;
import apoc.util.Util;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class ImportJson {
    @Context
    public GraphDatabaseService db;
    @Context
    public Pools pools;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(value="apoc.import.json", mode=Mode.WRITE)
    @Description(value="Imports a graph from the provided JSON file.")
    public Stream<ImportProgressInfo> all(@Name(value="urlOrBinaryFile", description="The name of the file or binary data to import the data from.") Object urlOrBinaryFile, @Name(value="config", defaultValue="{}", description="{\n    unwindBatchSize = 5000 :: INTEGER,\n    txBatchSize = 5000 :: INTEGER,\n    importIdName = \"neo4jImportId\" :: STRING,\n    nodePropertyMappings = {} :: MAP,\n    relPropertyMappings = {} :: MAP,\n    compression = \"NONE\" :: [\"NONE\", \"BYTES\", \"GZIP\", \"BZIP2\", \"DEFLATE\", \"BLOCK_LZ4\", \"FRAMED_SNAPPY\"],\n    cleanup = false :: BOOLEAN,\n    nodePropFilter = {} :: MAP,\n    relPropFilter = {} :: MAP\n}\n") Map<String, Object> config) {
        ImportProgressInfo result = Util.inThread(this.pools, () -> {
            ImportJsonConfig importJsonConfig = new ImportJsonConfig(config);
            String file = null;
            String source = "binary";
            if (urlOrBinaryFile instanceof String) {
                file = (String)urlOrBinaryFile;
                source = "file";
            }
            ProgressReporter reporter = new ProgressReporter(null, null, new ImportProgressInfo(file, source, "json"));
            try (CountingReader reader = FileUtils.readerFor(urlOrBinaryFile, importJsonConfig.getCompressionAlgo(), this.urlAccessChecker);
                 Scanner scanner = new Scanner(reader).useDelimiter("\n|\r");
                 JsonImporter jsonImporter = new JsonImporter(importJsonConfig, this.db, reporter);){
                while (scanner.hasNext() && !Util.transactionIsTerminated(this.terminationGuard)) {
                    Map row = (Map)JsonUtil.OBJECT_MAPPER.readValue(scanner.nextLine(), Map.class);
                    jsonImporter.importRow(row);
                }
            }
            return (ImportProgressInfo)reporter.getTotal();
        });
        return Stream.of(result);
    }
}

