/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.json;

import apoc.export.json.ImportJsonConfig;
import apoc.export.util.Reporter;
import apoc.util.Util;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;

public class JsonImporter
implements Closeable {
    private static final String UNWIND = "UNWIND $rows AS row ";
    private static final String CREATE_NODE = "UNWIND $rows AS row CREATE (n%s {%s}) SET n += row.properties";
    private static final String CREATE_RELS = "UNWIND $rows AS row MATCH (s%s {%s: row.start.id}) MATCH (e%s {%2$s: row.end.id}) CREATE (s)-[r:%s]->(e) SET r += row.properties";
    public static final String MISSING_CONSTRAINT_ERROR_MSG = "Missing constraint required for import. Execute this query: \nCREATE CONSTRAINT FOR (n:%s) REQUIRE n.%s IS UNIQUE;";
    private final List<Map<String, Object>> paramList;
    private final int unwindBatchSize;
    private final int txBatchSize;
    private final GraphDatabaseService db;
    private final Reporter reporter;
    private String lastType;
    private List<String> lastLabels;
    private Map<String, Object> lastRelTypes;
    private final ImportJsonConfig importJsonConfig;

    public JsonImporter(ImportJsonConfig importJsonConfig, GraphDatabaseService db, Reporter reporter) {
        this.paramList = new ArrayList<Map<String, Object>>(importJsonConfig.getUnwindBatchSize());
        this.db = db;
        this.txBatchSize = importJsonConfig.getTxBatchSize();
        this.unwindBatchSize = Math.min(importJsonConfig.getUnwindBatchSize(), this.txBatchSize);
        this.reporter = reporter;
        this.importJsonConfig = importJsonConfig;
    }

    public void importRow(Map<String, Object> param) {
        List<String> labels;
        String type = (String)param.get("type");
        this.manageEntityType(type);
        Map<String, List<String>> propFilter = switch (type) {
            case "node" -> {
                this.manageNode(param);
                labels = this.lastLabels;
                yield this.importJsonConfig.getNodePropFilter();
            }
            case "relationship" -> {
                this.manageRelationship(param);
                labels = Collections.singletonList((String)this.lastRelTypes.get("label"));
                yield this.importJsonConfig.getRelPropFilter();
            }
            default -> throw new IllegalArgumentException("Current type not supported: " + type);
        };
        Map<String, Object> properties = param.getOrDefault("properties", Collections.emptyMap());
        List defaultProps = propFilter.getOrDefault("_all", Collections.emptyList());
        properties.keySet().removeIf(name -> {
            Predicate<String> nameInPropFilter = i -> propFilter.getOrDefault(i, defaultProps).contains(name);
            return labels.stream().anyMatch(nameInPropFilter);
        });
        this.updateReporter(type, properties);
        param.put("properties", this.convertProperties(type, properties));
        this.paramList.add(param);
        if (this.paramList.size() % this.txBatchSize == 0) {
            Collection<List<Map<String, Object>>> results = this.chunkData();
            this.paramList.clear();
            this.writeUnwindBatch(results);
        }
    }

    private void writeUnwindBatch(Collection<List<Map<String, Object>>> results) {
        results.forEach(resultList -> {
            if (resultList.size() == this.unwindBatchSize) {
                this.write((List<Map<String, Object>>)resultList);
            } else {
                this.paramList.addAll((Collection<Map<String, Object>>)resultList);
            }
        });
    }

    private void manageEntityType(String type) {
        if (this.lastType == null) {
            this.lastType = type;
        }
        if (!type.equals(this.lastType)) {
            this.flush();
            this.lastType = type;
        }
    }

    private void manageRelationship(Map<String, Object> param) {
        List<String> startLabels = this.getLabels((Map)param.get("start"));
        List<String> endLabels = this.getLabels((Map)param.get("end"));
        Map<String, Object> relType = Util.map("start", startLabels, "end", endLabels, "label", this.getType(param));
        List<String> allLabels = Stream.concat(startLabels.stream(), endLabels.stream()).collect(Collectors.toList());
        if (this.lastRelTypes == null) {
            this.checkUniquenessConstraints(allLabels);
            this.lastRelTypes = relType;
        }
        if (!relType.equals(this.lastRelTypes)) {
            this.checkUniquenessConstraints(allLabels);
            this.flush();
            this.lastRelTypes = relType;
        }
    }

    private void manageNode(Map<String, Object> param) {
        List<String> labels = this.getLabels(param);
        if (this.lastLabels == null) {
            this.checkUniquenessConstraints(labels);
            this.lastLabels = labels;
        }
        if (!labels.equals(this.lastLabels)) {
            this.checkUniquenessConstraints(labels);
            this.flush();
            this.lastLabels = labels;
        }
    }

    private void checkUniquenessConstraints(List<String> labels) {
        if (labels.isEmpty()) {
            return;
        }
        try (Transaction tx = this.db.beginTx();){
            Schema schema = tx.schema();
            String importIdName = this.importJsonConfig.getImportIdName();
            String missingConstraint = labels.stream().filter(label -> StreamSupport.stream(schema.getConstraints(Label.label((String)label)).spliterator(), false).filter(constraint -> constraint.isConstraintType(ConstraintType.UNIQUENESS) || constraint.isConstraintType(ConstraintType.NODE_KEY)).noneMatch(constraint -> Iterables.contains((Iterable)constraint.getPropertyKeys(), (Object)importIdName) && Iterables.size((Iterable)constraint.getPropertyKeys()) == 1)).findAny().orElse(null);
            if (missingConstraint != null) {
                throw new RuntimeException(String.format(MISSING_CONSTRAINT_ERROR_MSG, missingConstraint, importIdName));
            }
        }
    }

    private void updateReporter(String type, Map<String, Object> properties) {
        int size = properties.size() + 1;
        switch (type) {
            case "node": {
                this.reporter.update(1L, 0L, size);
                break;
            }
            case "relationship": {
                this.reporter.update(0L, 1L, size);
                break;
            }
            default: {
                throw new IllegalArgumentException("Current type not supported: " + type);
            }
        }
    }

    private Stream<Map.Entry<String, Object>> flatMap(Map<String, Object> map, String key) {
        String prefix = key != null ? key : "";
        return map.entrySet().stream().flatMap(e -> {
            if (e.getValue() instanceof Map) {
                return this.flatMap((Map)e.getValue(), prefix + "." + (String)e.getKey());
            }
            return Stream.of(new AbstractMap.SimpleEntry((CallSite)((Object)(prefix + "." + (String)e.getKey())), e.getValue()));
        });
    }

    private List<Object> convertList(Collection<Object> coll, String classType) {
        return coll.stream().map(c -> {
            if (c instanceof Collection) {
                return this.convertList((Collection)c, classType);
            }
            return this.convertMappedValue(c, classType);
        }).collect(Collectors.toList());
    }

    private Map<String, Object> convertProperties(String type, Map<String, Object> properties) {
        return properties.entrySet().stream().flatMap(e -> {
            if (e.getValue() instanceof Map) {
                Map map = (Map)e.getValue();
                String classType = this.getClassType(type, (String)e.getKey());
                if (classType != null && "POINT".equals(classType.toUpperCase())) {
                    return Stream.of(e);
                }
                return this.flatMap(map, (String)e.getKey());
            }
            return Stream.of(e);
        }).map(e -> {
            String key = (String)e.getKey();
            String classType = this.getClassType(type, key);
            if (e.getValue() instanceof Collection) {
                List<Object> coll = this.convertList((Collection)e.getValue(), classType);
                return new AbstractMap.SimpleEntry<String, List<Object>>((String)e.getKey(), coll);
            }
            return new AbstractMap.SimpleEntry<String, Object>((String)e.getKey(), this.convertMappedValue(e.getValue(), classType));
        }).filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
    }

    private String getClassType(String type, String key) {
        return switch (type) {
            case "node" -> this.importJsonConfig.typeForNode(this.lastLabels, key);
            case "relationship" -> this.importJsonConfig.typeForRel((String)this.lastRelTypes.get("label"), key);
            default -> null;
        };
    }

    private Object convertMappedValue(Object value, String classType) {
        if (classType == null) {
            return value;
        }
        switch (classType.toUpperCase()) {
            case "POINT": {
                value = JsonImporter.toPoint((Map)value);
                break;
            }
            case "LOCALDATE": {
                value = LocalDate.parse((String)value);
                break;
            }
            case "LOCALTIME": {
                value = LocalTime.parse((String)value);
                break;
            }
            case "LOCALDATETIME": {
                value = LocalDateTime.parse((String)value);
                break;
            }
            case "DURATION": {
                value = DurationValue.parse((CharSequence)((String)value));
                break;
            }
            case "OFFSETTIME": {
                value = OffsetTime.parse((String)value);
                break;
            }
            case "ZONEDDATETIME": {
                value = ZonedDateTime.parse((String)value);
                break;
            }
        }
        return value;
    }

    public static PointValue toPoint(Map<String, Object> pointMap) {
        return Util.toPoint(pointMap, Collections.emptyMap());
    }

    private String getType(Map<String, Object> param) {
        return Util.quote((String)param.get("label"));
    }

    private List<String> getLabels(Map<String, Object> param) {
        return param.getOrDefault("labels", Collections.emptyList());
    }

    private String getLabelString(List<String> labels) {
        labels = labels == null ? Collections.emptyList() : labels;
        String delimiter = ":";
        String join = labels.stream().map(Util::quote).collect(Collectors.joining(":"));
        return join.isBlank() ? join : ":" + join;
    }

    private void write(List<Map<String, Object>> resultList) {
        String type;
        if (resultList.isEmpty()) {
            return;
        }
        String query = switch (type = (String)resultList.get(0).get("type")) {
            case "node" -> {
                String importId = this.importJsonConfig.isCleanup() ? "" : this.importJsonConfig.getImportIdName() + ": row.id";
                yield String.format(CREATE_NODE, this.getLabelString(this.lastLabels), importId);
            }
            case "relationship" -> {
                String rel = (String)this.lastRelTypes.get("label");
                yield String.format(CREATE_RELS, this.getLabelString((List)this.lastRelTypes.get("start")), this.importJsonConfig.getImportIdName(), this.getLabelString((List)this.lastRelTypes.get("end")), rel);
            }
            default -> throw new IllegalArgumentException("Current type not supported: " + type);
        };
        if (StringUtils.isNotBlank(query)) {
            this.db.executeTransactionally(query, Collections.singletonMap("rows", resultList));
        }
    }

    private Collection<List<Map<String, Object>>> chunkData() {
        AtomicInteger chunkCounter = new AtomicInteger(0);
        return this.paramList.stream().collect(Collectors.groupingBy(it -> chunkCounter.getAndIncrement() / this.unwindBatchSize)).values();
    }

    @Override
    public void close() {
        this.flush();
        this.reporter.done();
    }

    private void flush() {
        if (!this.paramList.isEmpty()) {
            Collection<List<Map<String, Object>>> results = this.chunkData();
            results.forEach(this::write);
            this.paramList.clear();
        }
    }
}

