/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.ApocConfig;
import java.io.IOException;
import java.io.InputStream;

public class LimitedSizeInputStream
extends InputStream {
    public static final String SIZE_EXCEEDED_ERROR = "The file dimension exceeded maximum size in bytes, %s,\nwhich is %s times the width of the original file.\nThe InputStream has been blocked because the file could be a compression bomb attack.";
    public static final int SIZE_MULTIPLIER = ApocConfig.apocConfig().getInt("apoc.max.decompression.ratio", ApocConfig.DEFAULT_MAX_DECOMPRESSION_RATIO);
    private final InputStream stream;
    private final long maxSize;
    private long total;

    public LimitedSizeInputStream(InputStream stream, long maxSize) {
        this.stream = stream;
        this.maxSize = maxSize;
    }

    @Override
    public int read() throws IOException {
        int i = this.stream.read();
        if (i >= 0) {
            this.incrementCounter(1);
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = this.stream.read(b, off, len);
        if (i >= 0) {
            this.incrementCounter(i);
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        super.close();
    }

    private void incrementCounter(int size) throws IOException {
        if (this.maxSize < 0L) {
            return;
        }
        this.total += (long)size;
        if (this.total > this.maxSize) {
            this.close();
            String msgError = String.format(SIZE_EXCEEDED_ERROR, this.maxSize, SIZE_MULTIPLIER);
            throw new IOException(msgError);
        }
    }

    public static InputStream toLimitedIStream(InputStream stream, long total) {
        return new LimitedSizeInputStream(stream, total * (long)SIZE_MULTIPLIER);
    }
}

