/*
 * Decompiled with CFR 0.152.
 */
package apoc.graph.document.builder;

import apoc.graph.util.GraphsConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;

public class RelationshipBuilder {
    private GraphsConfig config;

    public RelationshipBuilder(GraphsConfig config) {
        this.config = config;
    }

    public Collection<Relationship> buildRelation(Node parent, Node child, String relationName) {
        RelationshipType type = RelationshipType.withName((String)this.config.getRelMapping().getOrDefault(relationName, relationName.toUpperCase()));
        List<Relationship> rels = this.getRelationshipsForRealNodes(parent, child, type);
        if (rels.isEmpty()) {
            return Collections.singleton(parent.createRelationshipTo(child, type));
        }
        return rels;
    }

    private List<Relationship> getRelationshipsForRealNodes(Node parent, Node child, RelationshipType type) {
        ResourceIterable relationships = child.getRelationships(Direction.INCOMING, new RelationshipType[]{type});
        return StreamSupport.stream(relationships.spliterator(), false).filter(rel -> rel.getOtherNode(child).equals((Object)parent)).collect(Collectors.toList());
    }
}

