/*
 * Decompiled with CFR 0.152.
 */
package apoc.help;

import apoc.help.HelpResult;
import apoc.help.HelpUtil;
import apoc.util.Util;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;

public class Help {
    @Context
    public Transaction tx;
    @Context
    public ProcedureCallContext procedureCallContext;

    @NotThreadSafe
    @Procedure(value="apoc.help")
    @Description(value="Returns descriptions of the available APOC procedures and functions. If a keyword is provided, it will return only those procedures and functions that have the keyword in their name.")
    public Stream<HelpResult> infoCypher25(@Name(value="proc", description="A keyword to filter the results by.") String name) {
        boolean searchText = false;
        if (name != null && (name = name.trim()).endsWith("+")) {
            name = name.substring(0, name.lastIndexOf(43)).trim();
            searchText = true;
        }
        String filter = " WHERE name starts with 'apoc.'  AND ($name IS NULL  OR toLower(name) CONTAINS toLower($name)  OR ($desc IS NOT NULL AND toLower(description) CONTAINS toLower($desc))) ";
        String proceduresQuery = Util.prefixQuery(this.procedureCallContext, "SHOW PROCEDURES yield name, description, signature, isDeprecated " + filter + "RETURN 'procedure' as type, name, description, signature, isDeprecated ");
        String functionsQuery = Util.prefixQuery(this.procedureCallContext, "SHOW FUNCTIONS yield name, description, signature, isDeprecated " + filter + "RETURN 'function' as type, name, description, signature, isDeprecated ");
        Map<String, Object> params = Util.map("name", name, "desc", searchText ? name : null);
        Stream proceduresResults = this.tx.execute(proceduresQuery, params).stream();
        Stream functionsResults = this.tx.execute(functionsQuery, params).stream();
        return Stream.of(proceduresResults, functionsResults).flatMap(results -> results.map(row -> new HelpResult((Map<String, Object>)row, this.existsInCore((String)row.get("name"), this.procedureCallContext.calledwithQueryLanguage().equals((Object)QueryLanguage.CYPHER_5), row.get("type").equals("function")))));
    }

    private boolean existsInCore(String name, boolean version5, boolean function) {
        if (version5) {
            if (function) {
                return HelpUtil.coreFunctionsV5.contains(name);
            }
            return HelpUtil.coreProceduresV5.contains(name);
        }
        if (function) {
            return HelpUtil.coreFunctionsV25.contains(name);
        }
        return HelpUtil.coreProceduresV25.contains(name);
    }
}

