/*
 * Decompiled with CFR 0.152.
 */
package apoc.index;

import apoc.index.QueuePoisoningCollector;
import apoc.util.QueueBasedSpliterator;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import apoc.util.collection.Iterators;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class SchemaIndex {
    private static final PropertyValueCount POISON = new PropertyValueCount("poison", "poison", "poison", -1L);
    @Context
    public GraphDatabaseAPI db;
    @Context
    public Transaction tx;
    @Context
    public TerminationGuard terminationGuard;

    @NotThreadSafe
    @Procedure(value="apoc.schema.properties.distinct")
    @Description(value="Returns all distinct `NODE` property values for the given key.")
    public Stream<SchemaListResult> distinct(@Name(value="label", description="The node label to find distinct properties on.") String label, @Name(value="key", description="The name of the property to find distinct values of.") String key) {
        List<Object> values = this.distinctCount(label, key).map(propertyValueCount -> propertyValueCount.value).collect(Collectors.toList());
        return Stream.of(new SchemaListResult(values));
    }

    @NotThreadSafe
    @Procedure(value="apoc.schema.properties.distinctCount")
    @Description(value="Returns all distinct property values and counts for the given key.")
    public Stream<PropertyValueCount> distinctCount(@Name(value="label", defaultValue="", description="The node label to count distinct properties on.") String labelName, @Name(value="key", defaultValue="", description="The name of the property to count distinct values of.") String keyName) {
        LinkedBlockingDeque queue = new LinkedBlockingDeque(100);
        Iterable<IndexDefinition> indexDefinitions = labelName.isEmpty() ? Util.getIndexes(this.tx) : Util.getIndexes(this.tx, Label.label((String)labelName));
        Util.newDaemonThread(() -> StreamSupport.stream(indexDefinitions.spliterator(), true).filter(IndexDefinition::isNodeIndex).filter(indexDefinition -> this.isIndexCoveringProperty((IndexDefinition)indexDefinition, keyName)).map(indexDefinition -> this.scanIndexDefinitionForKeys((IndexDefinition)indexDefinition, keyName, queue, labelName)).collect(new QueuePoisoningCollector<PropertyValueCount>(queue, POISON))).start();
        return StreamSupport.stream(new QueueBasedSpliterator<PropertyValueCount>(queue, POISON, this.terminationGuard, Integer.MAX_VALUE), false).distinct();
    }

    private Object scanIndexDefinitionForKeys(IndexDefinition indexDefinition, @Name(value="key", defaultValue="") String keyName, BlockingQueue<PropertyValueCount> queue, String labelName) {
        try (Transaction threadTx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)threadTx).kernelTransaction();
            List<String> keys = keyName.isEmpty() ? indexDefinition.getPropertyKeys() : Collections.singletonList(keyName);
            for (String key : keys) {
                KernelStatement ignored = (KernelStatement)ktx.acquireStatement();
                try {
                    LabelSchemaDescriptor schema;
                    SchemaRead schemaRead = ktx.schemaRead();
                    TokenRead tokenRead = ktx.tokenRead();
                    Read read = ktx.dataRead();
                    CursorFactory cursors = ktx.cursors();
                    int[] propertyKeyIds = StreamSupport.stream(indexDefinition.getPropertyKeys().spliterator(), false).mapToInt(arg_0 -> ((TokenRead)tokenRead).propertyKey(arg_0)).toArray();
                    if (SchemaIndex.isFullText(indexDefinition)) {
                        int[] labelIds = Iterables.stream(indexDefinition.getLabels()).mapToInt(lbl -> tokenRead.nodeLabel(lbl.name())).toArray();
                        schema = SchemaDescriptors.forSemanticSearch((EntityType)EntityType.NODE, (int[])labelIds, (int[])propertyKeyIds);
                    } else {
                        String label = ((Label)Iterables.single(indexDefinition.getLabels())).name();
                        schema = SchemaDescriptors.forLabel((int)tokenRead.nodeLabel(label), (int[])propertyKeyIds);
                    }
                    IndexDescriptor indexDescriptor = (IndexDescriptor)Iterators.firstOrNull(schemaRead.index((SchemaDescriptor)schema));
                    if (indexDescriptor == null) {
                        Object var18_22 = null;
                        return var18_22;
                    }
                    this.scanIndex(queue, indexDefinition, key, read, cursors, indexDescriptor, ktx, labelName, threadTx);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            threadTx.commit();
            Iterator iterator = null;
            return iterator;
        }
    }

    private void scanIndex(BlockingQueue<PropertyValueCount> queue, IndexDefinition indexDefinition, String key, Read read, CursorFactory cursors, IndexDescriptor indexDescriptor, KernelTransaction ktx, String lblName, Transaction threadTx) {
        block15: {
            try {
                Set<Label> labels;
                NodeValueIndexCursor cursor;
                block16: {
                    IndexReadSession indexSession;
                    block14: {
                        cursor = cursors.allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());
                        try {
                            indexSession = read.indexReadSession(indexDescriptor);
                        }
                        catch (Exception e) {
                            if (e.getMessage().contains("Index is still populating")) {
                                if (cursor != null) {
                                    cursor.close();
                                }
                                return;
                            }
                            throw e;
                        }
                        if (!SchemaIndex.isFullText(indexDefinition)) break block14;
                        read.nodeIndexSeek(ktx.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"*")});
                        break block16;
                    }
                    read.nodeIndexScan(indexSession, cursor, IndexQueryConstraints.unorderedValues());
                }
                HashMap<String, Map> valueCountMap = new HashMap<String, Map>();
                Set<Label> set = labels = lblName.isEmpty() ? indexDefinition.getLabels() : Collections.singleton(Label.label((String)lblName));
                while (cursor.next()) {
                    Node node = threadTx.getNodeById(cursor.nodeReference());
                    Object property = node.getProperty(key, null);
                    if (property == null) continue;
                    labels.forEach(label -> {
                        boolean hasLabel = node.hasLabel(label);
                        if (hasLabel) {
                            Map orDefault = valueCountMap.computeIfAbsent(label.name(), i -> new HashMap());
                            orDefault.merge(property, 1, Integer::sum);
                        }
                    });
                }
                valueCountMap.forEach((label, propMap) -> propMap.forEach((k, v) -> this.putIntoQueue(queue, indexDefinition, key, k, v.intValue(), (String)label)));
                break block15;
                finally {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (KernelException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean isFullText(IndexDefinition indexDefinition) {
        return indexDefinition.getIndexType().equals((Object)IndexType.FULLTEXT);
    }

    private void putIntoQueue(BlockingQueue<PropertyValueCount> queue, IndexDefinition indexDefinition, String key, Object value, long count, String labelName) {
        if (value == null) {
            return;
        }
        try {
            queue.put(new PropertyValueCount(labelName, key, value, count));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isIndexCoveringProperty(IndexDefinition indexDefinition, String propertyKeyName) {
        return propertyKeyName.isEmpty() || this.contains(indexDefinition.getPropertyKeys(), propertyKeyName);
    }

    private boolean contains(Iterable<String> list, String search) {
        for (String element : list) {
            if (!element.equals(search)) continue;
            return true;
        }
        return false;
    }

    public record SchemaListResult(@Description(value="The list of distinct values for the given property.") List<Object> value) {
    }

    public static class PropertyValueCount {
        @Description(value="The label of the node.")
        public String label;
        @Description(value="The name of the property key.")
        public String key;
        @Description(value="The distinct value.")
        public Object value;
        @Description(value="The number of occurrences of the value.")
        public long count;

        public PropertyValueCount(String label, String key, Object value, long count) {
            this.label = label;
            this.key = key;
            this.value = value;
            this.count = count;
        }

        public String toString() {
            return "PropertyValueCount{label='" + this.label + "', key='" + this.key + "', value='" + String.valueOf(this.value) + "', count=" + this.count + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyValueCount that = (PropertyValueCount)o;
            return this.count == that.count && Objects.equals(this.label, that.label) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.key, this.value, this.count);
        }
    }
}

