/*
 * Decompiled with CFR 0.152.
 */
package apoc.merge;

import apoc.cypher.Cypher;
import apoc.result.NodeResultWithStats;
import apoc.result.RelationshipResultWithStats;
import apoc.result.UpdatedNodeResult;
import apoc.result.UpdatedRelationshipResult;
import apoc.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Merge {
    @Context
    public Transaction tx;
    @Context
    public ProcedureCallContext procedureCallContext;

    @Procedure(value="apoc.merge.node.eager", mode=Mode.WRITE, eager=true)
    @Description(value="Merges the given `NODE` values with the given dynamic labels eagerly.")
    public Stream<UpdatedNodeResult> nodesEager(@Name(value="labels", description="The list of labels used for the generated MERGE statement.") List<String> labelNames, @Name(value="identProps", description="Properties on the node that are always merged.") Map<String, Object> identProps, @Name(value="onCreateProps", defaultValue="{}", description="Properties that are merged when a node is created.") Map<String, Object> onCreateProps, @Name(value="onMatchProps", defaultValue="{}", description="Properties that are merged when a node is matched.") Map<String, Object> onMatchProps) {
        return this.nodes(labelNames, identProps, onCreateProps, onMatchProps);
    }

    @Procedure(value="apoc.merge.node", mode=Mode.WRITE)
    @Description(value="Merges the given `NODE` values with the given dynamic labels.")
    public Stream<UpdatedNodeResult> nodes(@Name(value="labels", description="The list of labels used for the generated MERGE statement.") List<String> labelNames, @Name(value="identProps", description="Properties on the node that are always merged.") Map<String, Object> identProps, @Name(value="onCreateProps", defaultValue="{}", description="Properties that are merged when a node is created.") Map<String, Object> onCreateProps, @Name(value="onMatchProps", defaultValue="{}", description="Properties that are merged when a node is matched.") Map<String, Object> onMatchProps) {
        Result nodeResult = this.getNodeResult(labelNames, identProps, onCreateProps, onMatchProps);
        return nodeResult.columnAs("n").stream().map(node -> new UpdatedNodeResult((Node)node));
    }

    @Procedure(value="apoc.merge.nodeWithStats.eager", mode=Mode.WRITE, eager=true)
    @Description(value="Merges the given `NODE` values with the given dynamic labels eagerly. Provides queryStatistics in the result.")
    public Stream<NodeResultWithStats> nodeWithStatsEager(@Name(value="labels", description="The list of labels used for the generated MERGE statement.") List<String> labelNames, @Name(value="identProps", description="Properties on the node that are always merged.") Map<String, Object> identProps, @Name(value="onCreateProps", defaultValue="{}", description="Properties that are merged when a node is created.") Map<String, Object> onCreateProps, @Name(value="onMatchProps", defaultValue="{}", description="Properties that are merged when a node is matched.") Map<String, Object> onMatchProps) {
        return this.nodeWithStats(labelNames, identProps, onCreateProps, onMatchProps);
    }

    @Procedure(value="apoc.merge.nodeWithStats", mode=Mode.WRITE)
    @Description(value="Merges the given `NODE` values with the given dynamic labels. Provides queryStatistics in the result.")
    public Stream<NodeResultWithStats> nodeWithStats(@Name(value="labels", description="The list of labels used for the generated MERGE statement.") List<String> labelNames, @Name(value="identProps", description="Properties on the node that are always merged.") Map<String, Object> identProps, @Name(value="onCreateProps", defaultValue="{}", description="Properties that are merged when a node is created.") Map<String, Object> onCreateProps, @Name(value="onMatchProps", defaultValue="{}", description="Properties that are merged when a node is matched.") Map<String, Object> onMatchProps) {
        Result nodeResult = this.getNodeResult(labelNames, identProps, onCreateProps, onMatchProps);
        return nodeResult.columnAs("n").stream().map(node -> new NodeResultWithStats((Node)node, Cypher.toMap(nodeResult.getQueryStatistics())));
    }

    private Result getNodeResult(List<String> labelNames, Map<String, Object> identProps, Map<String, Object> onCreateProps, Map<String, Object> onMatchProps) {
        if (identProps == null || identProps.isEmpty()) {
            throw new IllegalArgumentException("you need to supply at least one identifying property for a merge");
        }
        if (labelNames != null && (labelNames.contains(null) || labelNames.contains(""))) {
            throw new IllegalArgumentException("The list of label names may not contain any `NULL` or empty `STRING` values. If you wish to merge a `NODE` without a label, pass an empty list instead.");
        }
        Object labels = labelNames == null || labelNames.isEmpty() ? "" : ":" + labelNames.stream().map(Util::quote).collect(Collectors.joining(":"));
        Map<String, Object> params = Util.map("identProps", identProps, "onCreateProps", onCreateProps, "onMatchProps", onMatchProps);
        String identPropsString = this.buildIdentPropsString(identProps);
        String cypher = Util.prefixQuery(this.procedureCallContext, "MERGE (n" + (String)labels + "{" + identPropsString + "}) ON CREATE SET n += $onCreateProps ON MATCH SET n += $onMatchProps RETURN n");
        return this.tx.execute(cypher, params);
    }

    @Procedure(value="apoc.merge.relationship", mode=Mode.WRITE)
    @Description(value="Merges the given `RELATIONSHIP` values with the given dynamic types/properties.")
    public Stream<UpdatedRelationshipResult> relationship(@Name(value="startNode", description="The start node of the relationship.") Node startNode, @Name(value="relType", description="The type of the relationship.") String relType, @Name(value="identProps", description="Properties on the relationship that are always merged.") Map<String, Object> identProps, @Name(value="onCreateProps", description="Properties that are merged when a relationship is created.") Map<String, Object> onCreateProps, @Name(value="endNode", description="The end node of the relationship.") Node endNode, @Name(value="onMatchProps", defaultValue="{}", description="Properties that are merged when a relationship is matched.") Map<String, Object> onMatchProps) {
        Result execute = this.getRelResult(startNode, relType, identProps, onCreateProps, endNode, onMatchProps);
        return execute.columnAs("r").stream().map(rel -> new UpdatedRelationshipResult((Relationship)rel));
    }

    @Procedure(value="apoc.merge.relationshipWithStats", mode=Mode.WRITE)
    @Description(value="Merges the given `RELATIONSHIP` values with the given dynamic types/properties. Provides queryStatistics in the result.")
    public Stream<RelationshipResultWithStats> relationshipWithStats(@Name(value="startNode", description="The start node of the relationship.") Node startNode, @Name(value="relType", description="The type of the relationship.") String relType, @Name(value="identProps", description="Properties on the relationship that are always merged.") Map<String, Object> identProps, @Name(value="onCreateProps", description="Properties that are merged when a relationship is created.") Map<String, Object> onCreateProps, @Name(value="endNode", description="The end node of the relationship.") Node endNode, @Name(value="onMatchProps", defaultValue="{}", description="Properties that are merged when a relationship is matched.") Map<String, Object> onMatchProps) {
        Result relResult = this.getRelResult(startNode, relType, identProps, onCreateProps, endNode, onMatchProps);
        return relResult.columnAs("r").stream().map(rel -> new RelationshipResultWithStats((Relationship)rel, Cypher.toMap(relResult.getQueryStatistics())));
    }

    private Result getRelResult(Node startNode, String relType, Map<String, Object> identProps, Map<String, Object> onCreateProps, Node endNode, Map<String, Object> onMatchProps) {
        String identPropsString = this.buildIdentPropsString(identProps);
        if (relType == null || relType.isEmpty()) {
            throw new IllegalArgumentException("It is not possible to merge a `RELATIONSHIP` without a `RELATIONSHIP` type.");
        }
        Map<String, Object> params = Util.map("identProps", identProps, "onCreateProps", onCreateProps == null ? Collections.emptyMap() : onCreateProps, "onMatchProps", onMatchProps == null ? Collections.emptyMap() : onMatchProps, "startNode", startNode, "endNode", endNode);
        String cypher = "WITH $startNode as startNode, $endNode as endNode MERGE (startNode)-[r:" + Util.quote(relType) + "{" + identPropsString + "}]->(endNode) ON CREATE SET r+= $onCreateProps ON MATCH SET r+= $onMatchProps RETURN r";
        return this.tx.execute(Util.prefixQuery(this.procedureCallContext, cypher), params);
    }

    @Procedure(value="apoc.merge.relationship.eager", mode=Mode.WRITE, eager=true)
    @Description(value="Merges the given `RELATIONSHIP` values with the given dynamic types/properties eagerly.")
    public Stream<UpdatedRelationshipResult> relationshipEager(@Name(value="startNode", description="The start node of the relationship.") Node startNode, @Name(value="relType", description="The type of the relationship.") String relType, @Name(value="identProps", description="Properties on the relationship that are always merged.") Map<String, Object> identProps, @Name(value="onCreateProps", description="Properties that are merged when a relationship is created.") Map<String, Object> onCreateProps, @Name(value="endNode", description="The end node of the relationship.") Node endNode, @Name(value="onMatchProps", defaultValue="{}", description="Properties that are merged when a relationship is matched.") Map<String, Object> onMatchProps) {
        return this.relationship(startNode, relType, identProps, onCreateProps, endNode, onMatchProps);
    }

    @Procedure(value="apoc.merge.relationshipWithStats.eager", mode=Mode.WRITE, eager=true)
    @Description(value="Merges the given `RELATIONSHIP` values with the given dynamic types/properties eagerly. Provides queryStatistics in the result.")
    public Stream<RelationshipResultWithStats> relationshipWithStatsEager(@Name(value="startNode", description="The start node of the relationship.") Node startNode, @Name(value="relType", description="The type of the relationship.") String relType, @Name(value="identProps", description="Properties on the relationship that are always merged.") Map<String, Object> identProps, @Name(value="onCreateProps", description="Properties that are merged when a relationship is created.") Map<String, Object> onCreateProps, @Name(value="endNode", description="The end node of the relationship.") Node endNode, @Name(value="onMatchProps", defaultValue="{}", description="Properties that are merged when a relationship is matched.") Map<String, Object> onMatchProps) {
        return this.relationshipWithStats(startNode, relType, identProps, onCreateProps, endNode, onMatchProps);
    }

    private String buildIdentPropsString(Map<String, Object> identProps) {
        if (identProps == null) {
            return "";
        }
        return identProps.keySet().stream().map(Util::quote).map(s -> s + ":$identProps." + s).collect(Collectors.joining(","));
    }
}

