/*
 * Decompiled with CFR 0.152.
 */
package apoc.meta;

import apoc.meta.SampleMetaConfig;
import apoc.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class MetaConfig {
    private final Set<String> includeLabels;
    private final Set<String> includeRels;
    private final Set<String> excludeLabels;
    private final Set<String> excludeRels;
    private final boolean addRelationshipsBetweenNodes;
    private final SampleMetaConfig sampleMetaConfig;

    public MetaConfig(Map<String, Object> config, Boolean shouldSampleByDefault) {
        config = config != null ? config : Collections.emptyMap();
        HashSet<String> includesLabelsLocal = new HashSet<String>((Collection)config.getOrDefault("labels", Collections.EMPTY_SET));
        HashSet<String> includesRelsLocal = new HashSet<String>((Collection)config.getOrDefault("rels", Collections.EMPTY_SET));
        HashSet<String> excludesLocal = new HashSet<String>((Collection)config.getOrDefault("excludes", Collections.EMPTY_SET));
        if (includesLabelsLocal.isEmpty()) {
            includesLabelsLocal = new HashSet((Collection)config.getOrDefault("includeLabels", Collections.EMPTY_SET));
        }
        if (includesRelsLocal.isEmpty()) {
            includesRelsLocal = new HashSet((Collection)config.getOrDefault("includeRels", Collections.EMPTY_SET));
        }
        if (excludesLocal.isEmpty()) {
            excludesLocal = new HashSet((Collection)config.getOrDefault("excludeLabels", Collections.EMPTY_SET));
        }
        this.includeLabels = includesLabelsLocal;
        this.includeRels = includesRelsLocal;
        this.excludeLabels = excludesLocal;
        this.excludeRels = new HashSet<String>((Collection)config.getOrDefault("excludeRels", Collections.EMPTY_SET));
        this.sampleMetaConfig = new SampleMetaConfig(config, shouldSampleByDefault);
        this.addRelationshipsBetweenNodes = Util.toBoolean(config.getOrDefault("addRelationshipsBetweenNodes", true));
    }

    public MetaConfig(Map<String, Object> config) {
        this(config, true);
    }

    public Set<String> getIncludeLabels() {
        return this.includeLabels;
    }

    public Set<String> getIncludeRels() {
        return this.includeRels;
    }

    public Set<String> getExcludeLabels() {
        return this.excludeLabels;
    }

    public Set<String> getExcludeRels() {
        return this.excludeRels;
    }

    public long getSample() {
        return this.sampleMetaConfig.getSample();
    }

    public long getMaxRels() {
        return this.sampleMetaConfig.getMaxRels();
    }

    public SampleMetaConfig getSampleMetaConfig() {
        return this.sampleMetaConfig;
    }

    public boolean matches(Label l) {
        if (this.getExcludeLabels().contains(l.name())) {
            return false;
        }
        if (this.getIncludeLabels().isEmpty()) {
            return true;
        }
        return this.getIncludeLabels().contains(l.name());
    }

    public boolean matches(Iterable<Label> labels) {
        boolean match = true;
        for (Label l : labels) {
            match = match || this.matches(l);
        }
        return match;
    }

    public boolean matches(Relationship r) {
        return this.matches(r.getType());
    }

    public boolean matches(RelationshipType rt) {
        String name = rt.name();
        if (this.getExcludeRels().contains(name)) {
            return false;
        }
        if (this.getIncludeRels().isEmpty()) {
            return true;
        }
        return this.getIncludeRels().contains(name);
    }

    public boolean isAddRelationshipsBetweenNodes() {
        return this.addRelationshipsBetweenNodes;
    }
}

