/*
 * Decompiled with CFR 0.152.
 */
package apoc.meta;

import apoc.meta.MetaConfig;
import apoc.meta.tablesforlabels.OrderedLabels;
import apoc.meta.tablesforlabels.PropertyContainerProfile;
import apoc.meta.tablesforlabels.PropertyTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.procedure.Description;

public class Tables4LabelsProfile {
    Map<OrderedLabels, PropertyContainerProfile> labelMap = new LinkedHashMap<OrderedLabels, PropertyContainerProfile>(100);
    Map<String, PropertyContainerProfile> relMap = new LinkedHashMap<String, PropertyContainerProfile>(100);
    Map<OrderedLabels, Long> obsByNode = new LinkedHashMap<OrderedLabels, Long>(100);
    Map<String, Long> obsByRelType = new LinkedHashMap<String, Long>(100);

    public PropertyContainerProfile getNodeProfile(OrderedLabels ol) {
        if (this.labelMap.containsKey(ol)) {
            return this.labelMap.get(ol);
        }
        PropertyContainerProfile p = new PropertyContainerProfile();
        this.labelMap.put(ol, p);
        return p;
    }

    public PropertyContainerProfile getRelProfile(String relType) {
        if (this.relMap.containsKey(relType)) {
            return this.relMap.get(relType);
        }
        PropertyContainerProfile p = new PropertyContainerProfile();
        this.relMap.put(relType, p);
        return p;
    }

    public Long sawNode(OrderedLabels labels) {
        if (this.obsByNode.containsKey(labels)) {
            Long val = this.obsByNode.get(labels) + 1L;
            this.obsByNode.put(labels, val);
            return val;
        }
        this.obsByNode.put(labels, 1L);
        return 1L;
    }

    public Long sawRel(String typeName) {
        if (this.obsByRelType.containsKey(typeName)) {
            Long val = this.obsByRelType.get(typeName) + 1L;
            this.obsByRelType.put(typeName, val);
            return val;
        }
        this.obsByRelType.put(typeName, 1L);
        return 1L;
    }

    public static String labelJoin(Iterable<Label> labels) {
        return StreamSupport.stream(labels.spliterator(), true).map(Label::name).collect(Collectors.joining("@@@"));
    }

    public void observe(Node n, MetaConfig config) {
        OrderedLabels labels = new OrderedLabels(n.getLabels());
        PropertyContainerProfile localNodeProfile = this.getNodeProfile(labels);
        if (config.matches(n.getLabels())) {
            this.sawNode(labels);
            localNodeProfile.observe((Entity)n, true);
        }
        for (RelationshipType type : n.getRelationshipTypes()) {
            int out;
            String typeName = type.name();
            if (!config.matches(type) || (out = n.getDegree(type, Direction.OUTGOING)) == 0) continue;
            for (Relationship r : n.getRelationships(Direction.OUTGOING, new RelationshipType[]{type})) {
                Iterable relStartNode = r.getStartNode().getLabels();
                Iterable relEndNode = r.getEndNode().getLabels();
                String relIdentifier = Tables4LabelsProfile.labelJoin(relStartNode) + "###" + Tables4LabelsProfile.labelJoin(relEndNode) + "###" + typeName;
                PropertyContainerProfile localRelProfile = this.getRelProfile(relIdentifier);
                long seenSoFar = this.sawRel(relIdentifier);
                boolean isNode = false;
                if (seenSoFar > config.getMaxRels()) continue;
                localRelProfile.observe((Entity)r, isNode);
            }
        }
    }

    public Tables4LabelsProfile finished() {
        for (PropertyContainerProfile prof : this.labelMap.values()) {
            prof.finished();
        }
        for (PropertyContainerProfile prof : this.relMap.values()) {
            prof.finished();
        }
        return this;
    }

    public Stream<NodeTypePropertiesEntry> asNodeStream() {
        Set<OrderedLabels> labels = this.labelMap.keySet();
        ArrayList<NodeTypePropertiesEntry> results = new ArrayList<NodeTypePropertiesEntry>(100);
        for (OrderedLabels ol : labels) {
            PropertyContainerProfile prof = this.labelMap.get(ol);
            Long totalObservations = this.obsByNode.get(ol);
            if (prof.propertyNames().size() == 0) {
                results.add(new NodeTypePropertiesEntry(this, ol.asNodeType(), ol.nodeLabels(), null, null, false, 0L, totalObservations));
                continue;
            }
            for (String propertyName : prof.propertyNames()) {
                PropertyTracker tracker = prof.trackerFor(propertyName);
                NodeTypePropertiesEntry entry = new NodeTypePropertiesEntry(this, ol.asNodeType(), ol.nodeLabels(), propertyName, tracker.propertyTypes(), tracker.mandatory, tracker.observations, totalObservations);
                results.add(entry);
            }
        }
        return results.stream();
    }

    public Stream<RelTypePropertiesEntry> asRelStream() {
        Set<String> relTypes = this.relMap.keySet();
        ArrayList<RelTypePropertiesEntry> results = new ArrayList<RelTypePropertiesEntry>(100);
        for (String relType : relTypes) {
            PropertyContainerProfile prof = this.relMap.get(relType);
            Long totalObservations = this.obsByRelType.get(relType);
            if (prof.propertyNames().size() == 0) {
                results.add(new RelTypePropertiesEntry(this, ":`" + decipherRelMap.getRelType(relType) + "`", decipherRelMap.getSourceLabels(relType), decipherRelMap.getTargetLabels(relType), null, null, false, 0L, totalObservations));
                continue;
            }
            for (String propertyName : prof.propertyNames()) {
                PropertyTracker tracker = prof.trackerFor(propertyName);
                results.add(new RelTypePropertiesEntry(this, ":`" + decipherRelMap.getRelType(relType) + "`", decipherRelMap.getSourceLabels(relType), decipherRelMap.getTargetLabels(relType), propertyName, tracker.propertyTypes(), tracker.mandatory, tracker.observations, totalObservations));
            }
        }
        return results.stream();
    }

    public class NodeTypePropertiesEntry {
        @Description(value="The type of the node.")
        public String nodeType;
        @Description(value="The labels on the node.")
        public List<String> nodeLabels;
        @Description(value="The name of the property.")
        public String propertyName;
        @Description(value="The types this property has.")
        public List<String> propertyTypes;
        @Description(value="Whether or not this property exists on all nodes of the given type.")
        public boolean mandatory;
        @Description(value="The number of times this property was observed.")
        public long propertyObservations;
        @Description(value="The number of times the label was seen.")
        public long totalObservations;

        public NodeTypePropertiesEntry(Tables4LabelsProfile this$0, String nodeType, List<String> nodeLabels, String propertyName, List<String> propertyTypes, boolean mandatory, long propertyObservations, long totalObservations) {
            this.nodeType = nodeType;
            this.nodeLabels = nodeLabels;
            this.propertyName = propertyName;
            this.propertyTypes = propertyTypes;
            this.mandatory = mandatory;
            this.propertyObservations = propertyObservations;
            this.totalObservations = totalObservations;
        }
    }

    public class RelTypePropertiesEntry {
        @Description(value="The type of the relationship.")
        public String relType;
        @Description(value="The labels belonging to the start node.")
        public List<String> sourceNodeLabels;
        @Description(value="The labels belonging to the end node.")
        public List<String> targetNodeLabels;
        @Description(value="The name of the property.")
        public String propertyName;
        @Description(value="The types this property has.")
        public List<String> propertyTypes;
        @Description(value="Whether or not this property exists on all nodes of the given type.")
        public boolean mandatory;
        @Description(value="The number of times this property was observed.")
        public long propertyObservations;
        @Description(value="The number of times the label was seen.")
        public long totalObservations;

        public RelTypePropertiesEntry(Tables4LabelsProfile this$0, String relType, List<String> sourceNodeLabels, List<String> targetNodeLabels, String propertyName, List<String> propertyTypes, boolean mandatory, long propertyObservations, long totalObservations) {
            this.relType = relType;
            this.sourceNodeLabels = sourceNodeLabels;
            this.targetNodeLabels = targetNodeLabels;
            this.propertyName = propertyName;
            this.propertyTypes = propertyTypes;
            this.mandatory = mandatory;
            this.propertyObservations = propertyObservations;
            this.totalObservations = totalObservations;
        }
    }

    public static class decipherRelMap {
        public static List<String> getSourceLabels(String relMapIdentifier) {
            String[] components = relMapIdentifier.split("###");
            List<String> sourceNodeLabels = Arrays.asList(components[0].split("@@@"));
            return sourceNodeLabels;
        }

        public static List<String> getTargetLabels(String relMapIdentifier) {
            String[] components = relMapIdentifier.split("###");
            List<String> targetNodeLabels = Arrays.asList(components[1].split("@@@"));
            return targetNodeLabels;
        }

        public static String getRelType(String relMapIdentifier) {
            String[] components = relMapIdentifier.split("###");
            String relTypeName = components[2];
            return relTypeName;
        }
    }
}

