/*
 * Decompiled with CFR 0.152.
 */
package apoc.number;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Numbers {
    @UserFunction(value="apoc.number.format")
    @Description(value="Formats the given `INTEGER` or `FLOAT` using the given pattern and language to produce a `STRING`.")
    public String format(@Name(value="number", description="The number to format.") Object value, @Name(value="pattern", defaultValue="", description="The pattern to format the number in.") String pattern, @Name(value="language", defaultValue="", description="An ISO-compliant language tag.") String lang) {
        Number number = this.validateNumberParam(value);
        if (number == null) {
            return null;
        }
        DecimalFormat format = this.buildFormatter(pattern, lang);
        if (format == null) {
            return null;
        }
        return format.format(number);
    }

    @UserFunction(value="apoc.number.parseInt")
    @Description(value="Parses the given `STRING` using the given pattern and language to produce a `INTEGER`.")
    public Long parseInt(@Name(value="text", description="The string to parse an integer from.") String text, @Name(value="pattern", defaultValue="", description="The pattern the given string is in.") String pattern, @Name(value="language", defaultValue="", description="An ISO-compliant language tag.") String lang) {
        Number res = this.parseNumber(text, pattern, lang);
        return res == null ? null : Long.valueOf(res.longValue());
    }

    private Number parseNumber(@Name(value="text") String text, @Name(value="pattern", defaultValue="") String pattern, @Name(value="lang", defaultValue="") String lang) {
        if (StringUtils.isBlank(text)) {
            return null;
        }
        try {
            return this.buildFormatter(pattern, lang).parse(text);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @UserFunction(value="apoc.number.parseFloat")
    @Description(value="Parses the given `STRING` using the given pattern and language to produce a `FLOAT`.")
    public Double parseFloat(@Name(value="text", description="The string to parse a float from.") String text, @Name(value="pattern", defaultValue="", description="The pattern the given string is in.") String pattern, @Name(value="language", defaultValue="", description="An ISO-compliant language tag.") String lang) {
        Number res = this.parseNumber(text, pattern, lang);
        return res == null ? null : Double.valueOf(res.doubleValue());
    }

    private Number validateNumberParam(Object number) {
        return number instanceof Number ? (Number)((Number)number) : (Number)null;
    }

    private DecimalFormat buildFormatter(String pattern, String language) {
        if ("".equals(pattern)) {
            pattern = null;
        }
        if ("".equals(language)) {
            language = "en";
        }
        Locale locale = null;
        if (language != null) {
            if (!Arrays.asList(Locale.getISOLanguages()).contains(language)) {
                return null;
            }
            locale = new Locale(language);
        }
        DecimalFormatSymbols symbols = null;
        if (locale != null) {
            symbols = new DecimalFormatSymbols(locale);
        }
        DecimalFormat format = null;
        if (pattern == null && symbols == null) {
            format = new DecimalFormat();
        } else if (pattern == null) {
            format = new DecimalFormat();
            format.setDecimalFormatSymbols(symbols);
        } else {
            format = symbols == null ? new DecimalFormat(pattern) : new DecimalFormat(pattern, symbols);
        }
        return format;
    }
}

