/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import apoc.path.LabelMatcher;
import java.util.HashSet;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.traversal.Evaluation;

public class LabelMatcherGroup {
    private boolean endNodesOnly;
    private LabelMatcher allowlistMatcher = new LabelMatcher();
    private LabelMatcher denylistMatcher = new LabelMatcher();
    private LabelMatcher endNodeMatcher = new LabelMatcher();
    private LabelMatcher terminatorNodeMatcher = new LabelMatcher();

    public LabelMatcherGroup addLabels(String fullFilterString) {
        if (fullFilterString != null && !fullFilterString.isEmpty()) {
            String[] elements;
            for (String filterString : elements = fullFilterString.split("\\|")) {
                this.addLabel(filterString);
            }
        }
        return this;
    }

    public LabelMatcherGroup addLabel(String filterString) {
        if (filterString != null && !filterString.isEmpty()) {
            LabelMatcher matcher;
            char operator = filterString.charAt(0);
            switch (operator) {
                case '>': {
                    this.endNodesOnly = true;
                    matcher = this.endNodeMatcher;
                    filterString = filterString.substring(1);
                    break;
                }
                case '/': {
                    this.endNodesOnly = true;
                    matcher = this.terminatorNodeMatcher;
                    filterString = filterString.substring(1);
                    break;
                }
                case '-': {
                    matcher = this.denylistMatcher;
                    filterString = filterString.substring(1);
                    break;
                }
                case '+': {
                    filterString = filterString.substring(1);
                }
                default: {
                    matcher = this.allowlistMatcher;
                }
            }
            matcher.addLabel(filterString);
        }
        return this;
    }

    public Evaluation evaluate(Node node, boolean belowMinLevel) {
        HashSet<String> nodeLabels = new HashSet<String>();
        node.getLabels().forEach(label -> nodeLabels.add(label.name()));
        if (this.denylistMatcher.matchesLabels(nodeLabels)) {
            return Evaluation.EXCLUDE_AND_PRUNE;
        }
        if (this.terminatorNodeMatcher.matchesLabels(nodeLabels)) {
            return belowMinLevel ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_PRUNE;
        }
        if (this.endNodeMatcher.matchesLabels(nodeLabels)) {
            return belowMinLevel ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_CONTINUE;
        }
        if (this.allowlistMatcher.isEmpty() || this.allowlistMatcher.matchesLabels(nodeLabels)) {
            return this.endNodesOnly || belowMinLevel ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_CONTINUE;
        }
        return Evaluation.EXCLUDE_AND_PRUNE;
    }

    public boolean isEndNodesOnly() {
        return this.endNodesOnly;
    }

    public void setEndNodesOnly(boolean endNodesOnly) {
        this.endNodesOnly = endNodesOnly;
    }
}

