/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import apoc.algo.Cover;
import apoc.path.LabelSequenceEvaluator;
import apoc.path.NodeEvaluators;
import apoc.path.RelationshipSequenceExpander;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;

public class PathExplorer {
    public static final Uniqueness UNIQUENESS = Uniqueness.RELATIONSHIP_PATH;
    public static final boolean BFS = true;
    @Context
    public Transaction tx;

    @NotThreadSafe
    @Procedure(value="apoc.path.expand")
    @Description(value="Returns `PATH` values expanded from the start `NODE` following the given `RELATIONSHIP` types from min-depth to max-depth.")
    public Stream<ExpandedPathResult> explorePath(@Name(value="startNode", description="The node to start the algorithm from. `startNode` can be of type `STRING` (elementId()), `INTEGER` (id()), `NODE`, or `LIST<STRING | INTEGER | NODE>`.") Object start, @Name(value="relFilter", description="An allow list of types allowed on the returned relationships.") String pathFilter, @Name(value="labelFilter", description="An allow list of labels allowed on the returned nodes.") String labelFilter, @Name(value="minDepth", description="The minimum number of hops allowed in the returned paths.") long minLevel, @Name(value="maxDepth", description="The maximum number of hops allowed in the returned paths.") long maxLevel) {
        List<Node> nodes = Util.nodeList((InternalTransaction)this.tx, start);
        return this.explorePathPrivate(nodes, pathFilter, labelFilter, minLevel, maxLevel, true, UNIQUENESS, false, -1L, null, null, true).map(ExpandedPathResult::new);
    }

    @NotThreadSafe
    @Procedure(value="apoc.path.expandConfig")
    @Description(value="Returns `PATH` values expanded from the start `NODE` with the given `RELATIONSHIP` types from min-depth to max-depth.")
    public Stream<ExpandedPathResult> expandConfig(@Name(value="startNode", description="The node to start the algorithm from. `startNode` can be of type `STRING` (elementId()), `INTEGER` (id()), `NODE`, or `LIST<STRING | INTEGER | NODE>.") Object start, @Name(value="config", description="{\n    minLevel = -1 :: INTEGER,\n    maxLevel = -1 :: INTEGER,\n    relationshipFilter :: STRING,\n    labelFilter :: STRING,\n    beginSequenceAtStart = true :: BOOLEAN,\n    uniqueness = \"RELATIONSHIP_PATH\" :: STRING,\n    bfs = true :: BOOLEAN,\n    filterStartNode = false :: BOOLEAN,\n    limit = -1 :: INTEGER,\n    optional = false :: BOOLEAN,\n    endNodes :: LIST<NODES>,\n    terminatorNodes:: LIST<NODES>,\n    allowlistNodes:: LIST<NODES>,\n    denylistNodes:: LIST<NODES>\n}\n") Map<String, Object> config) {
        return this.expandConfigPrivate(start, config).map(ExpandedPathResult::new);
    }

    @NotThreadSafe
    @Procedure(value="apoc.path.subgraphNodes")
    @Description(value="Returns the `NODE` values in the sub-graph reachable from the start `NODE` following the given `RELATIONSHIP` types to max-depth.")
    public Stream<SubgraphNodeResult> subgraphNodes(@Name(value="startNode", description="The node to start the algorithm from. `startNode` can be of type `STRING` (elementId()), `INTEGER` (id()), `NODE`, or `LIST<STRING | INTEGER | NODE>`.") Object start, @Name(value="config", description="{\n    minLevel = -1 :: INTEGER,\n    maxLevel = -1 :: INTEGER,\n    relationshipFilter :: STRING,\n    labelFilter :: STRING,\n    beginSequenceAtStart = true :: BOOLEAN,\n    uniqueness = \"RELATIONSHIP_PATH\" :: STRING,\n    bfs = true :: BOOLEAN,\n    filterStartNode = false :: BOOLEAN,\n    limit = -1 :: INTEGER,\n    optional = false :: BOOLEAN,\n    endNodes :: LIST<NODES>,\n    terminatorNodes:: LIST<NODES>,\n    allowlistNodes:: LIST<NODES>,\n    denylistNodes:: LIST<NODES>\n}\n") Map<String, Object> config) {
        HashMap<String, Object> configMap = new HashMap<String, Object>(config);
        configMap.put("uniqueness", "NODE_GLOBAL");
        if (config.containsKey("minLevel") && !config.get("minLevel").equals(0L) && !config.get("minLevel").equals(1L)) {
            throw new IllegalArgumentException("minLevel can only be 0 or 1 in subgraphNodes()");
        }
        return this.expandConfigPrivate(start, configMap).map(path -> path == null ? new SubgraphNodeResult(null) : new SubgraphNodeResult(path.endNode()));
    }

    @NotThreadSafe
    @Procedure(value="apoc.path.subgraphAll")
    @Description(value="Returns the sub-graph reachable from the start `NODE` following the given `RELATIONSHIP` types to max-depth.")
    public Stream<SubgraphGraphResult> subgraphAll(@Name(value="startNode", description="The node to start the algorithm from. `startNode` can be of type `STRING` (elementId()), `INTEGER` (id()), `NODE`, or `LIST<STRING | INTEGER | NODE>.") Object start, @Name(value="config", description="{\n    minLevel = -1 :: INTEGER,\n    maxLevel = -1 :: INTEGER,\n    relationshipFilter :: STRING,\n    labelFilter :: STRING,\n    beginSequenceAtStart = true :: BOOLEAN,\n    uniqueness = \"RELATIONSHIP_PATH\" :: STRING,\n    bfs = true :: BOOLEAN,\n    filterStartNode = false :: BOOLEAN,\n    limit = -1 :: INTEGER,\n    optional = false :: BOOLEAN,\n    endNodes :: LIST<NODES>,\n    terminatorNodes:: LIST<NODES>,\n    allowlistNodes:: LIST<NODES>,\n    denylistNodes:: LIST<NODES>\n}\n") Map<String, Object> config) {
        HashMap<String, Object> configMap = new HashMap<String, Object>(config);
        configMap.remove("optional");
        configMap.put("uniqueness", "NODE_GLOBAL");
        if (config.containsKey("minLevel") && !config.get("minLevel").equals(0L) && !config.get("minLevel").equals(1L)) {
            throw new IllegalArgumentException("minLevel can only be 0 or 1 in subgraphAll()");
        }
        List<Node> subgraphNodes = this.expandConfigPrivate(start, configMap).map(Path::endNode).collect(Collectors.toList());
        List<Relationship> subgraphRels = Cover.coverNodes(subgraphNodes).collect(Collectors.toList());
        return Stream.of(new SubgraphGraphResult(subgraphNodes, subgraphRels));
    }

    @NotThreadSafe
    @Procedure(value="apoc.path.spanningTree")
    @Description(value="Returns spanning tree `PATH` values expanded from the start `NODE` following the given `RELATIONSHIP` types to max-depth.")
    public Stream<SpanningPathResult> spanningTree(@Name(value="startNode", description="The node to start the algorithm from. `startNode` can be of type `STRING` (elementId()), `INTEGER` (id()), `NODE`, or `LIST<STRING | INTEGER | NODE>.") Object start, @Name(value="config", description="{\n    minLevel = -1 :: INTEGER,\n    maxLevel = -1 :: INTEGER,\n    relationshipFilter :: STRING,\n    labelFilter :: STRING,\n    beginSequenceAtStart = true :: BOOLEAN,\n    uniqueness = \"RELATIONSHIP_PATH\" :: STRING,\n    bfs = true :: BOOLEAN,\n    filterStartNode = false :: BOOLEAN,\n    limit = -1 :: INTEGER,\n    optional = false :: BOOLEAN,\n    endNodes :: LIST<NODES>,\n    terminatorNodes:: LIST<NODES>,\n    allowlistNodes:: LIST<NODES>,\n    denylistNodes:: LIST<NODES>\n}\n") Map<String, Object> config) {
        HashMap<String, Object> configMap = new HashMap<String, Object>(config);
        configMap.put("uniqueness", "NODE_GLOBAL");
        if (config.containsKey("minLevel") && !config.get("minLevel").equals(0L) && !config.get("minLevel").equals(1L)) {
            throw new IllegalArgumentException("minLevel can only be 0 or 1 in spanningTree()");
        }
        return this.expandConfigPrivate(start, configMap).map(SpanningPathResult::new);
    }

    private Uniqueness getUniqueness(String uniqueness) {
        for (Uniqueness u : Uniqueness.values()) {
            if (!u.name().equalsIgnoreCase(uniqueness)) continue;
            return u;
        }
        throw new RuntimeException("Invalid uniqueness: '" + uniqueness + "'. Must be one of: " + String.join((CharSequence)", ", (CharSequence[])Arrays.stream(Uniqueness.values()).map(Enum::name).toArray(String[]::new)) + ".");
    }

    private Stream<Path> expandConfigPrivate(@Name(value="start") Object start, @Name(value="config") Map<String, Object> config) {
        List<Node> nodes = Util.nodeList((InternalTransaction)this.tx, start);
        String uniqueness = (String)config.getOrDefault("uniqueness", UNIQUENESS.name());
        String relationshipFilter = config.getOrDefault("relationshipFilter", null);
        String labelFilter = config.getOrDefault("labelFilter", null);
        long minLevel = Util.toLong(config.getOrDefault("minLevel", "-1"));
        long maxLevel = Util.toLong(config.getOrDefault("maxLevel", "-1"));
        boolean bfs = Util.toBoolean(config.getOrDefault("bfs", true));
        boolean filterStartNode = Util.toBoolean(config.getOrDefault("filterStartNode", false));
        long limit = Util.toLong(config.getOrDefault("limit", "-1"));
        boolean optional = Util.toBoolean(config.getOrDefault("optional", false));
        String sequence = config.getOrDefault("sequence", null);
        boolean beginSequenceAtStart = Util.toBoolean(config.getOrDefault("beginSequenceAtStart", true));
        List<Node> endNodes = Util.nodeList((InternalTransaction)this.tx, config.get("endNodes"));
        List<Node> terminatorNodes = Util.nodeList((InternalTransaction)this.tx, config.get("terminatorNodes"));
        List<Node> whitelistNodes = Util.nodeList((InternalTransaction)this.tx, config.get("whitelistNodes"));
        List<Node> blacklistNodes = Util.nodeList((InternalTransaction)this.tx, config.get("blacklistNodes"));
        List<Node> allowlistNodes = Util.nodeList((InternalTransaction)this.tx, config.get("allowlistNodes"));
        List<Node> denylistNodes = Util.nodeList((InternalTransaction)this.tx, config.get("denylistNodes"));
        EnumMap<NodeFilter, List<Node>> nodeFilter = new EnumMap<NodeFilter, List<Node>>(NodeFilter.class);
        if (endNodes != null && !endNodes.isEmpty()) {
            nodeFilter.put(NodeFilter.END_NODES, endNodes);
        }
        if (terminatorNodes != null && !terminatorNodes.isEmpty()) {
            nodeFilter.put(NodeFilter.TERMINATOR_NODES, terminatorNodes);
        }
        if (allowlistNodes != null && !allowlistNodes.isEmpty()) {
            nodeFilter.put(NodeFilter.ALLOWLIST_NODES, allowlistNodes);
        } else if (whitelistNodes != null && !whitelistNodes.isEmpty()) {
            nodeFilter.put(NodeFilter.ALLOWLIST_NODES, whitelistNodes);
        }
        if (denylistNodes != null && !denylistNodes.isEmpty()) {
            nodeFilter.put(NodeFilter.DENYLIST_NODES, denylistNodes);
        } else if (blacklistNodes != null && !blacklistNodes.isEmpty()) {
            nodeFilter.put(NodeFilter.DENYLIST_NODES, blacklistNodes);
        }
        Stream<Path> results = this.explorePathPrivate(nodes, relationshipFilter, labelFilter, minLevel, maxLevel, bfs, this.getUniqueness(uniqueness), filterStartNode, limit, nodeFilter, sequence, beginSequenceAtStart);
        if (optional) {
            return this.optionalStream(results);
        }
        return results;
    }

    private Stream<Path> explorePathPrivate(Iterable<Node> startNodes, String pathFilter, String labelFilter, long minLevel, long maxLevel, boolean bfs, Uniqueness uniqueness, boolean filterStartNode, long limit, EnumMap<NodeFilter, List<Node>> nodeFilter, String sequence, boolean beginSequenceAtStart) {
        Traverser traverser = PathExplorer.traverse(this.tx.traversalDescription(), startNodes, pathFilter, labelFilter, minLevel, maxLevel, uniqueness, bfs, filterStartNode, nodeFilter, sequence, beginSequenceAtStart);
        if (limit == -1L) {
            return Iterables.stream(traverser);
        }
        return Iterables.stream(traverser).limit(limit);
    }

    private Stream<Path> optionalStream(Stream<Path> stream) {
        Stream<Object> optionalStream;
        Iterator itr = stream.iterator();
        if (itr.hasNext()) {
            optionalStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(itr, 0), false);
        } else {
            ArrayList listOfNull = new ArrayList();
            listOfNull.add(null);
            optionalStream = listOfNull.stream();
        }
        return optionalStream;
    }

    public static Traverser traverse(TraversalDescription td, Iterable<Node> startNodes, String pathFilter, String labelFilter, long minLevel, long maxLevel, Uniqueness uniqueness, boolean bfs, boolean filterStartNode, EnumMap<NodeFilter, List<Node>> nodeFilter, String sequence, boolean beginSequenceAtStart) {
        TraversalDescription traversalDescription = td = bfs ? td.breadthFirst() : td.depthFirst();
        if (sequence != null && !sequence.trim().isEmpty()) {
            String[] sequenceSteps = sequence.split(",");
            ArrayList<String> labelSequenceList = new ArrayList<String>();
            ArrayList<String> relSequenceList = new ArrayList<String>();
            for (int index = 0; index < sequenceSteps.length; ++index) {
                ArrayList<Object> seq = (beginSequenceAtStart ? index : index - 1) % 2 == 0 ? labelSequenceList : relSequenceList;
                seq.add(sequenceSteps[index]);
            }
            td = td.expand((PathExpander)new RelationshipSequenceExpander(relSequenceList, beginSequenceAtStart));
            td = td.evaluator((Evaluator)new LabelSequenceEvaluator(labelSequenceList, filterStartNode, beginSequenceAtStart, (int)minLevel));
        } else {
            if (pathFilter != null && !pathFilter.trim().isEmpty()) {
                td = td.expand((PathExpander)new RelationshipSequenceExpander(pathFilter.trim(), beginSequenceAtStart));
            }
            if (labelFilter != null && sequence == null && !labelFilter.trim().isEmpty()) {
                td = td.evaluator((Evaluator)new LabelSequenceEvaluator(labelFilter.trim(), filterStartNode, beginSequenceAtStart, (int)minLevel));
            }
        }
        if (minLevel != -1L) {
            td = td.evaluator(Evaluators.fromDepth((int)((int)minLevel)));
        }
        if (maxLevel != -1L) {
            td = td.evaluator(Evaluators.toDepth((int)((int)maxLevel)));
        }
        if (nodeFilter != null && !nodeFilter.isEmpty()) {
            Evaluator endAndTerminatorNodeEvaluator;
            List<Node> endNodes = nodeFilter.getOrDefault((Object)NodeFilter.END_NODES, Collections.EMPTY_LIST);
            List<Node> terminatorNodes = nodeFilter.getOrDefault((Object)NodeFilter.TERMINATOR_NODES, Collections.EMPTY_LIST);
            List<Node> denylistNodes = nodeFilter.getOrDefault((Object)NodeFilter.DENYLIST_NODES, Collections.EMPTY_LIST);
            ArrayList<Node> allowlistNodes = nodeFilter.containsKey((Object)NodeFilter.ALLOWLIST_NODES) ? new ArrayList<Node>((Collection)nodeFilter.get((Object)NodeFilter.ALLOWLIST_NODES)) : Collections.EMPTY_LIST;
            if (!denylistNodes.isEmpty()) {
                td = td.evaluator(NodeEvaluators.denylistNodeEvaluator(filterStartNode, denylistNodes));
            }
            if ((endAndTerminatorNodeEvaluator = NodeEvaluators.endAndTerminatorNodeEvaluator(filterStartNode, (int)minLevel, endNodes, terminatorNodes)) != null) {
                td = td.evaluator(endAndTerminatorNodeEvaluator);
            }
            if (!allowlistNodes.isEmpty()) {
                allowlistNodes.addAll(endNodes);
                allowlistNodes.addAll(terminatorNodes);
                td = td.evaluator(NodeEvaluators.allowlistNodeEvaluator(filterStartNode, allowlistNodes));
            }
        }
        td = td.uniqueness((UniquenessFactory)uniqueness);
        return td.traverse(startNodes);
    }

    public record SubgraphGraphResult(@Description(value="Nodes part of the returned subgraph.") List<Node> nodes, @Description(value="Relationships part of the returned subgraph.") List<Relationship> relationships) {
    }

    static enum NodeFilter {
        ALLOWLIST_NODES,
        DENYLIST_NODES,
        END_NODES,
        TERMINATOR_NODES;

    }

    public record SubgraphNodeResult(@Description(value="Nodes part of the returned subgraph.") Node node) {
    }

    public static class SpanningPathResult {
        @Description(value="A spanning tree path.")
        public Path path;

        public SpanningPathResult(Path path) {
            this.path = path;
        }
    }

    public static class ExpandedPathResult {
        @Description(value="The expanded path.")
        public Path path;

        public ExpandedPathResult(Path path) {
            this.path = path;
        }
    }
}

