/*
 * Decompiled with CFR 0.152.
 */
package apoc.refactor;

import org.neo4j.graphdb.Relationship;
import org.neo4j.procedure.Description;

public class RefactorRelationshipResult {
    @Description(value="The internal id of the original entity.")
    public long input;
    @Description(value="The copied entity.")
    public Relationship output;
    @Description(value="Any error that occurred during the copy process.")
    public String error;

    public RefactorRelationshipResult(Long id) {
        this.input = id;
    }

    public RefactorRelationshipResult withError(Exception e) {
        this.error = e.getMessage();
        return this;
    }

    public RefactorRelationshipResult withError(String message) {
        this.error = message;
        return this;
    }

    public RefactorRelationshipResult withOther(Relationship rel) {
        this.output = rel;
        return this;
    }
}

