/*
 * Decompiled with CFR 0.152.
 */
package apoc.result;

import apoc.export.util.ExportConfig;
import apoc.result.ProgressInfo;
import apoc.util.Util;
import java.io.StringWriter;
import org.neo4j.procedure.Description;

public class ImportProgressInfo
implements ProgressInfo {
    public static final ImportProgressInfo EMPTY = new ImportProgressInfo(null, null, null);
    @Description(value="The name of the file from which the data was imported.")
    public final String file;
    @Description(value="The source of the imported data: \"file\", \"binary\" or \"file/binary\".")
    public String source;
    @Description(value="The format of the file: [\"csv\", \"graphml\", \"json\"].")
    public final String format;
    @Description(value="The number of imported nodes.")
    public long nodes;
    @Description(value="The number of imported relationships.")
    public long relationships;
    @Description(value="The number of imported properties.")
    public long properties;
    @Description(value="The duration of the import.")
    public long time;
    @Description(value="The number of rows returned.")
    public long rows;
    @Description(value="The size of the batches the import was run in.")
    public long batchSize = -1L;
    @Description(value="The number of batches the import was run in.")
    public long batches;
    @Description(value="Whether the import ran successfully.")
    public boolean done;
    @Description(value="The data returned by the import.")
    public Object data;

    public ImportProgressInfo(String file, String source, String format) {
        this.file = file;
        this.source = source;
        this.format = format;
    }

    public ImportProgressInfo(ImportProgressInfo pi) {
        this.file = pi.file;
        this.source = pi.source;
        this.format = pi.format;
        this.nodes = pi.nodes;
        this.relationships = pi.relationships;
        this.properties = pi.properties;
        this.time = pi.time;
        this.rows = pi.rows;
        this.batchSize = pi.batchSize;
        this.batches = pi.batches;
        this.done = pi.done;
    }

    public String toString() {
        return String.format("nodes = %d rels = %d properties = %d", this.nodes, this.relationships, this.properties);
    }

    @Override
    public ImportProgressInfo update(long nodes, long relationships, long properties) {
        this.nodes += nodes;
        this.relationships += relationships;
        this.properties += properties;
        return this;
    }

    @Override
    public ImportProgressInfo updateTime(long start) {
        this.time = System.currentTimeMillis() - start;
        return this;
    }

    @Override
    public ImportProgressInfo done(long start) {
        this.done = true;
        return this.updateTime(start);
    }

    @Override
    public void nextRow() {
        ++this.rows;
    }

    @Override
    public ImportProgressInfo drain(StringWriter writer, ExportConfig config) {
        if (writer != null) {
            this.data = Util.getStringOrCompressedData(writer, config);
        }
        return this;
    }

    @Override
    public void setBatches(long batches) {
        this.batches = batches;
    }

    @Override
    public void setRows(long rows) {
        this.rows = rows;
    }

    @Override
    public long getBatchSize() {
        return this.batchSize;
    }
}

