/*
 * Decompiled with CFR 0.152.
 */
package apoc.result;

import apoc.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Paths;

public class VirtualPath
implements Path {
    private final Node start;
    private final List<Relationship> relationships;

    public VirtualPath(Node start) {
        this(start, new ArrayList<Relationship>());
    }

    private VirtualPath(Node start, List<Relationship> relationships) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(relationships);
        this.start = start;
        this.relationships = relationships;
    }

    public void addRel(Relationship relationship) {
        Objects.requireNonNull(relationship);
        this.requireConnected(relationship);
        this.relationships.add(relationship);
    }

    public Node startNode() {
        return this.start;
    }

    public Node endNode() {
        return this.reverseNodes().iterator().next();
    }

    public Relationship lastRelationship() {
        return this.relationships.isEmpty() ? null : this.relationships.get(this.relationships.size() - 1);
    }

    public Iterable<Relationship> relationships() {
        return this.relationships;
    }

    public Iterable<Relationship> reverseRelationships() {
        return () -> new ReverseIterator<Relationship>(this.relationships);
    }

    public Iterable<Node> nodes() {
        return this.nodeList();
    }

    public Iterable<Node> reverseNodes() {
        return () -> new ReverseIterator<Node>(this.nodeList());
    }

    public int length() {
        return this.relationships.size();
    }

    @Nonnull
    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            Iterator<? extends Entity> current;
            Iterator<? extends Entity> next;
            {
                this.current = VirtualPath.this.nodes().iterator();
                this.next = VirtualPath.this.relationships().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.current.hasNext();
            }

            @Override
            public Entity next() {
                try {
                    Entity entity = this.current.next();
                    return entity;
                }
                finally {
                    Iterator<? extends Entity> temp = this.current;
                    this.current = this.next;
                    this.next = temp;
                }
            }

            @Override
            public void remove() {
                this.next.remove();
            }
        };
    }

    public String toString() {
        return Paths.defaultPathToString((Path)this);
    }

    private void requireConnected(Relationship relationship) {
        List<Node> previousNodes = this.getPreviousNodes();
        boolean isRelConnectedToPrevious = CollectionUtils.containsAny(previousNodes, relationship.getNodes());
        if (!isRelConnectedToPrevious) {
            throw new IllegalArgumentException("Relationship is not part of current path.");
        }
    }

    private List<Node> nodeList() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(this.start);
        AtomicReference<Node> currNode = new AtomicReference<Node>(this.start);
        List<Node> otherNodes = this.relationships.stream().map(rel -> {
            Node otherNode = rel.getOtherNode((Node)currNode.get());
            currNode.set(otherNode);
            return otherNode;
        }).toList();
        nodes.addAll(otherNodes);
        return nodes;
    }

    private List<Node> getPreviousNodes() {
        Relationship previousRelationship = this.lastRelationship();
        if (previousRelationship != null) {
            return Arrays.asList(previousRelationship.getNodes());
        }
        return List.of(this.endNode());
    }

    private static class ReverseIterator<T>
    implements Iterator<T> {
        private final List<T> list;
        private int index;

        private ReverseIterator(List<T> list) {
            this.list = list;
            this.index = list.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public T next() {
            return this.list.get(this.index--);
        }
    }
}

