/*
 * Decompiled with CFR 0.152.
 */
package apoc.schema;

import apoc.result.IndexConstraintNodeInfo;
import apoc.result.IndexConstraintRelationshipInfo;
import apoc.schema.SchemaConfig;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;

public class SchemaRestricted {
    private static final String IDX_NOT_FOUND = "NOT_FOUND";
    @Context
    public Transaction tx;
    @Context
    public KernelTransaction ktx;
    @Context
    public ProcedureCallContext procedureCallContext;

    @NotThreadSafe
    @Procedure(name="apoc.schema.nodes", mode=Mode.SCHEMA)
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Returns all indexes and constraints information for all `NODE` labels in the database.\nIt is possible to define a set of labels to include or exclude in the config parameters.")
    public Stream<IndexConstraintNodeInfo> schemaNodesCypher5(@Name(value="config", defaultValue="{}", description="{\n    labels :: LIST<STRING>,\n    excludeLabels :: LIST<STRING>,\n    relationships :: LIST<STRING>,\n    excludeRelationships :: LIST<STRING>\n}\n") Map<String, Object> config) {
        return this.indexesAndConstraintsForNode(config, false);
    }

    @NotThreadSafe
    @Procedure(name="apoc.schema.nodes", mode=Mode.SCHEMA)
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Returns all indexes and constraints information for all `NODE` labels in the database.\nIt is possible to define a set of labels to include or exclude in the config parameters.")
    public Stream<IndexConstraintNodeInfo> nodes(@Name(value="config", defaultValue="{}", description="{\n    labels :: LIST<STRING>,\n    excludeLabels :: LIST<STRING>,\n    relationships :: LIST<STRING>,\n    excludeRelationships :: LIST<STRING>\n}\n") Map<String, Object> config) {
        return this.indexesAndConstraintsForNode(config, true);
    }

    @NotThreadSafe
    @Procedure(name="apoc.schema.relationships", mode=Mode.SCHEMA)
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Returns the indexes and constraints information for all the relationship types in the database.\nIt is possible to define a set of relationship types to include or exclude in the config parameters.")
    public Stream<IndexConstraintRelationshipInfo> schemaRelationshipsCypher5(@Name(value="config", defaultValue="{}", description="{\n    labels :: LIST<STRING>,\n    excludeLabels :: LIST<STRING>,\n    relationships :: LIST<STRING>,\n    excludeRelationships :: LIST<STRING>\n}\n") Map<String, Object> config) {
        return this.indexesAndConstraintsForRelationships(config, false);
    }

    @NotThreadSafe
    @Procedure(name="apoc.schema.relationships", mode=Mode.SCHEMA)
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Returns the indexes and constraints information for all the relationship types in the database.\nIt is possible to define a set of relationship types to include or exclude in the config parameters.")
    public Stream<IndexConstraintRelationshipInfo> relationships(@Name(value="config", defaultValue="{}", description="{\n    labels :: LIST<STRING>,\n    excludeLabels :: LIST<STRING>,\n    relationships :: LIST<STRING>,\n    excludeRelationships :: LIST<STRING>\n}\n") Map<String, Object> config) {
        return this.indexesAndConstraintsForRelationships(config, true);
    }

    private Stream<IndexConstraintNodeInfo> indexesAndConstraintsForNode(Map<String, Object> config, Boolean useStoredName) {
        Schema schema = this.tx.schema();
        SchemaConfig schemaConfig = new SchemaConfig(config);
        Set<String> includeLabels = schemaConfig.getLabels();
        Set<String> excludeLabels = schemaConfig.getExcludeLabels();
        try (Statement ignore = this.ktx.acquireStatement();){
            Iterable constraintsIterator;
            Iterable<Object> indexesIterator;
            TokenRead tokenRead = this.ktx.tokenRead();
            SchemaRead schemaRead = this.ktx.schemaRead();
            Predicate<ConstraintDefinition> isNodeConstraint = constraintDefinition -> Util.isNodeCategory(constraintDefinition.getConstraintType());
            if (includeLabels.isEmpty()) {
                Iterator allIndex = schemaRead.indexesGetAll();
                indexesIterator = this.getIndexesFromSchema(allIndex, index -> index.schema().entityType().equals((Object)EntityType.NODE) && Arrays.stream(index.schema().getEntityTokenIds()).noneMatch(id -> {
                    try {
                        return excludeLabels.contains(tokenRead.nodeLabelName(id));
                    }
                    catch (LabelNotFoundKernelException e) {
                        return false;
                    }
                }));
                Iterable allConstraints = schema.getConstraints();
                constraintsIterator = StreamSupport.stream(allConstraints.spliterator(), false).filter(isNodeConstraint).filter(constraint -> !excludeLabels.contains(constraint.getLabel().name())).collect(Collectors.toList());
            } else {
                constraintsIterator = includeLabels.stream().filter(label -> !excludeLabels.contains(label) && tokenRead.nodeLabel(label) != -1).flatMap(label -> {
                    Iterable constraintsForType = schema.getConstraints(Label.label((String)label));
                    return StreamSupport.stream(constraintsForType.spliterator(), false).filter(isNodeConstraint);
                }).collect(Collectors.toList());
                indexesIterator = includeLabels.stream().filter(label -> !excludeLabels.contains(label) && tokenRead.nodeLabel(label) != -1).flatMap(label -> {
                    Iterable indexesForLabel = () -> schemaRead.indexesGetForLabel(tokenRead.nodeLabel(label));
                    return StreamSupport.stream(indexesForLabel.spliterator(), false);
                }).collect(Collectors.toList());
            }
            Stream<IndexConstraintNodeInfo> constraintNodeInfoStream = StreamSupport.stream(constraintsIterator.spliterator(), false).map(constraintDescriptor -> this.nodeInfoFromConstraintDefinition((ConstraintDefinition)constraintDescriptor, (TokenNameLookup)tokenRead, useStoredName)).sorted(Comparator.comparing(i -> i.label.toString()));
            Stream<IndexConstraintNodeInfo> indexNodeInfoStream = StreamSupport.stream(indexesIterator.spliterator(), false).map(indexDescriptor -> this.nodeInfoFromIndexDefinition((IndexDescriptor)indexDescriptor, schemaRead, (TokenNameLookup)tokenRead, useStoredName)).sorted(Comparator.comparing(i -> i.label.toString()));
            Stream<IndexConstraintNodeInfo> stream = Stream.of(constraintNodeInfoStream, indexNodeInfoStream).flatMap(e -> e);
            return stream;
        }
    }

    private List<IndexDescriptor> getIndexesFromSchema(Iterator<IndexDescriptor> allIndex, Predicate<IndexDescriptor> indexDescriptorPredicate) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(allIndex, 16), false).filter(indexDescriptorPredicate).collect(Collectors.toList());
    }

    private Stream<IndexConstraintRelationshipInfo> indexesAndConstraintsForRelationships(Map<String, Object> config, Boolean useStoredName) {
        Schema schema = this.tx.schema();
        SchemaConfig schemaConfig = new SchemaConfig(config);
        Set<String> includeRelationships = schemaConfig.getRelationships();
        Set<String> excludeRelationships = schemaConfig.getExcludeRelationships();
        try (Statement ignore = this.ktx.acquireStatement();){
            Iterable<Object> indexesIterator;
            Iterable constraintsIterator;
            TokenRead tokenRead = this.ktx.tokenRead();
            SchemaRead schemaRead = this.ktx.schemaRead();
            Predicate<ConstraintDefinition> isRelConstraint = constraintDefinition -> Util.isRelationshipCategory(constraintDefinition.getConstraintType());
            if (!includeRelationships.isEmpty()) {
                constraintsIterator = includeRelationships.stream().filter(type -> !excludeRelationships.contains(type) && tokenRead.relationshipType(type) != -1).flatMap(type -> {
                    Iterable constraintsForType = schema.getConstraints(RelationshipType.withName((String)type));
                    return StreamSupport.stream(constraintsForType.spliterator(), false).filter(isRelConstraint);
                }).collect(Collectors.toList());
                indexesIterator = includeRelationships.stream().filter(type -> !excludeRelationships.contains(type) && tokenRead.relationshipType(type) != -1).flatMap(type -> {
                    Iterable indexesForRelType = () -> schemaRead.indexesGetForRelationshipType(tokenRead.relationshipType(type));
                    return StreamSupport.stream(indexesForRelType.spliterator(), false);
                }).collect(Collectors.toList());
            } else {
                Iterable allConstraints = schema.getConstraints();
                constraintsIterator = StreamSupport.stream(allConstraints.spliterator(), false).filter(isRelConstraint).filter(constraint -> !excludeRelationships.contains(constraint.getRelationshipType().name())).collect(Collectors.toList());
                Iterator allIndex = schemaRead.indexesGetAll();
                indexesIterator = this.getIndexesFromSchema(allIndex, index -> index.schema().entityType().equals((Object)EntityType.RELATIONSHIP) && Arrays.stream(index.schema().getEntityTokenIds()).noneMatch(id -> excludeRelationships.contains(tokenRead.relationshipTypeGetName(id))));
            }
            Stream<IndexConstraintRelationshipInfo> constraintRelationshipInfoStream = StreamSupport.stream(constraintsIterator.spliterator(), false).map(c -> this.relationshipInfoFromConstraintDefinition((ConstraintDefinition)c, useStoredName));
            Stream<IndexConstraintRelationshipInfo> indexRelationshipInfoStream = StreamSupport.stream(indexesIterator.spliterator(), false).map(index -> this.relationshipInfoFromIndexDescription((IndexDescriptor)index, (TokenNameLookup)tokenRead, schemaRead, useStoredName));
            Stream<IndexConstraintRelationshipInfo> stream = Stream.of(constraintRelationshipInfoStream, indexRelationshipInfoStream).flatMap(e -> e);
            return stream;
        }
    }

    private IndexConstraintNodeInfo nodeInfoFromConstraintDefinition(ConstraintDefinition constraintDefinition, TokenNameLookup tokens, Boolean useStoredName) {
        String labelName = constraintDefinition.getLabel().name();
        List<String> properties = Iterables.asList(constraintDefinition.getPropertyKeys());
        return new IndexConstraintNodeInfo(useStoredName != false ? constraintDefinition.getName() : String.format(":%s(%s)", labelName, StringUtils.join(properties, ",")), labelName, properties, "", constraintDefinition.getConstraintType().name(), "NO FAILURE", 0.0f, 0L, 0.0, this.nodeConstraintCypher5Compatibility(this.ktx.schemaRead().constraintGetForName(constraintDefinition.getName()).userDescription(tokens), useStoredName));
    }

    private String nodeConstraintCypher5Compatibility(String userDescription, Boolean useStoredName) {
        if (useStoredName.booleanValue()) {
            return userDescription;
        }
        return userDescription.replace("'NODE PROPERTY UNIQUENESS'", "'UNIQUENESS'");
    }

    private IndexConstraintNodeInfo nodeInfoFromIndexDefinition(IndexDescriptor indexDescriptor, SchemaRead schemaRead, TokenNameLookup tokens, Boolean useStoredName) {
        List labels;
        int[] labelIds = indexDescriptor.schema().getEntityTokenIds();
        int length = labelIds.length;
        Object labelName = length == 0 ? "<any-labels>" : ((labels = IntStream.of(labelIds).mapToObj(arg_0 -> ((TokenNameLookup)tokens).labelGetName(arg_0)).sorted().collect(Collectors.toList())).size() > 1 ? labels : labels.get(0));
        List<String> properties = IntStream.of(indexDescriptor.schema().getPropertyIds()).mapToObj(arg_0 -> ((TokenNameLookup)tokens).propertyKeyGetName(arg_0)).collect(Collectors.toList());
        String schemaInfoName = this.getSchemaInfoName(labelName, properties);
        String userDescription = indexDescriptor.userDescription(tokens);
        try {
            return new IndexConstraintNodeInfo(useStoredName != false ? indexDescriptor.getName() : schemaInfoName, labelName, properties, schemaRead.indexGetState(indexDescriptor).toString(), SchemaRestricted.getIndexType(indexDescriptor), schemaRead.indexGetState(indexDescriptor).equals((Object)InternalIndexState.FAILED) ? schemaRead.indexGetFailure(indexDescriptor) : "NO FAILURE", this.getPopulationProgress(indexDescriptor, schemaRead), schemaRead.indexSize(indexDescriptor), schemaRead.indexUniqueValuesSelectivity(indexDescriptor), userDescription);
        }
        catch (IndexNotFoundKernelException e) {
            return new IndexConstraintNodeInfo(schemaInfoName, labelName, properties, IDX_NOT_FOUND, SchemaRestricted.getIndexType(indexDescriptor), IDX_NOT_FOUND, 0.0f, 0L, 0.0, userDescription);
        }
    }

    private IndexConstraintRelationshipInfo relationshipInfoFromIndexDescription(IndexDescriptor indexDescriptor, TokenNameLookup tokens, SchemaRead schemaRead, Boolean useStoredName) {
        String indexStatus;
        List rels;
        int[] relIds = indexDescriptor.schema().getEntityTokenIds();
        int length = relIds.length;
        Object relName = length == 0 ? "<any-types>" : ((rels = IntStream.of(relIds).mapToObj(arg_0 -> ((TokenNameLookup)tokens).relationshipTypeGetName(arg_0)).sorted().collect(Collectors.toList())).size() > 1 ? rels : rels.get(0));
        List<String> properties = Arrays.stream(indexDescriptor.schema().getPropertyIds()).mapToObj(arg_0 -> ((TokenNameLookup)tokens).propertyKeyGetName(arg_0)).collect(Collectors.toList());
        String name = useStoredName != false ? indexDescriptor.getName() : this.getSchemaInfoName(relName, properties);
        String schemaType = SchemaRestricted.getIndexType(indexDescriptor);
        try {
            indexStatus = schemaRead.indexGetState(indexDescriptor).toString();
        }
        catch (IndexNotFoundKernelException e) {
            indexStatus = IDX_NOT_FOUND;
        }
        return new IndexConstraintRelationshipInfo(name, schemaType, properties, indexStatus, relName);
    }

    private IndexConstraintRelationshipInfo relationshipInfoFromConstraintDefinition(ConstraintDefinition constraintDefinition, Boolean useStoredName) {
        return new IndexConstraintRelationshipInfo(useStoredName != false ? constraintDefinition.getName() : String.format("CONSTRAINT %s", constraintDefinition.toString()), constraintDefinition.getConstraintType().name(), Iterables.asList(constraintDefinition.getPropertyKeys()), "", constraintDefinition.getRelationshipType().name());
    }

    private static String getIndexType(IndexDescriptor indexDescriptor) {
        return indexDescriptor.getIndexType().name();
    }

    private String getSchemaInfoName(Object labelOrType, List<String> properties) {
        String labelOrTypeAsString = labelOrType instanceof String ? (String)labelOrType : StringUtils.join(labelOrType, ",");
        return String.format(":%s(%s)", labelOrTypeAsString, StringUtils.join(properties, ","));
    }

    private long getPopulationProgress(IndexDescriptor indexDescriptor, SchemaRead schemaRead) throws IndexNotFoundKernelException {
        PopulationProgress populationProgress = schemaRead.indexGetPopulationProgress(indexDescriptor);
        long populationTotal = populationProgress.getTotal();
        if (populationTotal == 0L) {
            return 0L;
        }
        return populationProgress.getCompleted() / populationTotal * 100L;
    }
}

