/*
 * Decompiled with CFR 0.152.
 */
package apoc.trigger;

import apoc.ApocConfig;
import apoc.SystemLabels;
import apoc.SystemPropertyKeys;
import apoc.trigger.TriggerInfo;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;

public class TriggerHandlerNewProcedures {
    public static final String NOT_ENABLED_ERROR = "Triggers have not been enabled. Set 'apoc.trigger.enabled=true' in your apoc.conf file located in the $NEO4J_HOME/conf/ directory.";

    private static boolean isEnabled() {
        return ApocConfig.apocConfig().getBoolean("apoc.trigger.enabled");
    }

    public static void checkEnabled() {
        if (!TriggerHandlerNewProcedures.isEnabled()) {
            throw new RuntimeException(NOT_ENABLED_ERROR);
        }
    }

    public static TriggerInfo install(String databaseName, String triggerName, String statement, Map<String, Object> selector, Map<String, Object> params, Transaction tx) {
        Node node = Util.mergeNode(tx, SystemLabels.ApocTrigger, null, Pair.of(SystemPropertyKeys.database.name(), databaseName), Pair.of(SystemPropertyKeys.name.name(), triggerName));
        node.setProperty(SystemPropertyKeys.statement.name(), (Object)statement);
        node.setProperty(SystemPropertyKeys.selector.name(), (Object)Util.toJson(selector));
        node.setProperty(SystemPropertyKeys.params.name(), (Object)Util.toJson(params));
        node.setProperty(SystemPropertyKeys.paused.name(), (Object)false);
        TriggerInfo result = TriggerInfo.fromNode(node, true);
        TriggerHandlerNewProcedures.setLastUpdate(databaseName, tx);
        return result;
    }

    public static TriggerInfo drop(String databaseName, String triggerName, Transaction tx) {
        TriggerInfo[] previous = new TriggerInfo[1];
        TriggerHandlerNewProcedures.getTriggerNodes(databaseName, tx, triggerName).forEachRemaining(node -> {
            previous[0] = TriggerInfo.fromNode(node, false);
            node.delete();
        });
        TriggerHandlerNewProcedures.setLastUpdate(databaseName, tx);
        return previous[0];
    }

    public static TriggerInfo updatePaused(String databaseName, String name, boolean paused, Transaction tx) {
        TriggerInfo[] result = new TriggerInfo[1];
        TriggerHandlerNewProcedures.getTriggerNodes(databaseName, tx, name).forEachRemaining(node -> {
            node.setProperty(SystemPropertyKeys.paused.name(), (Object)paused);
            result[0] = TriggerInfo.fromNode(node, true);
        });
        TriggerHandlerNewProcedures.setLastUpdate(databaseName, tx);
        return result[0];
    }

    public static List<TriggerInfo> dropAll(String databaseName, Transaction tx) {
        ArrayList<TriggerInfo> previous = new ArrayList<TriggerInfo>();
        TriggerHandlerNewProcedures.getTriggerNodes(databaseName, tx).forEachRemaining(node -> {
            previous.add(TriggerInfo.fromNode(node, false));
            node.delete();
        });
        TriggerHandlerNewProcedures.setLastUpdate(databaseName, tx);
        return previous;
    }

    public static Stream<TriggerInfo> getTriggerNodesList(String databaseName, Transaction tx) {
        return TriggerHandlerNewProcedures.getTriggerNodes(databaseName, tx).stream().map(trigger -> TriggerInfo.fromNode(trigger, true));
    }

    public static ResourceIterator<Node> getTriggerNodes(String databaseName, Transaction tx) {
        return TriggerHandlerNewProcedures.getTriggerNodes(databaseName, tx, null);
    }

    public static ResourceIterator<Node> getTriggerNodes(String databaseName, Transaction tx, String name) {
        SystemLabels label = SystemLabels.ApocTrigger;
        String dbNameKey = SystemPropertyKeys.database.name();
        if (name == null) {
            return tx.findNodes((Label)label, dbNameKey, (Object)databaseName);
        }
        return tx.findNodes((Label)label, dbNameKey, (Object)databaseName, SystemPropertyKeys.name.name(), (Object)name);
    }

    public static void setLastUpdate(String databaseName, Transaction tx) {
        Node node = tx.findNode((Label)SystemLabels.ApocTriggerMeta, SystemPropertyKeys.database.name(), (Object)databaseName);
        if (node == null) {
            node = tx.createNode(new Label[]{SystemLabels.ApocTriggerMeta});
            node.setProperty(SystemPropertyKeys.database.name(), (Object)databaseName);
        }
        long value = System.currentTimeMillis();
        node.setProperty(SystemPropertyKeys.lastUpdated.name(), (Object)value);
    }
}

