/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;

class CountOptimisedDatabaseSubGraph
extends DatabaseSubGraph {
    private final TokenRead tokenRead;
    private final Read read;

    public CountOptimisedDatabaseSubGraph(Transaction transaction, KernelTransaction kernelTx) {
        super(transaction);
        this.tokenRead = kernelTx.tokenRead();
        this.read = kernelTx.dataRead();
    }

    @Override
    public long countsForNode(Label label) {
        int nodeLabelID = this.tokenRead.nodeLabel(label.name());
        if (nodeLabelID < 0) {
            return 0L;
        }
        return this.read.countsForNode(nodeLabelID);
    }

    @Override
    public long countsForRelationship(RelationshipType type, Label end) {
        int relTypeID = this.tokenRead.relationshipType(type.name());
        int nodeLabelID = this.tokenRead.nodeLabel(end.name());
        if (nodeLabelID < 0 || relTypeID < 0) {
            return 0L;
        }
        return this.read.countsForRelationship(-1, relTypeID, nodeLabelID);
    }

    @Override
    public long countsForRelationship(Label start, RelationshipType type) {
        int relTypeID = this.tokenRead.relationshipType(type.name());
        int nodeLabelID = this.tokenRead.nodeLabel(start.name());
        if (nodeLabelID < 0 || relTypeID < 0) {
            return 0L;
        }
        return this.read.countsForRelationship(nodeLabelID, relTypeID, -1);
    }

    @Override
    public long countsForRelationship(RelationshipType type) {
        int relTypeID = this.tokenRead.relationshipType(type.name());
        if (relTypeID < 0) {
            return 0L;
        }
        return this.read.countsForRelationship(-1, relTypeID, -1);
    }
}

