/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.dbms.systemgraph.ExternalDatabaseCredentials;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public interface TopologyGraphDbmsModel {
    public static final Label DATABASE_LABEL = Label.label((String)"Database");
    public static final String DATABASE = DATABASE_LABEL.name();
    public static final Label DELETED_DATABASE_LABEL = Label.label((String)"DeletedDatabase");
    public static final String DATABASE_UUID_PROPERTY = "uuid";
    public static final String DATABASE_NAME_PROPERTY = "name";
    public static final String DATABASE_STATUS_PROPERTY = "status";
    public static final String DATABASE_ACCESS_PROPERTY = "access";
    @Deprecated
    public static final String DATABASE_DEFAULT_PROPERTY = "default";
    @Deprecated
    public static final String DATABASE_VIRTUAL_PROPERTY = "virtual";
    public static final String DATABASE_UPDATE_ID_PROPERTY = "update_id";
    public static final String DATABASE_STORE_RANDOM_ID_PROPERTY = "store_random_id";
    @Deprecated
    public static final String DATABASE_DESIGNATED_SEEDER_PROPERTY = "designated_seeder";
    public static final String DATABASE_SEEDING_SERVERS_PROPERTY = "seeding_servers";
    public static final String DATABASE_STORE_FORMAT_NEW_DB_PROPERTY = "creation_store_format";
    public static final String DATABASE_PRIMARIES_PROPERTY = "primaries";
    public static final String DATABASE_SECONDARIES_PROPERTY = "secondaries";
    public static final String DATABASE_SEED_URI_PROPERTY = "seedURI";
    public static final String DATABASE_SEED_SOURCE_DATABASE_PROPERTY = "seedSourceDatabase";
    public static final String DATABASE_SEED_CREDENTIALS_ENCRYPTED_PROPERTY = "seedCredentialsEncrypted";
    public static final String DATABASE_SEED_CREDENTIALS_IV_PROPERTY = "seedCredentialsIv";
    public static final String DATABASE_SEED_CONFIG_PROPERTY = "seedConfig";
    public static final String DATABASE_SEED_RESTORE_UNTIL_PROPERTY = "seedRestoreUntil";
    public static final String DATABASE_CREATED_AT_PROPERTY = "created_at";
    public static final String DATABASE_STARTED_AT_PROPERTY = "started_at";
    public static final String DATABASE_UPDATED_AT_PROPERTY = "updated_at";
    public static final String DATABASE_STOPPED_AT_PROPERTY = "stopped_at";
    public static final String DATABASE_EXTERNAL_ID_PROPERTY = "external_id";
    public static final String DELETED_DATABASE_DUMP_DATA_PROPERTY = "dump_data";
    public static final String DELETED_DATABASE_DELETED_AT_PROPERTY = "deleted_at";
    public static final String DELETED_DATABASE_KEEP_DATA_PROPERTY = "keep_data";
    public static final String DATABASE_LOG_ENRICHMENT_PROPERTY = "txLogEnrichment";
    public static final String DATABASE_BOOTSTRAP_KERNEL_VERSION_PROPERTY = "bootstrapKernelVersion";
    public static final String DATABASE_DEFAULT_LANGUAGE_PROPERTY = "defaultLanguage";
    public static final String DATABASE_BACKPRESSURE_ENABLED_PROPERTY = "backpressureEnabled";
    public static final String DATABASE_MIRROR_URI_PROPERTY = "mirrorURI";
    public static final Label DATABASE_NAME_LABEL = Label.label((String)"DatabaseName");
    public static final String DATABASE_NAME = DATABASE_NAME_LABEL.name();
    public static final String DATABASE_NAME_LABEL_DESCRIPTION = "Database alias";
    public static final Label SPD_LABEL = Label.label((String)"Spd");
    public static final String SPD = SPD_LABEL.name();
    public static final Label GRAPH_SHARD_LABEL = Label.label((String)"GraphShard");
    public static final String GRAPH_SHARD = GRAPH_SHARD_LABEL.name();
    public static final Label PROPERTY_SHARD_LABEL = Label.label((String)"PropertyShard");
    public static final String PROPERTY_SHARD = PROPERTY_SHARD_LABEL.name();
    public static final Label COMPOSITE_DATABASE_LABEL = Label.label((String)"CompositeDatabase");
    public static final String COMPOSITE_DATABASE = COMPOSITE_DATABASE_LABEL.name();
    public static final String NAME_PROPERTY = "name";
    public static final String VERSION_PROPERTY = "version";
    public static final RelationshipType TARGETS_RELATIONSHIP = RelationshipType.withName((String)"TARGETS");
    public static final String TARGETS = TARGETS_RELATIONSHIP.name();
    public static final String TARGET_NAME_PROPERTY = "target_name";
    public static final String PRIMARY_PROPERTY = "primary";
    public static final String NAMESPACE_PROPERTY = "namespace";
    public static final String DISPLAY_NAME_PROPERTY = "displayName";
    public static final String DISPLAY_NAME_CONSTRAINT = "displayNameConstraint";
    public static final String QUOTED_DISPLAY_NAME_PROPERTY = "quotedDisplayName";
    public static final String DEFAULT_NAMESPACE = "system-root";
    public static final Label REMOTE_DATABASE_LABEL = Label.label((String)"Remote");
    public static final String REMOTE_DATABASE = REMOTE_DATABASE_LABEL.name();
    public static final String REMOTE_DATABASE_LABEL_DESCRIPTION = "Remote Database alias";
    public static final String URL_PROPERTY = "url";
    public static final String REMOTE_USERNAME_PROPERTY = "username";
    public static final String REMOTE_PASSWORD_PROPERTY = "password";
    public static final String OIDC_CREDENTIAL_FORWARDING = "oidc_credential_forwarding";
    public static final String IV_PROPERTY = "iv";
    public static final Label DRIVER_SETTINGS_LABEL = Label.label((String)"DriverSettings");
    public static final String DRIVER_SETTINGS = DRIVER_SETTINGS_LABEL.name();
    public static final String SSL_ENFORCED = "ssl_enforced";
    public static final String CONNECTION_TIMEOUT = "connection_timeout";
    public static final String CONNECTION_MAX_LIFETIME = "connection_max_lifetime";
    public static final String CONNECTION_POOL_ACQUISITION_TIMEOUT = "connection_pool_acquisition_timeout";
    public static final String CONNECTION_POOL_IDLE_TEST = "connection_pool_idle_test";
    public static final String CONNECTION_POOL_MAX_SIZE = "connection_pool_max_size";
    public static final String LOGGING_LEVEL = "logging_level";
    public static final RelationshipType CONNECTS_WITH_RELATIONSHIP = RelationshipType.withName((String)"CONNECTS_WITH");
    public static final String CONNECTS_WITH = CONNECTS_WITH_RELATIONSHIP.name();
    public static final RelationshipType PROPERTIES_RELATIONSHIP = RelationshipType.withName((String)"PROPERTIES");
    public static final String PROPERTIES = PROPERTIES_RELATIONSHIP.name();
    public static final Label ALIAS_PROPERTIES_LABEL = Label.label((String)"AliasProperties");
    public static final String ALIAS_PROPERTIES = ALIAS_PROPERTIES_LABEL.name();
    public static final Label INSTANCE_LABEL = Label.label((String)"Instance");
    public static final Label REMOVED_INSTANCE_LABEL = Label.label((String)"RemovedInstance");
    public static final String INSTANCE_UUID_PROPERTY = "uuid";
    public static final String INSTANCE_NAME_PROPERTY = "name";
    public static final String INSTANCE_STATUS_PROPERTY = "status";
    public static final String INSTANCE_DISCOVERED_AT_PROPERTY = "discovered_at";
    public static final String INSTANCE_ALLOWED_DATABASES_PROPERTY = "allowedDatabases";
    public static final String INSTANCE_DENIED_DATABASES_PROPERTY = "deniedDatabases";
    public static final String INSTANCE_MODE_CONSTRAINT_PROPERTY = "modeConstraint";
    public static final String INSTANCE_TAGS_PROPERTY = "tags";
    public static final String INSTANCE_AUTO_SYSTEM_DATABASE_MODE_PROPERTY = "auto_system_database_mode";
    public static final String REMOVED_INSTANCE_REMOVED_AT_PROPERTY = "removed_at";
    public static final RelationshipType HOSTED_ON_RELATIONSHIP = RelationshipType.withName((String)"HOSTED_ON");
    public static final RelationshipType WAS_HOSTED_ON_RELATIONSHIP = RelationshipType.withName((String)"WAS_HOSTED_ON");
    public static final String HOSTED_ON_INSTALLED_AT_PROPERTY = "installed_at";
    public static final String HOSTED_ON_INITIAL_PROPERTY = "bootstrapper";
    public static final String HOSTED_ON_RAFT_MEMBER_ID_PROPERTY = "raftMemberId";
    public static final String HOSTED_ON_MODE_PROPERTY = "mode";
    public static final String WAS_HOSTED_ON_REMOVED_AT_PROPERTY = "removed_at";
    public static final String WAS_HOSTED_ON_INITIAL_PROPERTY = "was_bootstrapper";
    public static final Label TOPOLOGY_GRAPH_CONFIG_LABEL = Label.label((String)"TopologyGraphSettings");
    @Deprecated
    public static final String TOPOLOGY_GRAPH_CONFIG_ALLOCATOR_PROPERTY = "allocator";
    public static final String TOPOLOGY_GRAPH_CONFIG_DEFAULT_NUMBER_OF_PRIMARIES_PROPERTY = "default_number_of_primaries";
    public static final String TOPOLOGY_GRAPH_CONFIG_DEFAULT_NUMBER_OF_SECONDARIES_PROPERTY = "default_number_of_secondaries";
    public static final String TOPOLOGY_GRAPH_CONFIG_DEFAULT_DATABASE_PROPERTY = "default_database";
    public static final String TOPOLOGY_GRAPH_CONFIG_DEFAULT_DATABASE_CREATE_ATTEMPTED_FLAG = "default_database_created";
    public static final String TOPOLOGY_GRAPH_CONFIG_INITIAL_INSTANCES_ENABLED_FLAG = "initial_instances_enabled";
    public static final String TOPOLOGY_GRAPH_CONFIG_AUTO_ENABLE_FREE_SERVERS_FLAG = "auto_enable_free_servers";
    public static final String TOPOLOGY_GRAPH_CONFIG_CREATE_DEFAULT_DATABASE = "create_default_database";
    public static final String TOPOLOGY_GRAPH_CONFIG_DEFAULT_ALLOCATION_HINT_PREFIX = "default_allocation_hint_";
    public static final Label SUPPORTED_COMPONENT_VERSIONS_LABEL = Label.label((String)"SupportedVersions");
    public static final String SUPPORTED_COMPONENT_VERSIONS_UUID_PROPERTY = "__uuid";
    public static final RelationshipType LATEST_SUPPORTED_COMPONENT_VERSIONS_RELATIONSHIP = RelationshipType.withName((String)"LATEST_SUPPORTED_VERSIONS");
    public static final String HAS_PROPERTY_SHARD = "HAS_PROPERTY_SHARD";
    public static final RelationshipType HAS_PROPERTY_SHARD_RELATIONSHIP = RelationshipType.withName((String)"HAS_PROPERTY_SHARD");
    public static final String HAS_GRAPH_SHARD = "HAS_GRAPH_SHARD";
    public static final RelationshipType HAS_GRAPH_SHARD_RELATIONSHIP = RelationshipType.withName((String)"HAS_GRAPH_SHARD");
    public static final String HAS_PROPERTY_SHARD_INDEX_PROPERTY = "index";
    public static final Label ALLOCATION_HINTS_LABEL = Label.label((String)"AllocationHints");
    public static final RelationshipType HAS_ALLOCATION_HINTS_RELATIONSHIP = RelationshipType.withName((String)"HAS_ALLOCATION_HINTS");
    public static final Label MIRROR_LABEL = Label.label((String)"Mirror");
    public static final RelationshipType IS_MIRROR_OF_RELATIONSHIP = RelationshipType.withName((String)"IS_MIRROR_OF");
    public static final String IS_MIRROR_OF_INSTALLED_AT_PROPERTY = "installed_at";

    public Set<DatabaseReference> getAllDatabaseReferences();

    public Set<DatabaseReferenceImpl.Composite> getAllCompositeDatabaseReferences();

    public Optional<NamedDatabaseId> getDatabaseIdByAlias(String var1);

    public Optional<NamedDatabaseId> getDatabaseIdByUUID(UUID var1);

    public Optional<NamedDatabaseId> getDatabaseIdByUUID(UUID var1, boolean var2);

    public Optional<DatabaseReference> getDatabaseRefByAlias(NormalizedCatalogEntry var1);

    default public Optional<DatabaseReference> getDatabaseRefByAlias(String alias) {
        return this.getDatabaseRefByAlias(new NormalizedCatalogEntry(alias)).or(() -> {
            String[] parts = alias.split("\\.");
            for (int i = 1; i < parts.length; ++i) {
                String name;
                String namespace = Stream.of(parts).limit(i).collect(Collectors.joining("."));
                Optional<DatabaseReference> result = this.getDatabaseRefByAlias(new NormalizedCatalogEntry(namespace, name = Stream.of(parts).skip(i).collect(Collectors.joining("."))));
                if (!result.isPresent()) continue;
                return result;
            }
            return Optional.empty();
        });
    }

    public Optional<DatabaseReference> getDatabaseRefByDisplayName(NormalizedDatabaseName var1);

    public Optional<DriverSettings> getDriverSettings(String var1, String var2);

    public Optional<Map<String, Object>> getAliasProperties(String var1, String var2);

    public Optional<CypherVersion> getRemoteAliasLanguageVersion(String var1);

    public Optional<ExternalDatabaseCredentials> getExternalDatabaseCredentials(DatabaseReferenceImpl.External var1);

    public static enum InstanceStatus {
        ENABLED,
        DEALLOCATING,
        CORDONED;


        public static InstanceStatus getInstanceStatus(String value) {
            if (value.equals("active")) {
                return ENABLED;
            }
            if (value.equals("deallocating")) {
                return DEALLOCATING;
            }
            return InstanceStatus.valueOf(value);
        }
    }

    public static enum DatabaseAccess {
        READ_ONLY(0, "read-only"),
        READ_WRITE(1, "read-write");

        private final String stringRepr;
        private final byte code;

        private DatabaseAccess(int code, String stringRepr) {
            this.code = (byte)code;
            this.stringRepr = stringRepr;
        }

        public static DatabaseAccess forCode(byte code) {
            return Stream.of(DatabaseAccess.values()).filter(v -> v.getCode() == code).findFirst().orElseThrow(() -> new IllegalStateException("Can't find database access with code " + code));
        }

        public String getStringRepr() {
            return this.stringRepr;
        }

        public byte getCode() {
            return this.code;
        }

        public static DatabaseAccess toDatabaseAccess(boolean readOnly) {
            if (DatabaseAccess.values().length != 2) {
                throw new IllegalStateException("Can't identify database access");
            }
            return readOnly ? READ_ONLY : READ_WRITE;
        }

        public static DatabaseAccess create(Object value) {
            Objects.requireNonNull(value);
            String access = value.toString().toUpperCase(Locale.ROOT);
            try {
                return DatabaseAccess.valueOf(access);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unsupported database access: " + access, ex);
            }
        }
    }

    public static enum DatabaseStatus {
        ONLINE("online"),
        OFFLINE("offline");

        private final String statusName;

        private DatabaseStatus(String statusName) {
            this.statusName = statusName;
        }

        public String statusName() {
            return this.statusName;
        }

        public static DatabaseStatus fromName(String statusName) {
            return Arrays.stream(DatabaseStatus.values()).filter(databaseStatus -> databaseStatus.statusName().equals(statusName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No such status '%s'", statusName)));
        }
    }

    public static enum HostedOnMode {
        RAFT(1, "raft"),
        REPLICA(2, "replica"),
        SINGLE(0, "single"),
        VIRTUAL(3, "virtual");

        private final String modeName;
        private final byte code;

        private HostedOnMode(int code, String modeName) {
            this.code = (byte)code;
            this.modeName = modeName;
        }

        public String modeName() {
            return this.modeName;
        }

        public byte code() {
            return this.code;
        }

        public static HostedOnMode from(String modeName) {
            Objects.requireNonNull(modeName);
            for (HostedOnMode mode : HostedOnMode.values()) {
                if (!modeName.equals(mode.modeName)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Enum value not found for requested modeName: " + modeName);
        }

        public static HostedOnMode forCode(byte code) {
            return Arrays.stream(HostedOnMode.values()).filter(value -> value.code == code).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid hosted on mode: " + code));
        }
    }
}

