/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class AlreadyIndexedException
extends SchemaKernelException {
    private static final String INDEX_CONTEXT_FORMAT = "There already exists an index %s.";
    private static final String CONSTRAINT_CONTEXT_FORMAT = "There already exists an index %s. A constraint cannot be created until the index has been dropped.";

    private AlreadyIndexedException(String message, ErrorGqlStatusObject gqlStatusObject) {
        super(gqlStatusObject, (Status)Status.Schema.IndexAlreadyExists, message);
    }

    public static AlreadyIndexedException cannotCreateIndex(SchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        String userDescription = descriptor.userDescription(tokenNameLookup);
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N70).withParam(GqlParams.StringParam.idxDescrOrName, userDescription).build();
        String message = AlreadyIndexedException.messageWithLabelAndPropertyName((TokenNameLookup)tokenNameLookup, (String)INDEX_CONTEXT_FORMAT, (SchemaDescriptor)descriptor);
        return new AlreadyIndexedException(message, gql);
    }

    public static AlreadyIndexedException cannotCreateConstraint(SchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        String userDescription = descriptor.userDescription(tokenNameLookup);
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N73).withParam(GqlParams.StringParam.idxDescrOrName, userDescription).build();
        String message = AlreadyIndexedException.messageWithLabelAndPropertyName((TokenNameLookup)tokenNameLookup, (String)CONSTRAINT_CONTEXT_FORMAT, (SchemaDescriptor)descriptor);
        return new AlreadyIndexedException(message, gql);
    }
}

