/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class IndexBelongsToConstraintException
extends SchemaKernelException {
    private static final String MESSAGE_SCHEMA = "Index belongs to constraint: %s";
    private static final String MESSAGE_NAME = "Index belongs to constraint: `%s`";

    private IndexBelongsToConstraintException(String message, ErrorGqlStatusObject errorGqlStatusObject) {
        super(errorGqlStatusObject, (Status)Status.Schema.ForbiddenOnConstraintIndex, message);
    }

    public static IndexBelongsToConstraintException indexBelongsToConstraint(SchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        String userDescription = descriptor.userDescription(tokenNameLookup);
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NBC).withParam(GqlParams.StringParam.constrDescrOrName, userDescription).build();
        String message = String.format(MESSAGE_SCHEMA, userDescription);
        return new IndexBelongsToConstraintException(message, gql);
    }

    public static IndexBelongsToConstraintException indexBelongsToConstraint(String constraintName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NBC).withParam(GqlParams.StringParam.constrDescrOrName, constraintName).build();
        String message = String.format(MESSAGE_NAME, constraintName);
        return new IndexBelongsToConstraintException(message, gql);
    }
}

