/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public abstract class DatabaseReferenceImpl
implements DatabaseReference {
    private static final Comparator<DatabaseReference> referenceComparator = Comparator.comparing(a -> a.alias().name(), String::compareToIgnoreCase);
    private static final Comparator<DatabaseReference> nullSafeReferenceComparator = Comparator.nullsLast(referenceComparator);
    private static final NormalizedDatabaseName defaultNamespace = new NormalizedDatabaseName("system-root");

    public int compareTo(DatabaseReference that) {
        return nullSafeReferenceComparator.compare(this, that);
    }

    public String toPrettyString() {
        String namespace = this.namespace().map(ns -> ns.name() + ".").orElse("");
        String name = this.alias().name();
        return namespace + name;
    }

    public NormalizedDatabaseName fullName() {
        String namespace = this.namespace().map(ns -> ns.name() + ".").orElse("");
        String name = this.alias().name();
        return new NormalizedDatabaseName(namespace + name);
    }

    public boolean isComposite() {
        return false;
    }

    public static final class Mirror
    extends Internal {
        private final String upstream;

        public Mirror(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, String upstream) {
            super(alias, namedDatabaseId, true);
            this.upstream = upstream;
        }

        public String upstream() {
            return this.upstream;
        }

        @Override
        public String toString() {
            return "Mirror{alias=" + String.valueOf(this.alias) + ", namespace=" + String.valueOf(this.namespace) + ", namedDatabaseId=" + String.valueOf(this.namedDatabaseId) + ", primary=" + this.primary + ", upstream=" + this.upstream + "}";
        }
    }

    public static final class PropertyShard
    extends Internal {
        public static int MAX_NUMBER_OF_SHARDS = 1000;
        private final String spdName;
        private final int index;
        private static final Pattern propertyShardPattern = Pattern.compile("(.)+(-p)([0-9]{3})");

        public PropertyShard(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, String spdName, int index) {
            super(alias, namedDatabaseId, true);
            this.spdName = spdName;
            this.index = index;
        }

        public PropertyShard(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, boolean primary, String owningDatabaseName, int index) {
            super(alias, namedDatabaseId, primary);
            this.spdName = owningDatabaseName;
            this.index = index;
        }

        public static String propertyShardName(String databaseName, int index) {
            return String.format("%s-p%03d", databaseName, index);
        }

        public static boolean isPropertyShardName(String databaseName) {
            return propertyShardPattern.matcher(databaseName).matches();
        }

        public static boolean isPropertyShard(String propertyShardName, String databaseName) {
            Pattern pattern = Pattern.compile("(%s-p)([0-9]{3})".formatted(databaseName));
            return pattern.matcher(propertyShardName).matches();
        }

        public static int propertyShardIndex(String databaseName) {
            Matcher matcher = propertyShardPattern.matcher(databaseName);
            return matcher.matches() ? Integer.parseInt(matcher.group(3)) : -1;
        }

        @Override
        public boolean isShard() {
            return true;
        }

        @Override
        public String owningDatabaseName() {
            return this.spdName;
        }

        public int index() {
            return this.index;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof PropertyShard) {
                PropertyShard other = (PropertyShard)o;
                return this.alias.equals((Object)other.alias) && Objects.equals(this.namespace, other.namespace) && this.namedDatabaseId.equals((Object)other.namedDatabaseId) && this.primary == other.primary && this.spdName.equals(other.spdName);
            }
            return false;
        }

        @Override
        public String toString() {
            return "PropertyShard{alias=" + String.valueOf(this.alias) + ", namespace=" + String.valueOf(this.namespace) + ", namedDatabaseId=" + String.valueOf(this.namedDatabaseId) + ", primary=" + this.primary + ", owningDatabaseName=" + this.spdName + ", index=" + this.index + "}";
        }
    }

    public static final class GraphShard
    extends Internal {
        public static String GRAPH_SHARD_NAME_POSTFIX = "-g000";
        private static final Pattern graphShardPattern = Pattern.compile("(.)+(-g)([0-9]{3})");
        private final String owningDatabaseName;
        private final Map<Integer, PropertyShard> propertyShards;

        public static String graphShardName(String databaseName) {
            return databaseName + GRAPH_SHARD_NAME_POSTFIX;
        }

        public static boolean isGraphShardName(String databaseName) {
            return graphShardPattern.matcher(databaseName).matches();
        }

        public GraphShard(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, String owningDatabaseName, Map<Integer, PropertyShard> propertyShards) {
            super(alias, namedDatabaseId, true);
            this.propertyShards = propertyShards;
            this.owningDatabaseName = owningDatabaseName;
        }

        public GraphShard(NormalizedDatabaseName alias, NormalizedDatabaseName namespace, NamedDatabaseId namedDatabaseId, String owningDatabaseName, Map<Integer, PropertyShard> propertyShards, boolean isPrimary) {
            super(alias, namespace, namedDatabaseId, isPrimary);
            this.propertyShards = propertyShards;
            this.owningDatabaseName = owningDatabaseName;
        }

        public Map<Integer, PropertyShard> propertyShards() {
            return this.propertyShards;
        }

        @Override
        public String owningDatabaseName() {
            return this.owningDatabaseName;
        }

        @Override
        public boolean isShard() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GraphShard spd = (GraphShard)o;
            return Objects.equals(this.propertyShards, spd.propertyShards()) && this.owningDatabaseName.equals(spd.owningDatabaseName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.propertyShards);
        }

        @Override
        public String toString() {
            return "GraphShard{alias=" + String.valueOf(this.alias) + ", namespace=" + String.valueOf(this.namespace) + ", namedDatabaseId=" + String.valueOf(this.namedDatabaseId) + ", primary=" + this.primary + ", propertyShards=" + String.valueOf(this.propertyShards) + "}";
        }
    }

    public static final class VirtualSPD
    extends Internal {
        private final DatabaseReference graphShard;

        public VirtualSPD(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, DatabaseReference graphShard, boolean primary) {
            super(alias, namedDatabaseId, primary);
            this.graphShard = graphShard;
        }

        public VirtualSPD(NormalizedDatabaseName alias, NormalizedDatabaseName namespace, NamedDatabaseId namedDatabaseId, DatabaseReference graphShard, boolean primary) {
            super(alias, namespace, namedDatabaseId, primary);
            this.graphShard = graphShard;
        }

        public static String spdName(String shardDatabaseName) {
            return shardDatabaseName.substring(0, shardDatabaseName.lastIndexOf(45));
        }

        public GraphShard graphShard() {
            return (GraphShard)this.graphShard;
        }

        @Override
        public NamedDatabaseId databaseId() {
            return this.graphShard.namedDatabaseId();
        }

        @Override
        public UUID id() {
            return this.graphShard.id();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VirtualSPD spd = (VirtualSPD)o;
            return Objects.equals(this.graphShard, spd.graphShard());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.graphShard);
        }

        @Override
        public String toString() {
            return "SPD{alias=" + String.valueOf(this.alias) + ", namespace=" + String.valueOf(this.namespace) + ", namedDatabaseId=" + String.valueOf(this.namedDatabaseId) + ", primary=" + this.primary + ", graphShard=" + String.valueOf(this.graphShard) + "}";
        }
    }

    public static final class Composite
    extends Internal {
        private final List<DatabaseReference> constituents;

        public Composite(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, Set<DatabaseReference> constituents) {
            super(alias, namedDatabaseId, true);
            this.constituents = constituents.stream().sorted().toList();
        }

        @Override
        public Optional<NormalizedDatabaseName> namespace() {
            return Optional.empty();
        }

        public List<DatabaseReference> constituents() {
            return this.constituents;
        }

        public Optional<DatabaseReference> getConstituentByName(String databaseName) {
            for (DatabaseReference constituent : this.constituents) {
                if (!constituent.fullName().equals((Object)new NormalizedDatabaseName(databaseName))) continue;
                return Optional.of(constituent);
            }
            return Optional.empty();
        }

        public Optional<DatabaseReference> getConstituentById(UUID databaseId) {
            for (DatabaseReference constituent : this.constituents) {
                if (!constituent.id().equals(databaseId)) continue;
                return Optional.of(constituent);
            }
            return Optional.empty();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Composite composite = (Composite)o;
            return Objects.equals(this.constituents, composite.constituents);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.constituents);
        }

        @Override
        public String toString() {
            return "Composite{alias=" + String.valueOf(this.alias) + ", namespace=" + String.valueOf(this.namespace) + ", namedDatabaseId=" + String.valueOf(this.namedDatabaseId) + ", primary=" + this.primary + ", constituents=" + String.valueOf(this.constituents) + "}";
        }

        @Override
        public boolean isComposite() {
            return true;
        }
    }

    public static sealed class Internal
    extends DatabaseReferenceImpl
    permits Composite, VirtualSPD, GraphShard, PropertyShard, Mirror {
        protected final NormalizedDatabaseName alias;
        protected final NormalizedDatabaseName namespace;
        protected final NamedDatabaseId namedDatabaseId;
        protected final boolean primary;

        public Internal(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, boolean primary) {
            this(alias, null, namedDatabaseId, primary);
        }

        public Internal(NormalizedDatabaseName alias, NormalizedDatabaseName namespace, NamedDatabaseId namedDatabaseId, boolean primary) {
            this.alias = alias;
            this.namespace = Objects.equals(namespace, defaultNamespace) ? null : namespace;
            this.namedDatabaseId = namedDatabaseId;
            this.primary = primary;
        }

        public NamedDatabaseId databaseId() {
            return this.namedDatabaseId;
        }

        public NormalizedDatabaseName alias() {
            return this.alias;
        }

        public Optional<NormalizedDatabaseName> namespace() {
            return Optional.ofNullable(this.namespace);
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public UUID id() {
            return this.namedDatabaseId.databaseId().uuid();
        }

        public NamedDatabaseId namedDatabaseId() {
            return this.namedDatabaseId;
        }

        public NormalizedCatalogEntry catalogEntry() {
            if (this.namespace != null) {
                return new NormalizedCatalogEntry(this.namespace.name(), this.alias.name());
            }
            return new NormalizedCatalogEntry(this.alias.name());
        }

        public String owningDatabaseName() {
            return this.namedDatabaseId.name();
        }

        public boolean isShard() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Internal internal = (Internal)o;
            return this.primary == internal.primary && Objects.equals(this.alias, internal.alias) && Objects.equals(this.namespace, internal.namespace) && Objects.equals(this.namedDatabaseId, internal.namedDatabaseId);
        }

        public int hashCode() {
            return Objects.hash(this.alias, this.namespace, this.namedDatabaseId, this.primary);
        }

        public String toString() {
            return "Internal{alias=" + String.valueOf(this.alias) + ", namespace=" + String.valueOf(this.namespace) + ", namedDatabaseId=" + String.valueOf(this.namedDatabaseId) + ", primary=" + this.primary + "}";
        }

        public PropertyShard asShard(String ownerDatabase, int index) {
            return new PropertyShard(this.alias, this.namedDatabaseId, this.primary, ownerDatabase, index);
        }

        public Mirror asMirror(String upstreamDatabase) {
            return new Mirror(this.alias, this.namedDatabaseId, upstreamDatabase);
        }
    }

    public static final class External
    extends DatabaseReferenceImpl {
        private final NormalizedDatabaseName targetAlias;
        private final NormalizedDatabaseName alias;
        private final NormalizedDatabaseName namespace;
        private final RemoteUri externalUri;
        private final UUID uuid;
        private final boolean forwardOidcCredentials;

        public External(NormalizedDatabaseName targetAlias, NormalizedDatabaseName alias, RemoteUri externalUri, UUID uuid, boolean forwardOidcCredentials) {
            this(targetAlias, alias, null, externalUri, uuid, forwardOidcCredentials);
        }

        public External(NormalizedDatabaseName targetAlias, NormalizedDatabaseName alias, NormalizedDatabaseName namespace, RemoteUri externalUri, UUID uuid, boolean forwardOidcCredentials) {
            this.targetAlias = targetAlias;
            this.alias = alias;
            this.namespace = Objects.equals(namespace, defaultNamespace) ? null : namespace;
            this.externalUri = externalUri;
            this.uuid = uuid;
            this.forwardOidcCredentials = forwardOidcCredentials;
        }

        public NormalizedDatabaseName alias() {
            return this.alias;
        }

        public Optional<NormalizedDatabaseName> namespace() {
            return Optional.ofNullable(this.namespace);
        }

        public boolean isPrimary() {
            return false;
        }

        public RemoteUri externalUri() {
            return this.externalUri;
        }

        public NormalizedDatabaseName targetAlias() {
            return this.targetAlias;
        }

        public boolean forwardOidcCredentials() {
            return this.forwardOidcCredentials;
        }

        public UUID id() {
            return this.uuid;
        }

        public NamedDatabaseId namedDatabaseId() {
            return DatabaseIdFactory.from((String)this.name(), (UUID)this.uuid);
        }

        public NormalizedCatalogEntry catalogEntry() {
            if (this.namespace != null) {
                return new NormalizedCatalogEntry(this.namespace.name(), this.alias.name());
            }
            return new NormalizedCatalogEntry(this.alias.name());
        }

        public String owningDatabaseName() {
            return this.fullName().name();
        }

        public boolean isShard() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            External external = (External)o;
            return Objects.equals(this.targetAlias, external.targetAlias) && Objects.equals(this.alias, external.alias) && Objects.equals(this.namespace, external.namespace) && Objects.equals(this.externalUri, external.externalUri) && Objects.equals(this.uuid, external.uuid) && Objects.equals(this.forwardOidcCredentials, external.forwardOidcCredentials);
        }

        public int hashCode() {
            return Objects.hash(this.targetAlias, this.alias, this.namespace, this.externalUri, this.uuid, this.forwardOidcCredentials);
        }

        public String toString() {
            return "External{alias=" + String.valueOf(this.alias) + ", namespace=" + String.valueOf(this.namespace) + ", remoteUri=" + String.valueOf(this.externalUri) + ", remoteName=" + String.valueOf(this.targetAlias) + ", uuid=" + String.valueOf(this.uuid) + ", forwardOidcCredentials=" + this.forwardOidcCredentials + "}";
        }
    }
}

