/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;

public class DbmsRuntimeFallbackKernelVersionProvider
implements KernelVersionProvider,
LogFormatVersionProvider {
    private final KernelVersionProvider kernelVersionProvider;
    private final LogFormatVersionProvider logFormatVersionProvider;

    public DbmsRuntimeFallbackKernelVersionProvider(Dependencies dependencies, String databaseName, Config config) {
        if (dependencies.containsDependency(KernelVersionProvider.class)) {
            this.kernelVersionProvider = (KernelVersionProvider)dependencies.resolveDependency(KernelVersionProvider.class);
        } else if ("system".equals(databaseName) || !dependencies.containsDependency(DbmsRuntimeVersionProvider.class)) {
            this.kernelVersionProvider = DbmsRuntimeVersion.getLatestVersion(config);
        } else {
            DbmsRuntimeVersionProvider dbmsRuntimeVersionProvider = (DbmsRuntimeVersionProvider)dependencies.resolveDependency(DbmsRuntimeVersionProvider.class);
            this.kernelVersionProvider = () -> dbmsRuntimeVersionProvider.getVersion().kernelVersion();
        }
        this.logFormatVersionProvider = dependencies.resolveOptionalDependency(LogFormatVersionProvider.class).orElseGet(() -> () -> LogFormat.fromConfigAndKernelVersion((Config)config, (KernelVersion)this.kernelVersionProvider.kernelVersion()));
    }

    public KernelVersion kernelVersion() {
        return this.kernelVersionProvider.kernelVersion();
    }

    public LogFormat getCurrentLogFormat() {
        return this.logFormatVersionProvider.getCurrentLogFormat();
    }
}

