/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.chunk;

import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.TransactionClockContext;
import org.neo4j.kernel.impl.api.chunk.ChunkedTransactionSink;
import org.neo4j.kernel.impl.api.commit.TransactionCommitter;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.coreapi.DefaultTransactionExceptionMapper;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.kernel.internal.event.TransactionEventListeners;
import org.neo4j.lock.LockTracer;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.ExceptionHandlerService;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public final class ChunkSink
implements ChunkedTransactionSink {
    private final TransactionEventListeners eventListeners;
    private final TransactionClockContext clocks;
    private final long chunkSize;
    private final TransactionCommitter committer;
    private CursorContext cursorContext;
    private LeaseClient leaseClient;
    private long startTimeMillis;
    private long lastTransactionIdWhenStarted;
    private Supplier<LockTracer> lockTracerSupplier;
    private Supplier<TransactionApplicationMode> applicationModeSupplier;
    private final Log log;
    private final ExceptionHandlerService exceptionHandlerService;

    public ChunkSink(TransactionCommitter committer, TransactionEventListeners eventListeners, TransactionClockContext clocks, Config config, LogProvider logProvider, ExceptionHandlerService exceptionHandlerService) {
        this.committer = committer;
        this.eventListeners = eventListeners;
        this.clocks = clocks;
        this.chunkSize = (Long)config.get(GraphDatabaseInternalSettings.multi_version_transaction_chunk_size);
        this.log = logProvider.getLog(this.getClass());
        this.exceptionHandlerService = exceptionHandlerService;
    }

    @Override
    public void write(TxState txState, TransactionEvent transactionEvent) {
        MemoryTracker memoryTracker = txState.memoryTracker();
        if (memoryTracker.estimatedHeapMemory() > this.chunkSize) {
            txState.markAsMultiChunk();
            try (TransactionWriteEvent chunkWriteEvent = transactionEvent.beginChunkWriteEvent();){
                this.eventListeners.beforeCommit(txState, false);
                this.committer.commit(chunkWriteEvent, this.leaseClient, this.cursorContext, memoryTracker, KernelTransaction.NO_MONITOR, this.lockTracerSupplier.get(), this.clocks.systemClock().millis(), this.startTimeMillis, this.lastTransactionIdWhenStarted, false, this.applicationModeSupplier.get());
                txState.reset();
            }
            catch (Exception e) {
                throw DefaultTransactionExceptionMapper.INSTANCE.mapException(e, this.log, this.exceptionHandlerService);
            }
        }
    }

    @Override
    public void initialize(LeaseClient leaseClient, CursorContext cursorContext, Supplier<LockTracer> lockTracerSupplier, long startTimeMillis, long lastTransactionIdWhenStarted, Supplier<TransactionApplicationMode> applicationModeSupplier) {
        this.cursorContext = cursorContext;
        this.leaseClient = leaseClient;
        this.lockTracerSupplier = lockTracerSupplier;
        this.startTimeMillis = startTimeMillis;
        this.lastTransactionIdWhenStarted = lastTransactionIdWhenStarted;
        this.applicationModeSupplier = applicationModeSupplier;
    }
}

