/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.TokenIndexIdLayout;

public class DefaultTokenIndexIdLayout
implements TokenIndexIdLayout {
    private static final int RANGE_MASK = 63;
    private static final int RANGE_SHIFT = 31 - Integer.numberOfLeadingZeros(64);

    @Override
    public int idWithinRange(long entityId) {
        return (int)entityId & 0x3F;
    }

    @Override
    public long rangeOf(long entityId) {
        return entityId >> RANGE_SHIFT;
    }

    @Override
    public long firstIdOfRange(long idRange) {
        return idRange << RANGE_SHIFT;
    }

    @Override
    public long roundUp(long sizeHint) {
        return (sizeHint + 64L - 1L) / 64L * 64L;
    }
}

