/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesReader;
import org.neo4j.kernel.impl.index.schema.NativeIndex;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobHandles;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public abstract class NativeIndexAccessor<KEY extends NativeIndexKey<KEY>>
extends NativeIndex<KEY>
implements IndexAccessor {
    private final NativeIndexUpdater<KEY> singleUpdater;
    private final NativeIndexHeaderWriter headerWriter;
    protected final LogProvider logProvider;
    protected final TokenNameLookup tokenNameLookup;

    NativeIndexAccessor(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<KEY> layout, IndexDescriptor descriptor, ImmutableSet<OpenOption> openOptions, boolean readOnly, LogProvider logProvider, TokenNameLookup tokenNameLookup) {
        super(databaseIndexContext, layout, indexFiles, descriptor, openOptions, readOnly);
        this.tokenNameLookup = tokenNameLookup;
        this.singleUpdater = new NativeIndexUpdater<NativeIndexKey>((NativeIndexKey)((Object)layout.newKey()), this.indexUpdateIgnoreStrategy(), new ThrowingConflictDetector(true, descriptor.schema(), tokenNameLookup));
        this.headerWriter = new NativeIndexHeaderWriter(1);
        this.logProvider = logProvider;
    }

    public void drop() {
        this.tree.setDeleteOnClose(true);
        this.closeTree();
        this.indexFiles.clear();
    }

    public NativeIndexUpdater<KEY> newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
        this.assertOpen();
        this.assertWritable();
        try {
            if (parallel) {
                return new NativeIndexUpdater<NativeIndexKey>((NativeIndexKey)((Object)this.layout.newKey()), this.indexUpdateIgnoreStrategy(), new ThrowingConflictDetector(!this.descriptor.isUnique() || mode.includeEntityIdInUniqueness(), this.descriptor.schema(), this.tokenNameLookup)).initialize((Writer<NativeIndexKey, NullValue>)this.tree.writer(cursorContext));
            }
            assert (mode.includeEntityIdInUniqueness());
            return this.singleUpdater.initialize(this.tree.writer(1, cursorContext));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertFrom(IndexAccessor other, LongToLongFunction entityIdConverter, boolean valueUniqueness, final IndexEntryConflictHandler conflictHandler, LongPredicate entityFilter, int threads, JobScheduler jobScheduler, ProgressListener progress) throws IndexEntryConflictException {
        NativeIndexAccessor o = (NativeIndexAccessor)other;
        IndexEntriesReader[] readers = o.newAllEntriesValueReader(threads, CursorContext.NULL_CONTEXT);
        try {
            ArrayList<JobHandle> handles = new ArrayList<JobHandle>();
            int updaterFlags = readers.length == 1 ? 1 : 0;
            for (IndexEntriesReader reader : readers) {
                handles.add(jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(Subject.AUTH_DISABLED, this.databaseName, "insertFrom"), () -> {
                    ConflictDetectingValueMerger merger = new ConflictDetectingValueMerger<KEY, Value[]>(!valueUniqueness){

                        @Override
                        void doReportConflict(long existingNodeId, long addedNodeId, Value[] toReport) throws IndexEntryConflictException {
                            switch (conflictHandler.indexEntryConflict(existingNodeId, addedNodeId, toReport)) {
                                case THROW: {
                                    throw IndexEntryConflictException.indexEntryConflict((SchemaDescriptor)NativeIndexAccessor.this.descriptor.schema(), (long)existingNodeId, (long)addedNodeId, (TokenNameLookup)NativeIndexAccessor.this.tokenNameLookup, (Value[])toReport);
                                }
                            }
                        }
                    };
                    try (NativeIndexUpdater<NativeIndexKey> updater = new NativeIndexUpdater<NativeIndexKey>((NativeIndexKey)((Object)((Object)this.layout.newKey())), this.indexUpdateIgnoreStrategy(), merger).initialize((Writer<NativeIndexKey, NullValue>)this.tree.writer(updaterFlags, CursorContext.NULL_CONTEXT));
                         ProgressListener localProgress = progress.threadLocalReporter();){
                        while (reader.hasNext()) {
                            long entityId = reader.next();
                            if (entityFilter == null || entityFilter.test(entityId)) {
                                if (entityIdConverter != null) {
                                    entityId = entityIdConverter.applyAsLong(entityId);
                                }
                                updater.process((IndexEntryUpdate)ValueIndexEntryUpdate.add((long)entityId, (IndexDescriptor)this.descriptor, (Value[])reader.values()));
                            }
                            localProgress.add(1L);
                        }
                    }
                    return null;
                }));
            }
            JobHandles.getAllResults(handles, IndexEntryConflictException.class, RuntimeException::new);
        }
        finally {
            IOUtils.closeAllUnchecked((AutoCloseable[])readers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(IndexAccessor other, boolean valueUniqueness, IndexEntryConflictHandler conflictHandler, int threads, JobScheduler jobScheduler) {
        NativeIndexAccessor o = (NativeIndexAccessor)other;
        IndexEntriesReader[] readers = o.newAllEntriesValueReader(threads, CursorContext.NULL_CONTEXT);
        try {
            ArrayList<JobHandle> handles = new ArrayList<JobHandle>();
            for (IndexEntriesReader fromReader : readers) {
                handles.add(jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(Subject.AUTH_DISABLED, this.databaseName, "insertFrom"), () -> {
                    try (ValueIndexReader reader = this.newValueReader(IndexUsageTracking.NO_USAGE_TRACKING);){
                        int[] propertyKeyIds = this.descriptor.schema().getPropertyIds();
                        while (fromReader.hasNext()) {
                            long entityId = fromReader.next();
                            Value[] values = fromReader.values();
                            PropertyIndexQuery[] queries = new PropertyIndexQuery[values.length];
                            for (int i = 0; i < queries.length; ++i) {
                                queries[i] = PropertyIndexQuery.exact((int)propertyKeyIds[i], (Object)values[i]);
                            }
                            try (NodeValueIterator client = new NodeValueIterator();){
                                reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, CursorContext.NULL_CONTEXT, IndexQueryConstraints.unconstrained(), queries);
                                if (!client.hasNext()) continue;
                                long existingEntityId = client.next();
                                conflictHandler.indexEntryConflict(existingEntityId, entityId, values);
                            }
                        }
                    }
                    return null;
                }));
            }
            JobHandles.getAllResults(handles, RuntimeException.class, RuntimeException::new);
        }
        finally {
            IOUtils.closeAllUnchecked((AutoCloseable[])readers);
        }
    }

    public void validateShards(IndexAccessor[] otherShards, boolean valueUniqueness, IndexAccessor.ShardedIndexEntryConflictHandler conflictHandler, int threads, JobScheduler jobScheduler) {
        ArrayList<NativeIndexAccessor> allShards = new ArrayList<NativeIndexAccessor>();
        allShards.add(this);
        for (IndexAccessor shard : otherShards) {
            allShards.add((NativeIndexAccessor)shard);
        }
        try {
            ArrayList<JobHandle> handles = new ArrayList<JobHandle>();
            List partitionEdges = this.tree.partitionedSeek(this.lowestKey(), this.highestKey(), threads, CursorContext.NULL_CONTEXT);
            for (int p = 0; p < partitionEdges.size() - 1; ++p) {
                NativeIndexKey from = (NativeIndexKey)((Object)this.layout.copyKey((Object)((NativeIndexKey)((Object)partitionEdges.get(p)))));
                NativeIndexKey to = (NativeIndexKey)((Object)this.layout.copyKey((Object)((NativeIndexKey)((Object)partitionEdges.get(p + 1)))));
                handles.add(jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(Subject.AUTH_DISABLED, this.databaseName, "validateShard"), () -> {
                    IndexValueIterator[] readers = new IndexValueIterator[allShards.size()];
                    for (int i = 0; i < allShards.size(); ++i) {
                        NativeIndexAccessor accessor = (NativeIndexAccessor)allShards.get(i);
                        Seeker seeker = accessor.tree.seek((Object)from, (Object)to, CursorContext.NULL_CONTEXT);
                        readers[i] = new IndexValueIterator(accessor, new NativeIndexEntriesReader(seeker));
                    }
                    NativeIndexAccessor.validateShardData(conflictHandler, readers);
                    return null;
                }));
            }
            JobHandles.getAllResults(handles, RuntimeException.class, RuntimeException::new);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateShardData(IndexAccessor.ShardedIndexEntryConflictHandler conflictHandler, IndexValueIterator[] readers) {
        try {
            while (true) {
                IndexValueIterator reader;
                int shardIndex;
                int lowestShardIndex = -1;
                for (shardIndex = 0; shardIndex < readers.length; ++shardIndex) {
                    reader = readers[shardIndex];
                    if (reader.isExhausted()) continue;
                    if (lowestShardIndex == -1) {
                        lowestShardIndex = shardIndex;
                        continue;
                    }
                    int comparison = reader.reader.compareCurrentValues(readers[lowestShardIndex].reader);
                    if (comparison >= 0) continue;
                    lowestShardIndex = shardIndex;
                }
                if (lowestShardIndex == -1) {
                    break;
                }
                for (shardIndex = 0; shardIndex < readers.length; ++shardIndex) {
                    reader = readers[shardIndex];
                    if (reader.isExhausted() || shardIndex == lowestShardIndex) continue;
                    IndexValueIterator lowest = readers[lowestShardIndex];
                    if (reader.reader.compareCurrentValues(lowest.reader) != 0) continue;
                    conflictHandler.indexEntryConflict(lowest.currentEntityId, lowest.accessor, reader.currentEntityId, reader.accessor, reader.reader.values());
                    reader.next();
                }
                readers[lowestShardIndex].next();
            }
        }
        finally {
            IOUtils.closeAllUnchecked((AutoCloseable[])readers);
        }
    }

    protected IndexUpdateIgnoreStrategy indexUpdateIgnoreStrategy() {
        return IndexUpdateIgnoreStrategy.NO_IGNORE;
    }

    public void force(FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) {
        this.tree.checkpoint((Consumer)this.headerWriter, flushEvent, asyncBlockAccessor, cursorContext);
    }

    public void refresh() {
    }

    public void close() {
        this.closeTree();
    }

    public abstract ValueIndexReader newValueReader(IndexUsageTracking var1);

    public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        return new NativeAllEntriesReader(this.tree, this.layout, fromIdInclusive, toIdExclusive, cursorContext);
    }

    public long estimateNumberOfEntries(CursorContext cursorContext) {
        try {
            return this.tree.estimateNumberOfEntriesInTree(cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (TreeInconsistencyException e) {
            return -1L;
        }
    }

    public long sizeInBytes() {
        return this.tree.sizeInBytes();
    }

    public IndexEntriesReader[] newAllEntriesValueReader(int partitions, CursorContext cursorContext) {
        try {
            List partitionEdges = this.tree.partitionedSeek(this.lowestKey(), this.highestKey(), partitions, cursorContext);
            ArrayList<NativeIndexEntriesReader> readers = new ArrayList<NativeIndexEntriesReader>();
            for (int i = 0; i < partitionEdges.size() - 1; ++i) {
                Seeker seeker = this.tree.seek((Object)((NativeIndexKey)((Object)this.layout.copyKey((Object)((NativeIndexKey)((Object)partitionEdges.get(i)))))), (Object)((NativeIndexKey)((Object)this.layout.copyKey((Object)((NativeIndexKey)((Object)partitionEdges.get(i + 1)))))), cursorContext);
                readers.add(new NativeIndexEntriesReader(seeker));
            }
            return (IndexEntriesReader[])readers.toArray(IndexEntriesReader[]::new);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public IndexEntriesReader newAllEntriesValueReader(Value[] from, Value[] to, CursorContext cursorContext) {
        NativeIndexKey fromKey = (NativeIndexKey)((Object)this.layout.newKey());
        fromKey.initialize(Long.MIN_VALUE);
        if (from == null) {
            fromKey.initValuesAsLowest();
        } else {
            for (int i = 0; i < from.length; ++i) {
                fromKey.initFromValue(i, from[i], NativeIndexKey.Inclusion.NEUTRAL);
            }
        }
        NativeIndexKey toKey = (NativeIndexKey)((Object)this.layout.newKey());
        toKey.initialize(Long.MIN_VALUE);
        if (to == null) {
            toKey.initValuesAsHighest();
        } else {
            for (int i = 0; i < to.length; ++i) {
                toKey.initFromValue(i, to[i], NativeIndexKey.Inclusion.NEUTRAL);
            }
        }
        try {
            return new NativeIndexEntriesReader(this.tree.seek((Object)fromKey, (Object)toKey, cursorContext));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private KEY highestKey() {
        NativeIndexKey highest = (NativeIndexKey)((Object)this.layout.newKey());
        highest.initialize(Long.MAX_VALUE);
        highest.initValuesAsHighest();
        return (KEY)((Object)highest);
    }

    private KEY lowestKey() {
        NativeIndexKey lowest = (NativeIndexKey)((Object)this.layout.newKey());
        lowest.initialize(Long.MIN_VALUE);
        lowest.initValuesAsLowest();
        return (KEY)((Object)lowest);
    }

    private static class IndexValueIterator
    implements AutoCloseable {
        private final IndexAccessor accessor;
        private final IndexEntriesReader reader;
        private boolean isExhausted;
        private long currentEntityId;

        IndexValueIterator(IndexAccessor accessor, IndexEntriesReader reader) {
            this.accessor = accessor;
            this.reader = reader;
            this.next();
        }

        boolean isExhausted() {
            return this.isExhausted;
        }

        void next() {
            if (this.isExhausted) {
                return;
            }
            if (this.reader.hasNext()) {
                this.currentEntityId = this.reader.next();
            } else {
                this.isExhausted = true;
            }
        }

        @Override
        public void close() {
            this.reader.close();
        }
    }

    private class NativeIndexEntriesReader
    implements IndexEntriesReader {
        private final Seeker<KEY, NullValue> seeker;

        public NativeIndexEntriesReader(Seeker<KEY, NullValue> seeker) {
            this.seeker = seeker;
        }

        public long next() {
            return ((NativeIndexKey)((Object)this.seeker.key())).getEntityId();
        }

        public boolean hasNext() {
            try {
                return this.seeker.next();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public Value[] values() {
            return ((NativeIndexKey)((Object)this.seeker.key())).asValues();
        }

        public int compareCurrentValues(IndexEntriesReader other) {
            NativeIndexEntriesReader otherReader = (NativeIndexEntriesReader)other;
            return NativeIndexAccessor.this.layout.compareValue((NativeIndexKey)((Object)this.seeker.key()), (NativeIndexKey)((Object)otherReader.seeker.key()));
        }

        public void close() {
            try {
                this.seeker.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

