/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.newapi.SchemaMatcher;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.TransactionStateBehaviour;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class IndexTxStateUpdater {
    private final StorageReader storageReader;
    private final TxStateHolder txStateHolder;
    private final IndexingService indexingService;
    private final TransactionStateBehaviour stateBehaviour;

    public IndexTxStateUpdater(StorageReader storageReader, IndexingService indexingService, TxStateHolder txStateHolder, TransactionStateBehaviour stateBehaviour) {
        this.storageReader = storageReader;
        this.txStateHolder = txStateHolder;
        this.indexingService = indexingService;
        this.stateBehaviour = stateBehaviour;
    }

    void onLabelChange(NodeCursor node, PropertyCursor propertyCursor, LabelChangeType changeType, int removedLabelId, Collection<IndexDescriptor> indexes) {
        assert (this.noSchemaChangedInTx());
        if (indexes.isEmpty()) {
            return;
        }
        TransactionState txState = this.txStateHolder.txState();
        MemoryTracker memoryTracker = txState.memoryTracker();
        MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
        for (IndexDescriptor index : indexes) {
            if (this.stateBehaviour.useIndexCommands() && changeType == LabelChangeType.REMOVED_LABEL && index.schema().isSemanticSearchSchemaDescriptor() && IndexTxStateUpdater.isMultiTokenIndexStillCovered(node, removedLabelId, index)) continue;
            int[] indexPropertyIds = index.schema().getPropertyIds();
            Value[] values = IndexTxStateUpdater.getValueTuple((EntityCursor)node, propertyCursor, -1, Values.NO_VALUE, indexPropertyIds, (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
            ValueTuple valueTuple = ValueTuple.of((Value[])values);
            memoryTracker.allocateHeap(valueTuple.getShallowSize());
            switch (changeType.ordinal()) {
                case 0: {
                    this.indexingService.validateBeforeCommit(index, values, node.nodeReference());
                    txState.indexDoUpdateEntry(index, node.nodeReference(), null, valueTuple);
                    break;
                }
                case 1: {
                    txState.indexDoUpdateEntry(index, node.nodeReference(), valueTuple, null);
                }
            }
        }
    }

    void onPropertyAdd(NodeCursor node, PropertyCursor propertyCursor, int[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyAdd((EntityCursor)node, EntityType.NODE, propertyCursor, labels, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyRemove(NodeCursor node, PropertyCursor propertyCursor, int[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyRemove((EntityCursor)node, EntityType.NODE, propertyCursor, labels, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyChange(NodeCursor node, PropertyCursor propertyCursor, int[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value beforeValue, Value afterValue) {
        this.onPropertyChange((EntityCursor)node, EntityType.NODE, propertyCursor, labels, propertyKeyId, existingPropertyKeyIds, beforeValue, afterValue);
    }

    void onPropertyAdd(RelationshipScanCursor relationship, PropertyCursor propertyCursor, int type, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyAdd((EntityCursor)relationship, EntityType.RELATIONSHIP, propertyCursor, new int[]{type}, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyRemove(RelationshipScanCursor relationship, PropertyCursor propertyCursor, int type, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyRemove((EntityCursor)relationship, EntityType.RELATIONSHIP, propertyCursor, new int[]{type}, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyChange(RelationshipScanCursor relationship, PropertyCursor propertyCursor, int type, int propertyKeyId, int[] existingPropertyKeyIds, Value beforeValue, Value afterValue) {
        this.onPropertyChange((EntityCursor)relationship, EntityType.RELATIONSHIP, propertyCursor, new int[]{type}, propertyKeyId, existingPropertyKeyIds, beforeValue, afterValue);
    }

    void onDeleteUncreated(NodeCursor node, PropertyCursor propertyCursor) {
        this.onDeleteUncreated((EntityCursor)node, EntityType.NODE, propertyCursor, node.labels().all());
    }

    void onDeleteUncreated(RelationshipScanCursor relationship, PropertyCursor propertyCursor) {
        this.onDeleteUncreated((EntityCursor)relationship, EntityType.RELATIONSHIP, propertyCursor, new int[]{relationship.type()});
    }

    private boolean noSchemaChangedInTx() {
        TransactionState txState = this.txStateHolder.txState();
        return !txState.hasChanges() || txState.hasDataChanges();
    }

    private void onDeleteUncreated(EntityCursor entity, EntityType entityType, PropertyCursor propertyCursor, int[] tokens) {
        assert (this.noSchemaChangedInTx());
        entity.properties(propertyCursor, PropertySelection.ALL_PROPERTY_KEYS);
        MutableIntList propertyKeyList = IntLists.mutable.empty();
        while (propertyCursor.next()) {
            propertyKeyList.add(propertyCursor.propertyKey());
        }
        int[] propertyKeyIds = propertyKeyList.toSortedArray();
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyIds, entityType);
        if (indexes.isEmpty()) {
            return;
        }
        this.processIndexUpdates(entity, propertyCursor, indexes, -1, Values.NO_VALUE, propertyKeyIds);
    }

    private void processIndexUpdates(EntityCursor entity, PropertyCursor propertyCursor, Collection<IndexDescriptor> indexes, int propertyKeyId, Value changedValue, int[] propertyKeyIds) {
        MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
        SchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, propertyKeyIds, this.stateBehaviour, index -> {
            MemoryTracker memoryTracker = this.txStateHolder.txState().memoryTracker();
            SchemaDescriptor schema = index.schema();
            Value[] values = IndexTxStateUpdater.getValueTuple(entity, propertyCursor, propertyKeyId, changedValue, schema.getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
            ValueTuple valueTuple = ValueTuple.of((Value[])values);
            memoryTracker.allocateHeap(valueTuple.getShallowSize());
            this.txStateHolder.txState().indexDoUpdateEntry(index, entity.reference(), valueTuple, null);
        });
    }

    private void onPropertyAdd(EntityCursor entity, EntityType entityType, PropertyCursor propertyCursor, int[] tokens, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyId, entityType);
        if (indexes.isEmpty()) {
            return;
        }
        MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
        SchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, this.stateBehaviour, index -> {
            MemoryTracker memoryTracker = this.txStateHolder.txState().memoryTracker();
            SchemaDescriptor schema = index.schema();
            Value[] values = IndexTxStateUpdater.getValueTuple(entity, propertyCursor, propertyKeyId, value, schema.getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
            this.indexingService.validateBeforeCommit((IndexDescriptor)index, values, entity.reference());
            ValueTuple valueTuple = ValueTuple.of((Value[])values);
            memoryTracker.allocateHeap(valueTuple.getShallowSize());
            ValueTuple beforeValueTuple = null;
            if (this.stateBehaviour.useIndexCommands() && schema.getPropertyIds().length > 1) {
                memoryTracker.allocateHeap(valueTuple.getShallowSize());
                Value[] valuesBefore = Arrays.copyOf(values, values.length);
                int k = ArrayUtils.indexOf((int[])schema.getPropertyIds(), (int)propertyKeyId);
                valuesBefore[k] = Values.NO_VALUE;
                beforeValueTuple = ValueTuple.of((Value[])valuesBefore);
            }
            this.txStateHolder.txState().indexDoUpdateEntry(index, entity.reference(), beforeValueTuple, valueTuple);
        });
    }

    private void onPropertyRemove(EntityCursor entity, EntityType entityType, PropertyCursor propertyCursor, int[] tokens, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyId, entityType);
        if (indexes.isEmpty()) {
            return;
        }
        this.processIndexUpdates(entity, propertyCursor, indexes, propertyKeyId, value, existingPropertyKeyIds);
    }

    private void onPropertyChange(EntityCursor entity, EntityType entityType, PropertyCursor propertyCursor, int[] tokens, int propertyKeyId, int[] existingPropertyKeyIds, Value beforeValue, Value afterValue) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyId, entityType);
        if (indexes.isEmpty()) {
            return;
        }
        MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
        SchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, this.stateBehaviour, index -> {
            MemoryTracker memoryTracker = this.txStateHolder.txState().memoryTracker();
            SchemaDescriptor schema = index.schema();
            int[] propertyIds = schema.getPropertyIds();
            Value[] valuesAfter = IndexTxStateUpdater.getValueTuple(entity, propertyCursor, propertyKeyId, afterValue, propertyIds, (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
            Value[] valuesBefore = Arrays.copyOf(valuesAfter, valuesAfter.length);
            int k = ArrayUtils.indexOf((int[])propertyIds, (int)propertyKeyId);
            valuesBefore[k] = beforeValue;
            this.indexingService.validateBeforeCommit((IndexDescriptor)index, valuesAfter, entity.reference());
            ValueTuple valuesTupleBefore = ValueTuple.of((Value[])valuesBefore);
            ValueTuple valuesTupleAfter = ValueTuple.of((Value[])valuesAfter);
            memoryTracker.allocateHeap(valuesTupleBefore.getShallowSize() * 2L);
            this.txStateHolder.txState().indexDoUpdateEntry(index, entity.reference(), valuesTupleBefore, valuesTupleAfter);
        });
    }

    private static Value[] getValueTuple(EntityCursor entity, PropertyCursor propertyCursor, int changedPropertyKeyId, Value changedValue, int[] indexPropertyIds, MutableIntObjectMap<Value> materializedValues, MemoryTracker memoryTracker) {
        int k;
        Value[] values = new Value[indexPropertyIds.length];
        int missing = 0;
        for (k = 0; k < indexPropertyIds.length; ++k) {
            Value value = values[k] = indexPropertyIds[k] == changedPropertyKeyId ? changedValue : (Value)materializedValues.getIfAbsent(indexPropertyIds[k], (Function0 & Serializable)() -> Values.NO_VALUE);
            if (values[k] != Values.NO_VALUE) continue;
            ++missing;
        }
        if (missing > 0) {
            entity.properties(propertyCursor, PropertySelection.selection((int[])indexPropertyIds));
            while (missing > 0 && propertyCursor.next()) {
                k = ArrayUtils.indexOf((int[])indexPropertyIds, (int)propertyCursor.propertyKey());
                assert (k >= 0);
                if (values[k] != Values.NO_VALUE) continue;
                int propertyKeyId = indexPropertyIds[k];
                boolean thisIsTheChangedProperty = propertyKeyId == changedPropertyKeyId;
                Value value = values[k] = thisIsTheChangedProperty ? changedValue : propertyCursor.propertyValue();
                if (!thisIsTheChangedProperty) {
                    materializedValues.put(propertyKeyId, (Object)values[k]);
                    memoryTracker.allocateHeap(values[k].estimatedHeapUsage());
                }
                --missing;
            }
        }
        return values;
    }

    private static boolean isMultiTokenIndexStillCovered(NodeCursor node, int removedLabelId, IndexDescriptor index) {
        int[] nodeLabels = node.labels().all();
        int[] entityTokenIds = index.schema().getEntityTokenIds();
        for (int nodeLabel : nodeLabels) {
            if (nodeLabel == removedLabelId || !PrimitiveArrays.contains((int[])entityTokenIds, (int)nodeLabel)) continue;
            return true;
        }
        return false;
    }

    public static enum LabelChangeType {
        ADDED_LABEL,
        REMOVED_LABEL;

    }
}

