/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.SchedulerThreadFactory;

public class GroupedDaemonThreadFactory
implements SchedulerThreadFactory {
    protected final Group group;
    protected final ThreadGroup threadGroup;

    protected GroupedDaemonThreadFactory(Group group, ThreadGroup parentThreadGroup) {
        this.group = group;
        this.threadGroup = new ThreadGroup(parentThreadGroup, group.groupName());
    }

    public Thread newThread(Runnable job) {
        Thread thread = new Thread(this, this.threadGroup, job, this.group.threadName()){

            @Override
            public String toString() {
                return GroupedDaemonThreadFactory.threadToString(this);
            }
        };
        thread.setDaemon(true);
        return thread;
    }

    protected static String threadToString(Thread thread) {
        StringBuilder sb = new StringBuilder("Thread[").append(thread.getName());
        String sep = ", in ";
        for (ThreadGroup group = thread.getThreadGroup(); group != null; group = group.getParent()) {
            sb.append(sep).append(group.getName());
            sep = "/";
        }
        return sb.append(']').toString();
    }

    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        return this.allocateForkJoinThread(pool, ForkJoinPool.defaultForkJoinWorkerThreadFactory);
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    protected ForkJoinWorkerThread allocateForkJoinThread(ForkJoinPool pool, ForkJoinPool.ForkJoinWorkerThreadFactory factory) {
        AtomicReference reference = new AtomicReference();
        Thread allocator = this.newThread(() -> reference.set(factory.newThread(pool)));
        allocator.start();
        do {
            try {
                allocator.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (reference.get() == null);
        ForkJoinWorkerThread worker = (ForkJoinWorkerThread)reference.get();
        worker.setName(this.group.threadName());
        return worker;
    }
}

