/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.kernel.impl.transaction.log.pruning.TransactionLogFileInformation;

public class ThresholdBasedPruneStrategy
implements LogPruneStrategy {
    private final LogFile logFile;
    private final Threshold threshold;
    private final TransactionLogFileInformation logFileInformation;

    ThresholdBasedPruneStrategy(LogFile logFile, Threshold threshold, TransactionLogFileInformation logFileInformation) {
        this.logFile = logFile;
        this.logFileInformation = logFileInformation;
        this.threshold = threshold;
    }

    public String toString() {
        return this.threshold.toString();
    }

    @Override
    public synchronized LogPruneStrategy.VersionRange findLogVersionsToDelete(long upToVersion) {
        if (upToVersion == 0L) {
            return LogPruneStrategy.EMPTY_RANGE;
        }
        this.threshold.init();
        long lowestLogVersion = this.logFile.getLogRangeInfo().lowestVersion();
        for (long version = upToVersion; version >= lowestLogVersion; --version) {
            if (!this.threshold.reached(this.logFile.getLogFileForVersion(version), version, this.logFileInformation)) continue;
            return new LogPruneStrategy.VersionRange(lowestLogVersion, version);
        }
        return LogPruneStrategy.EMPTY_RANGE;
    }
}

