/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class ReadAndDeleteTransactionConflictException
extends GqlRuntimeException
implements Status.HasStatus {
    private static final String CONCURRENT_DELETE_MESSAGE = "Database elements (nodes, relationships, properties) were observed during query execution, but got deleted by an overlapping committed transaction before the query results could be serialised. The transaction might succeed if it is retried.";
    private static final String DELETED_IN_TRANSACTION_MESSAGE = "Database elements (nodes, relationships, properties) were deleted in this transaction, but were also included in the result set.";
    private final boolean deletedInThisTransaction;

    private ReadAndDeleteTransactionConflictException(ErrorGqlStatusObject gqlStatusObject, boolean deletedInThisTransaction) {
        super(gqlStatusObject, ReadAndDeleteTransactionConflictException.getMessageHelper(deletedInThisTransaction));
        this.deletedInThisTransaction = deletedInThisTransaction;
    }

    private ReadAndDeleteTransactionConflictException(ErrorGqlStatusObject gqlStatusObject, boolean deletedInThisTransaction, Throwable cause) {
        super(gqlStatusObject, ReadAndDeleteTransactionConflictException.getMessageHelper(deletedInThisTransaction), cause);
        this.deletedInThisTransaction = deletedInThisTransaction;
    }

    public static ReadAndDeleteTransactionConflictException conflictingTransactionState(boolean deletedInThisTransaction) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
        return new ReadAndDeleteTransactionConflictException(gql, deletedInThisTransaction);
    }

    public static ReadAndDeleteTransactionConflictException conflictingTransactionState(boolean deletedInThisTransaction, Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
        return new ReadAndDeleteTransactionConflictException(gql, deletedInThisTransaction, e);
    }

    public boolean wasDeletedInThisTransaction() {
        return this.deletedInThisTransaction;
    }

    private static String getMessageHelper(boolean deletedInThisTransaction) {
        return deletedInThisTransaction ? DELETED_IN_TRANSACTION_MESSAGE : CONCURRENT_DELETE_MESSAGE;
    }

    public Status status() {
        return this.deletedInThisTransaction ? Status.Statement.EntityNotFound : Status.Transaction.Outdated;
    }
}

