/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.neo4j.cloud.storage.SchemeFileSystemAbstraction;
import org.neo4j.cloud.storage.StorageSchemeResolver;
import org.neo4j.common.Validator;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.util.Preconditions;

public final class Validators {
    public static final Validator<Path> CONTAINS_EXISTING_DATABASE = dbDir -> {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            if (!Validators.isExistingDatabase((FileSystemAbstraction)fileSystem, DatabaseLayout.ofFlat((Path)dbDir))) {
                throw new IllegalArgumentException("Directory '" + String.valueOf(dbDir) + "' does not contain a database");
            }
        }
    };

    private Validators() {
    }

    static List<Path> matchingFiles(FileSystemAbstraction fs, String fileWithRegexInName) {
        List<Path> paths = StorageSchemeResolver.isSchemeBased((String)fileWithRegexInName) ? Validators.matchingStorageFiles(fs, fileWithRegexInName) : Validators.matchingLocalFiles(fileWithRegexInName);
        if (paths.isEmpty()) {
            throw new IllegalArgumentException("File '" + fileWithRegexInName + "' doesn't exist");
        }
        return paths;
    }

    public static boolean isExistingDatabase(FileSystemAbstraction fileSystem, DatabaseLayout layout) {
        return StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fileSystem, (DatabaseLayout)layout).isPresent();
    }

    public static boolean isExistingDatabase(StorageEngineFactory.Selector storageEngineSelector, FileSystemAbstraction fileSystem, DatabaseLayout layout) {
        return storageEngineSelector.selectStorageEngine(fileSystem, layout).isPresent();
    }

    public static <T> Validator<T> emptyValidator() {
        return value -> {};
    }

    private static List<Path> matchingLocalFiles(String fileWithRegexInName) {
        String parentSafeFileName = fileWithRegexInName.replace("\\\\", "__");
        File absoluteParentSafeFile = new File(parentSafeFileName).getAbsoluteFile();
        File parent = absoluteParentSafeFile.getParentFile();
        Preconditions.checkState((parent != null && parent.exists() ? 1 : 0) != 0, (String)"Directory %s of %s doesn't exist", (Object[])new Object[]{parent, fileWithRegexInName});
        int fileNameLength = absoluteParentSafeFile.getAbsolutePath().length() - parent.getAbsolutePath().length() - 1;
        String patternString = fileWithRegexInName.substring(fileWithRegexInName.length() - fileNameLength).replace("\\\\", "\\");
        Pattern pattern = Pattern.compile(patternString);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (File file : parent.listFiles()) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            paths.add(file.toPath());
        }
        return paths;
    }

    private static List<Path> matchingStorageFiles(FileSystemAbstraction fs, String pathWithRegexInName) {
        Preconditions.checkArgument((boolean)(fs instanceof SchemeFileSystemAbstraction), (String)("File system provided is not scheme based and cannot resolve the path: " + pathWithRegexInName));
        SchemeFileSystemAbstraction system = (SchemeFileSystemAbstraction)fs;
        int ix = pathWithRegexInName.lastIndexOf("/");
        Preconditions.checkArgument((ix != -1 ? 1 : 0) != 0, (String)("Invalid storage path provided: " + pathWithRegexInName));
        String parentPath = pathWithRegexInName.substring(0, ix);
        String patternString = pathWithRegexInName.substring(ix + 1);
        try {
            Path parent = system.resolve(parentPath);
            Pattern pattern = Pattern.compile(patternString);
            ArrayList<Path> paths = new ArrayList<Path>();
            for (Path child : system.listFiles(parent)) {
                if (!pattern.matcher(child.getFileName().toString()).matches()) continue;
                paths.add(child);
            }
            return paths;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

