/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import java.util.Objects;
import java.util.Optional;
import org.neo4j.kernel.database.NamedDatabaseId;

public record DatabaseLogIdentifier(String prefix, String databaseName, String databaseId, Optional<String> externalId) {
    public static final DatabaseLogIdentifier EMPTY = new DatabaseLogIdentifier("", "", "", Optional.empty());

    public static DatabaseLogIdentifier create(NamedDatabaseId namedDatabaseId) {
        return DatabaseLogIdentifier.create(namedDatabaseId, Optional.empty());
    }

    public static DatabaseLogIdentifier create(NamedDatabaseId namedDatabaseId, Optional<String> externalId) {
        Objects.requireNonNull(namedDatabaseId, "database id must be present");
        return new DatabaseLogIdentifier("[%s] ".formatted(namedDatabaseId.logPrefix()), namedDatabaseId.name(), namedDatabaseId.databaseId().uuid().toString(), externalId);
    }
}

