/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import org.neo4j.logging.AbstractLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.DatabaseLog;
import org.neo4j.logging.internal.DatabaseLogIdentifier;

public class DatabaseLogProvider
extends AbstractLogProvider<DatabaseLog> {
    private final DatabaseLogIdentifier databaseLogIdentifier;
    private final InternalLogProvider logProvider;

    public static DatabaseLogProvider nullDatabaseLogProvider() {
        return new DatabaseLogProvider(DatabaseLogIdentifier.EMPTY, (InternalLogProvider)NullLogProvider.getInstance());
    }

    public DatabaseLogProvider(DatabaseLogIdentifier databaseLogIdentifier, InternalLogProvider logProvider) {
        this.databaseLogIdentifier = databaseLogIdentifier;
        this.logProvider = logProvider;
    }

    protected DatabaseLog buildLog(Class<?> loggingClass) {
        return new DatabaseLog(this.databaseLogIdentifier, this.logProvider.getLog(loggingClass));
    }

    protected DatabaseLog buildLog(String name) {
        return new DatabaseLog(this.databaseLogIdentifier, this.logProvider.getLog(name));
    }
}

