/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping;

import java.util.function.LongPredicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.batchimport.api.PropertyValueLookup;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.idmapping.cuckoo.KeyCollisionException;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

public interface IdMapper
extends MemoryStatsVisitor.Visitable,
AutoCloseable {
    public static final long ID_NOT_FOUND = -1L;

    public void remove(Object var1, long var2, Group var4);

    default public void remove(Object[] inputIds, long[] actualIds, Group[] groups) {
        if (!(1.$assertionsDisabled || inputIds.length == actualIds.length && actualIds.length == groups.length)) {
            throw new AssertionError();
        }
        for (int i = 0; i < inputIds.length; ++i) {
            this.remove(inputIds[i], actualIds[i], groups[i]);
        }
    }

    public boolean needsPreparation();

    public void prepare(PropertyValueLookup var1, Collector var2, ProgressMonitorFactory var3, LongSet var4);

    public Getter newGetter();

    public Setter newSetter();

    @Override
    public void close();

    public MemoryStatsVisitor.Visitable memoryEstimation(long var1);

    public LongIterator leftOverDuplicateNodesIds();

    public LongPredicate leftOverDuplicateNodesIdsPredicate();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface Setter {
        public void put(Object var1, long var2, Group var4) throws KeyCollisionException;

        default public boolean[] put(Object[] inputIds, long[] actualIds, Group[] groups) {
            if (!(1.$assertionsDisabled || inputIds.length == actualIds.length && actualIds.length == groups.length)) {
                throw new AssertionError();
            }
            boolean[] result = new boolean[inputIds.length];
            for (int i = 0; i < inputIds.length; ++i) {
                try {
                    this.put(inputIds[i], actualIds[i], groups[i]);
                    result[i] = true;
                    continue;
                }
                catch (KeyCollisionException e) {
                    result[i] = false;
                }
            }
            return result;
        }
    }

    public static interface Getter
    extends AutoCloseable {
        public long get(Object var1, Group var2);

        default public long[] get(Object[] inputIds, Group[] groups) {
            if (!1.$assertionsDisabled && inputIds.length != groups.length) {
                throw new AssertionError();
            }
            long[] result = new long[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                result[i] = inputIds[i] == null ? -1L : this.get(inputIds[i], groups[i]);
            }
            return result;
        }

        @Override
        public void close();
    }
}

